/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.reference.TableAttributesInfo;
import com.intellij.liquibase.orm.LiquibaseModelObjectFactory;
import com.intellij.liquibase.orm.extension.OrmDiffModelProvider;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.BooleanUtil;

public class ColumnSnapshotGenerator
extends IntellijSnapshotGenerator {
    public ColumnSnapshotGenerator() {
        super(Column.class, new Class[]{Table.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        return super.getPriority(objectType, database) - 5;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Column column = (Column)example;
        if (BooleanUtil.isTrue((Boolean)column.getComputed()) || BooleanUtil.isTrue((Boolean)column.getDescending())) {
            return example;
        }
        if (column.getType() == null) {
            if (column.getRelation() == null) {
                throw new InvalidExampleException("No relation set on " + String.valueOf(column));
            }
            Relation relation = (Relation)snapshot.get((DatabaseObject)column.getRelation());
            if (relation != null) {
                for (Column columnSnapshot : relation.getColumns()) {
                    if (!columnSnapshot.getName().equalsIgnoreCase(column.getName())) continue;
                    return columnSnapshot;
                }
            }
            ColumnSnapshotGenerator.snapshotColumn((Column)example, snapshot);
        }
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!(foundObject instanceof Table)) {
            return;
        }
        Table foundTable = (Table)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        String tableName = foundObject.getName();
        Schema schema = foundTable.getSchema();
        String schemaName = schema == null || schema.isDefault() ? null : schema.getName();
        TableAttributesInfo attributesInfo = database.getLiquibaseGenerator().getTableAttributes(schemaName, tableName, database.getOrmEntitiesToProcess());
        if (attributesInfo == null) {
            return;
        }
        OrmDiffModelProvider ormDiffModelProvider = this.getOrmDiffModelProvider(snapshot);
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        HashSet<String> processedColumnNames = new HashSet<String>();
        OrmEntity ormEntity = attributesInfo.getOrmEntity();
        for (OrmEntityAttribute ormEntityAttribute : attributesInfo.getOrmAttributes()) {
            Column column;
            String columnName;
            String attrColumnName = ormDiffModelProvider.getColumnName(ormEntityAttribute, ormEntity);
            if (StringUtil.isEmpty((String)attrColumnName) || !processedColumnNames.add(columnName = (column = dbObjectFactory.createColumn(attrColumnName)).getName())) continue;
            column.setRelation((Relation)foundTable);
            column.setRemarks(ormDiffModelProvider.getComment(ormEntityAttribute));
            ColumnSnapshotGenerator.snapshotColumn(column, snapshot);
            foundTable.getColumns().add(column);
        }
    }

    protected static void snapshotColumn(Column column, DatabaseSnapshot snapshot) {
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        LiquibaseUtils.setColumnDatatype(column, database);
    }
}

