/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.junit5.report.AbstractTestReporter;
import com.intellij.junit5.report.ExecutionState;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;
import org.opentest4j.MultipleFailuresError;

public class TestReporter
extends AbstractTestReporter {
    private final String name;

    public TestReporter(TestIdentifier identifier, ExecutionState state, String name) {
        super(identifier, state);
        this.name = name;
    }

    public TestReporter(TestIdentifier identifier, ExecutionState state) {
        this(identifier, state, identifier.getDisplayName());
    }

    @Override
    protected String name() {
        return this.name;
    }

    @Override
    public List<String> start() {
        this.state.onLeafTestStarted();
        String start = MapSerializerUtil.asString((String)"testStarted", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO));
        return Collections.singletonList(start);
    }

    @Override
    public List<String> finish(TestExecutionResult result) {
        Throwable ex = result.getThrowable().orElse(null);
        long duration = this.state.onLeafTestFinishedAndGetDurationMs();
        ArrayList<String> out = new ArrayList<String>();
        switch (result.getStatus()) {
            case ABORTED: {
                out.addAll(this.reportFailure(ex, duration, true, "testIgnored"));
                break;
            }
            case FAILED: {
                out.addAll(this.reportFailure(ex, duration, true, "testFailed"));
                break;
            }
        }
        Map<String, String> attributes = this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID);
        if (duration > 0L) {
            attributes.put("duration", Long.toString(duration));
        }
        out.add(MapSerializerUtil.asString((String)"testFinished", attributes));
        this.state.incrementFinishCount();
        return out;
    }

    @Override
    public List<String> treeStarted() {
        String started = MapSerializerUtil.asString((String)"suiteTreeNode", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO));
        return Collections.singletonList(started);
    }

    @Override
    public List<String> treeFinished() {
        return Collections.emptyList();
    }

    @Override
    public List<String> skip(String reason) {
        ArrayList<String> out = new ArrayList<String>(this.reportFailure(null, 0L, true, "testIgnored", reason));
        out.add(MapSerializerUtil.asString((String)"testFinished", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID)));
        this.state.incrementFinishCount();
        return out;
    }

    private List<String> reportFailure(Throwable ex, long duration, boolean includeThrowable, String messageType) {
        return this.reportFailure(ex, duration, includeThrowable, messageType, null);
    }

    protected List<String> ignore(Throwable ex, String reason) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(MapSerializerUtil.asString((String)"testStarted", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID, AbstractTestReporter.ReportedField.HINT, AbstractTestReporter.ReportedField.METAINFO)));
        out.addAll(this.reportFailure(ex, 0L, true, "testIgnored", reason));
        out.add(MapSerializerUtil.asString((String)"testFinished", this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID)));
        return out;
    }

    List<String> reportFailure(Throwable ex, long duration, boolean includeThrowable, String messageType, String reason) {
        Map<String, String> attributes = this.attributes(AbstractTestReporter.ReportedField.ID, AbstractTestReporter.ReportedField.NAME, AbstractTestReporter.ReportedField.NODE_ID, AbstractTestReporter.ReportedField.PARENT_NODE_ID);
        if (duration > 0L) {
            attributes.put("duration", Long.toString(duration));
        }
        if (reason != null) {
            attributes.put("message", reason);
        }
        ArrayList<String> out = new ArrayList<String>();
        if (ex != null) {
            ComparisonFailureData failureData = null;
            if (ex instanceof MultipleFailuresError && ((MultipleFailuresError)ex).hasFailures()) {
                for (Throwable t : ((MultipleFailuresError)ex).getFailures()) {
                    out.addAll(this.reportFailure(t, duration, true, messageType, reason));
                }
            } else {
                try {
                    failureData = ExpectedPatterns.createExceptionNotification((Throwable)ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)(includeThrowable ? TestReporter.getTrace(ex) : ""), (String)ex.getMessage(), attributes, (Throwable)ex, (String)"Comparison Failure: ", (String)"expected: <");
        }
        out.add(MapSerializerUtil.asString((String)messageType, attributes));
        return out;
    }
}

