/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.ui.VmOptionsEditor;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.ApplicationPropertiesAutoCompletionListProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootPropertyValueCompletionUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/boot/run/SpringBootVmOptionsCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillConfigKeyPathCompletionVariants", "optionText", "", "module", "Lcom/intellij/openapi/module/Module;", "getOptionText", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "intellij.spring.boot.run"})
public final class SpringBootVmOptionsCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Document document = parameters.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Object object = document2.getUserData(VmOptionsEditor.SETTINGS_KEY);
        SpringBootApplicationRunConfigurationBase springBootApplicationRunConfigurationBase = object instanceof SpringBootApplicationRunConfigurationBase ? (SpringBootApplicationRunConfigurationBase)object : null;
        if (springBootApplicationRunConfigurationBase == null) {
            return;
        }
        SpringBootApplicationRunConfigurationBase configuration = springBootApplicationRunConfigurationBase;
        Module module = configuration.getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        String string = this.getOptionText(document2, parameters.getOffset());
        if (string == null) {
            return;
        }
        String optionText = string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)optionText, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex < 0) {
            this.fillConfigKeyPathCompletionVariants(result, optionText, module2);
            return;
        }
        String string2 = optionText.substring(0, separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String keyText = string2;
        MetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module2, keyText);
        if (metaConfigKey == null) {
            return;
        }
        MetaConfigKey key = metaConfigKey;
        List<Object> variants = SpringBootPropertyValueCompletionUtils.getValueCompletionVariants(key, module2, keyText);
        new ApplicationPropertiesAutoCompletionListProvider((Collection)variants).fillCompletionVariants(parameters, "", result);
    }

    private final void fillConfigKeyPathCompletionVariants(CompletionResultSet result, String optionText, Module module) {
        if (!StringsKt.contains$default((CharSequence)optionText, (char)'.', (boolean)false, (int)2, null)) {
            return;
        }
        Object keyText = StringsKt.endsWith$default((String)optionText, (String)".", (boolean)false, (int)2, null) ? optionText + "a" : optionText;
        PsiElement keyNode = ApplicationPropertiesAutoCompletionListProvider.Companion.createFakeKeyNode(module, "application.properties", (String)keyText);
        keyNode.getContainingFile().putUserData(SpringBootConfigurationFileService.CONFIGURATION_FILE_MARKER_KEY, (Object)true);
        TextRange textRange = TextRange.create((int)(StringsKt.lastIndexOf$default((CharSequence)((CharSequence)keyText), (char)'.', (int)0, (boolean)false, (int)6, null) + 1), (int)((String)keyText).length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        PsiReference[] psiReferenceArray = keyNode.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        for (PsiReference reference : psiReferenceArray) {
            Object[] variants;
            if (reference instanceof MetaConfigKeyReference || !range.contains(reference.getRangeInElement())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)reference.getVariants(), (String)"getVariants(...)");
            for (Object variant : variants) {
                if (!(variant instanceof LookupElement)) continue;
                result.addElement((LookupElement)variant);
            }
        }
    }

    private final String getOptionText(Document document, int offset) {
        int optionStart;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        for (optionStart = offset; optionStart > 0 && !Character.isWhitespace(text.charAt(optionStart - 1)); --optionStart) {
        }
        String string2 = text.substring(optionStart, offset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String optionText = string2;
        if (!StringsKt.startsWith$default((String)optionText, (String)"-D", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = optionText.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }
}

