/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.microservices.jvm.config.ConfigTunnelPortMapping;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.ApplicationUrlLiveProperty;
import com.intellij.spring.boot.run.lifecycle.AsyncLiveProperty;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.EndpointLiveProperty;
import com.intellij.spring.boot.run.lifecycle.JmxServiceUrlLiveProperty;
import com.intellij.spring.boot.run.lifecycle.LifecycleErrorHandler;
import com.intellij.spring.boot.run.lifecycle.LifecycleException;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.ReadLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ReadyStateLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerConfigurationLiveProperty;
import com.intellij.spring.boot.run.lifecycle.ServerPortLiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootLiveBeansConnector;
import com.intellij.spring.boot.run.lifecycle.SpringBootModuleDescriptor;
import com.intellij.spring.boot.run.lifecycle.beans.BeansEndpoint;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeansSnapshotParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootApplicationInfoImpl
implements SpringBootApplicationInfo {
    private static final String NOTIFICATION_DISPLAY_ID = "Spring Boot Application Endpoints";
    private final RunConfiguration myConfiguration;
    private final Module myModule;
    private final ProcessHandler myProcessHandler;
    private final LiveProperty<SpringBootModuleDescriptor> myModuleDescriptor;
    private final LiveProperty<Boolean> myReadyState;
    private final LiveProperty<Integer> myServerPort;
    private final LiveProperty<SpringBootApplicationServerConfiguration> myServerConfiguration;
    private final Map<String, LiveProperty<?>> myEndpoints;
    private final LiveProperty<String> myApplicationUrl;
    private volatile boolean myDisposed;

    static SpringBootApplicationInfo createInfo(@NotNull Project project, @NotNull Module module, @NotNull SpringBootApplicationRunConfigurationBase configuration, @Nullable String activeProfiles, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(3);
        }
        SpringBootApplicationInfoImpl info = new SpringBootApplicationInfoImpl(project, module, configuration, activeProfiles, processHandler);
        for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
            endpoint.infoCreated(project, processHandler, (SpringBootApplicationInfo)info);
        }
        info.myModuleDescriptor.compute();
        return info;
    }

    private SpringBootApplicationInfoImpl(final @NotNull Project project, final @NotNull Module module, @NotNull SpringBootApplicationRunConfigurationBase configuration, final @Nullable String activeProfiles, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        this.myEndpoints = new HashMap();
        this.myConfiguration = configuration;
        this.myProcessHandler = processHandler;
        this.myModule = module;
        LifecycleErrorHandler errorHandler = message -> {
            if (this.myDisposed) {
                return;
            }
            NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_DISPLAY_ID).createNotification(configuration.getName(), message, NotificationType.ERROR).notify(project);
        };
        ReadLiveProperty<SpringBootModuleDescriptor> moduleDescriptor = new ReadLiveProperty<SpringBootModuleDescriptor>(this, errorHandler, SpringBootModuleDescriptor.DEFAULT_DESCRIPTOR){

            @Override
            protected SpringBootModuleDescriptor doCompute() {
                SpringBootModuleDescriptor moduleDescriptor = SpringBootModuleDescriptor.getDescriptor(module, activeProfiles);
                for (Endpoint endpoint : Endpoint.EP_NAME.getExtensionList()) {
                    moduleDescriptor.setEndpointAvailable(endpoint, endpoint.isAvailable(module));
                }
                return moduleDescriptor;
            }
        };
        Disposer.register((Disposable)this, (Disposable)moduleDescriptor);
        this.myModuleDescriptor = moduleDescriptor;
        final JmxServiceUrlLiveProperty serviceUrl = new JmxServiceUrlLiveProperty(errorHandler, (Disposable)this, processHandler, configuration);
        this.myReadyState = new ReadyStateLiveProperty(this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this);
        ServerPortLiveProperty serverPort = new ServerPortLiveProperty(this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this);
        ConfigTunnelPortMapping portMapping = (ConfigTunnelPortMapping)ConfigTunnelPortMapping.MAPPING_KEY.get((UserDataHolder)processHandler);
        if (portMapping != null) {
            serverPort.setMapping(portMapping);
        }
        this.myServerPort = serverPort;
        this.myServerConfiguration = new ServerConfigurationLiveProperty(this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this);
        Endpoint<LiveBeansModel> beansEndpoint = BeansEndpoint.getInstance();
        final EndpointLiveProperty<LiveBeansModel> beans3Endpoint = new EndpointLiveProperty<LiveBeansModel>(beansEndpoint, this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this, null);
        final AsyncLiveProperty<LiveBeansModel> liveBeansModel = new AsyncLiveProperty<LiveBeansModel>(errorHandler, (Disposable)this){

            @Override
            protected LiveBeansModel doCompute() throws LifecycleException {
                SpringBootModuleDescriptor moduleDescriptor = Objects.requireNonNull((SpringBootModuleDescriptor)SpringBootApplicationInfoImpl.this.myModuleDescriptor.getValue());
                SpringBootLibraryUtil.SpringBootVersion version = moduleDescriptor.getVersion();
                if (version != null && version.isAtLeast(SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0)) {
                    return (LiveBeansModel)beans3Endpoint.doCompute();
                }
                SpringBootLiveBeansConnector connector = new SpringBootLiveBeansConnector((String)serviceUrl.getValue());
                try {
                    String snapshot = connector.getSnapshot();
                    LiveBeansSnapshotParser parser = new LiveBeansSnapshotParser();
                    LiveBeansModel liveBeansModel = parser.parse(snapshot);
                    return liveBeansModel;
                }
                catch (Exception e) {
                    throw new LifecycleException(SpringBootRunBundle.message("spring.boot.application.endpoints.error.failed.to.retrieve.application.beans.snapshot", e.getLocalizedMessage()), e);
                }
                finally {
                    try {
                        connector.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        };
        this.myEndpoints.put(beansEndpoint.getId(), liveBeansModel);
        for (Endpoint endpoint : (Endpoint[])Endpoint.EP_NAME.getExtensions()) {
            if (endpoint == beansEndpoint) continue;
            EndpointLiveProperty endpointData = new EndpointLiveProperty(endpoint, this.myModuleDescriptor, serviceUrl, errorHandler, (Disposable)this, (LiveProperty<? extends LiveBeansModel>)liveBeansModel);
            this.myEndpoints.put(endpoint.getId(), endpointData);
        }
        this.myApplicationUrl = new ApplicationUrlLiveProperty(errorHandler, (Disposable)this).withServerPort(this.myServerPort).withServerConfiguration(this.myServerConfiguration);
        this.myModuleDescriptor.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                SpringBootApplicationInfoImpl.this.myReadyState.compute();
            }
        });
        this.myReadyState.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardListener.DASHBOARD_TOPIC)).configurationChanged(SpringBootApplicationInfoImpl.this.myConfiguration, false);
                SpringBootApplicationInfoImpl.this.myServerPort.compute();
                liveBeansModel.compute();
            }

            public void computationFailed(@NotNull Exception e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardListener.DASHBOARD_TOPIC)).configurationChanged(SpringBootApplicationInfoImpl.this.myConfiguration, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl$4", "computationFailed"));
            }
        });
        liveBeansModel.addPropertyListener(new LiveProperty.LivePropertyListener(){

            public void propertyChanged() {
            }

            public void computationFinished() {
                for (LiveProperty<?> endpointData : SpringBootApplicationInfoImpl.this.myEndpoints.values()) {
                    if (endpointData == liveBeansModel) continue;
                    endpointData.compute();
                }
            }
        });
        this.myServerPort.addPropertyListener(() -> {
            ((RunDashboardListener)project.getMessageBus().syncPublisher(RunDashboardListener.DASHBOARD_TOPIC)).configurationChanged(this.myConfiguration, false);
            this.myServerConfiguration.compute();
        });
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunConfiguration runConfiguration = this.myConfiguration;
        if (runConfiguration == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return runConfiguration;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return module;
    }

    @NotNull
    public Collection<Module> getDependencies() {
        Collection<Module> collection = SpringBootApplicationInfoImpl.getModuleDependencies(this.myModule);
        if (collection == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return processHandler;
    }

    @NotNull
    public LiveProperty<Boolean> getReadyState() {
        LiveProperty<Boolean> liveProperty = this.myReadyState;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<Integer> getServerPort() {
        LiveProperty<Integer> liveProperty = this.myServerPort;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<SpringBootApplicationServerConfiguration> getServerConfiguration() {
        LiveProperty<SpringBootApplicationServerConfiguration> liveProperty = this.myServerConfiguration;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return liveProperty;
    }

    @NotNull
    public LiveProperty<String> getApplicationUrl() {
        LiveProperty<String> liveProperty = this.myApplicationUrl;
        if (liveProperty == null) {
            SpringBootApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        return liveProperty;
    }

    public <T> LiveProperty<T> getEndpointData(Endpoint<T> endpoint) {
        return this.myEndpoints.get(endpoint.getId());
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private static Collection<Module> getModuleDependencies(Module module) {
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            return CachedValueProvider.Result.create(dependencies, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadyState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerPort";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

