/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.configuration;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.AdditionalTabComponentManagerEx;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionLookupElementDecorator;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.properties.AutoPopupTailTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.RunConfigurationExtender;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationOptions;
import com.intellij.spring.boot.run.SpringBootConfigurationExtenderProducer;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.configuration.SpringBootProfileRefactoringListener;
import com.intellij.spring.boot.run.lifecycle.configuration.SpringBootRunConfigurationFragmentedEditorEx;
import com.intellij.spring.boot.run.lifecycle.configuration.SpringBootRunConfigurationTaskStateEx;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootApplicationEndpointsTab;
import com.intellij.spring.boot.run.statistics.SpringBootRunFeatureUsagesCollector;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.spring.boot.run.update.TriggerFilePolicy;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootRunConfigurationExtender
implements RunConfigurationExtender {
    private static final TailType EQUAL_TAIL = AutoPopupTailTypes.charType((char)'=');
    private static final String HILLA_MAVEN = "dev.hilla:hilla-dev";
    public static final String JMX_REMOTE_PARAMETER = "-Dcom.sun.management.jmxremote";
    public static final String SPRING_JMX_PARAMETER = "-Dspring.jmx.enabled=true";
    public static final String LIVE_BEAN_PARAMETER = "-Dspring.liveBeansView.mbeanDomain";
    public static final String LIFECYCLE_PARAMETER = "-Dspring.application.admin.enabled=true";
    public static final String EXPOSE_JMX_ENDPOINTS_PARAMETER = "-Dmanagement.endpoints.jmx.exposure.include=*";
    private final Project myProject;
    SpringBootApplicationRunConfiguration myConfiguration;
    @NotNull
    private final SpringBootApplicationRunConfigurationOptions myOptions;
    private final Module myModule;

    public SpringBootRunConfigurationExtender(SpringBootApplicationRunConfiguration configuration, @NotNull SpringBootApplicationRunConfigurationOptions options) {
        if (options == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(0);
        }
        this.myProject = configuration.getProject();
        this.myModule = configuration.getModule();
        this.myOptions = options;
        this.myConfiguration = configuration;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new SpringBootRunConfigurationFragmentedEditorEx(this);
    }

    @NotNull
    public RunConfigurationTaskState getRunConfigurationTaskState(boolean isDelegated, @NotNull Supplier<JavaParameters> javaParametersSupplier) {
        if (javaParametersSupplier == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(1);
        }
        return new SpringBootRunConfigurationTaskStateEx(this, isDelegated, javaParametersSupplier);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.checkUpdateActionUpdatePolicy();
        this.checkFrameDeactivationUpdatePolicy();
    }

    public void checkUpdateActionUpdatePolicy() throws RuntimeConfigurationException {
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        SpringBootApplicationUpdatePolicy policy = this.getUpdateActionUpdatePolicy();
        if (policy != null && !policy.isAvailableForConfiguration((SpringBootApplicationRunConfigurationBase)this.myConfiguration)) {
            throw new RuntimeConfigurationWarning(SpringBootRunBundle.message("spring.boot.application.run.configuration.policy.not.available.on.update.action", policy.getName()));
        }
    }

    public void checkFrameDeactivationUpdatePolicy() throws RuntimeConfigurationException {
        SpringBootApplicationUpdatePolicy policy = this.getFrameDeactivationUpdatePolicy();
        if (policy != null && !policy.isAvailableForConfiguration((SpringBootApplicationRunConfigurationBase)this.myConfiguration)) {
            throw new RuntimeConfigurationWarning(SpringBootRunBundle.message("spring.boot.application.run.configuration.policy.not.available.on.frame.deactivation", policy.getName()));
        }
    }

    public SpringBootApplicationUpdatePolicy getUpdateActionUpdatePolicy() {
        return SpringBootApplicationUpdatePolicy.findPolicy((String)this.myOptions.getUpdateActionUpdatePolicy());
    }

    public void setUpdateActionUpdatePolicy(SpringBootApplicationUpdatePolicy updatePolicy) {
        this.myOptions.setUpdateActionUpdatePolicy(updatePolicy == null ? null : updatePolicy.getId());
    }

    public SpringBootApplicationUpdatePolicy getFrameDeactivationUpdatePolicy() {
        return SpringBootApplicationUpdatePolicy.findPolicy((String)this.myOptions.getFrameDeactivationUpdatePolicy());
    }

    public void setFrameDeactivationUpdatePolicy(SpringBootApplicationUpdatePolicy updatePolicy) {
        this.myOptions.setFrameDeactivationUpdatePolicy(updatePolicy == null ? null : updatePolicy.getId());
    }

    public void setDefaultFrameDeactivationUpdatePolicy() {
        if (Registry.is((String)"spring.boot.run.config.devtools.update.enabled") && SpringBootLibraryUtil.hasDevtools((Module)this.myModule) && !SpringBootRunConfigurationExtender.hasHilla(this.myModule)) {
            SpringBootApplicationUpdatePolicy updatePolicy = SpringBootApplicationUpdatePolicy.findPolicy((String)"UpdateClassesAndResources");
            this.setFrameDeactivationUpdatePolicy(updatePolicy);
        }
    }

    public void restoreCorruptedDefaults() {
        if (Objects.equals(this.myOptions.getFrameDeactivationUpdatePolicy(), "UnknownPolicyInFreeMode")) {
            this.setDefaultFrameDeactivationUpdatePolicy();
        }
    }

    public boolean isEnableJmxAgent() {
        return this.myOptions.getEnableJmxAgent();
    }

    public void setEnableJmxAgent(boolean value) {
        this.myOptions.setEnableJmxAgent(value);
    }

    public boolean isLifecycleManagementEnabled() {
        return this.isEnableJmxAgent() && (Boolean)ReadAction.compute(() -> SpringBootLibraryUtil.isAtLeastVersion((Module)this.myModule, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) != false;
    }

    public void setupJmxParameters(ParametersList vmParametersList) {
        if (!this.isLifecycleManagementEnabled()) {
            return;
        }
        vmParametersList.add(JMX_REMOTE_PARAMETER);
        vmParametersList.add(SPRING_JMX_PARAMETER);
        vmParametersList.add(LIVE_BEAN_PARAMETER);
        vmParametersList.add(LIFECYCLE_PARAMETER);
        boolean is20 = (Boolean)ReadAction.compute(() -> SpringBootLibraryUtil.isAtLeastVersion((Module)this.myModule, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0));
        if (is20) {
            vmParametersList.add(EXPOSE_JMX_ENDPOINTS_PARAMETER);
        }
    }

    public void applyAdditionalSpringBootSettings(JavaParameters params) {
        ParametersList vmParametersList = params.getVMParametersList();
        if (this.getUpdateActionUpdatePolicy() instanceof TriggerFilePolicy) {
            vmParametersList.add("-Dspring.devtools.restart.trigger-file=.restartTriggerFile");
        }
        this.setupJmxParameters(vmParametersList);
    }

    public void reportStatistic(@NotNull @NotNull Set<@NotNull MetricEvent> metrics) {
        if (metrics == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(2);
        }
        metrics.add(SpringBootRunFeatureUsagesCollector.CONFIG_ENABLE_JMX_AGENT.metric((Object)this.isEnableJmxAgent()));
        metrics.add(SpringBootRunFeatureUsagesCollector.CONFIG_UPDATE_ACTION_UPDATE_POLICY.metric((Object)SpringBootRunConfigurationExtender.getUpdatePolicyDescriptor(this.getUpdateActionUpdatePolicy())));
        metrics.add(SpringBootRunFeatureUsagesCollector.CONFIG_FRAME_DEACTIVATION_UPDATE_POLICY.metric((Object)SpringBootRunConfigurationExtender.getUpdatePolicyDescriptor(this.getFrameDeactivationUpdatePolicy())));
    }

    private static String getUpdatePolicyDescriptor(@Nullable SpringBootApplicationUpdatePolicy policy) {
        if (policy == null) {
            return "Nothing";
        }
        return PluginInfoDetectorKt.getPluginInfo(policy.getClass()).isDevelopedByJetBrains() ? policy.getId() : "third.party";
    }

    private static boolean hasHilla(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)HILLA_MAVEN);
    }

    public void createAdditionalTabComponents(@NotNull AdditionalTabComponentManager manager, @NotNull ProcessHandler startedProcess) {
        if (manager == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(3);
        }
        if (startedProcess == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(4);
        }
        if (manager instanceof AdditionalTabComponentManagerEx) {
            AdditionalTabComponentManagerEx managerEx = (AdditionalTabComponentManagerEx)manager;
            if (this.isLifecycleManagementEnabled()) {
                SpringBootApplicationRunConfiguration clone = (SpringBootApplicationRunConfiguration)this.myConfiguration.clone();
                for (Endpoint endpoint : Endpoint.EP_NAME.getExtensionList()) {
                    SpringBootApplicationEndpointsTab tab;
                    Content content;
                    final EndpointTab endpointTab = endpoint.createEndpointTab((SpringBootApplicationRunConfigurationBase)clone, startedProcess);
                    if (endpointTab == null || (content = managerEx.addAdditionalTabComponent((AdditionalTabComponent)(tab = new SpringBootApplicationEndpointsTab(endpointTab)), tab.getTabTitle(), endpointTab.getIcon(), false)) == null) continue;
                    ContentManager contentManager = SpringBootRunConfigurationExtender.initializeContentManagement(content, tab);
                    tab.setContentManager(contentManager);
                    Endpoint.EP_NAME.addExtensionPointListener(new ExtensionPointListener<Endpoint<?>>(this){

                        public void extensionRemoved(@NotNull Endpoint<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                            ContentManager contentManager;
                            if (extension == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (pluginDescriptor == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (endpointTab.getId().equals(extension.getId()) && (contentManager = content.getManager()) != null) {
                                contentManager.removeContent(content, true);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "extension";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "pluginDescriptor";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootRunConfigurationExtender$1";
                            objectArray[2] = "extensionRemoved";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, (Disposable)tab);
                    endpointTab.setChangeListener(new EndpointTab.EndpointChangeListener(){

                        public void tooltipChanged(@Nullable String tooltip) {
                            content.setDescription(tooltip);
                        }

                        public void infoRemoved() {
                            content.setIcon(IconLoader.getDisabledIcon((Icon)content.getIcon()));
                        }
                    });
                }
            }
        }
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(@NotNull PsiElement element) {
        String profileName;
        if (element == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(5);
        }
        if ((profileName = SpringBootProfileRefactoringListener.getProfileName(element)) == null) {
            return null;
        }
        if (SpringProfileUtils.profilesFromString((String)this.myConfiguration.getActiveProfiles()).contains(profileName)) {
            return new SpringBootProfileRefactoringListener(this.myConfiguration, profileName);
        }
        return null;
    }

    @NotNull
    public @NotNull List<@NotNull VMOption> getAdditionalVMOptions(@NotNull Module module) {
        if (module == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(6);
        }
        List keys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys(module);
        List list = ContainerUtil.mapNotNull((Collection)keys, key -> {
            if (key.getDeprecation() != MetaConfigKey.Deprecation.NOT_DEPRECATED) {
                return null;
            }
            PsiType psiType = key.getType();
            String type = psiType == null ? "String" : psiType.getPresentableText();
            return VMOption.property((String)key.getName(), (String)type, (String)key.getDescriptionText().getShortText(), (VMOptionLookupElementDecorator)SpringBootRunConfigurationExtender.getLookupElementDecorator(key));
        });
        if (list == null) {
            SpringBootRunConfigurationExtender.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static VMOptionLookupElementDecorator getLookupElementDecorator(MetaConfigKey key) {
        TailType tailType = key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP) ? AutoPopupTailTypes.dotType() : EQUAL_TAIL;
        return lookupElement -> TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)tailType);
    }

    @Nullable
    private static ContentManager initializeContentManagement(final Content content, final SpringBootApplicationEndpointsTab tab) {
        final ContentManager contentManager = content.getManager();
        if (contentManager != null) {
            ContentManagerListener listener = new ContentManagerListener(){

                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (event.getContent() == content && event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        tab.setSelected();
                    }
                }

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (event.getContent() == content) {
                        contentManager.removeContentManagerListener((ContentManagerListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootRunConfigurationExtender$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "selectionChanged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contentRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            contentManager.addContentManagerListener(listener);
        }
        return contentManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParametersSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startedProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootRunConfigurationExtender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootRunConfigurationExtender";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVMOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationTaskState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportStatistic";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalTabComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringElementListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVMOptions";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    static class Factory
    implements SpringBootConfigurationExtenderProducer<SpringBootRunConfigurationExtender> {
        Factory() {
        }

        @NotNull
        public SpringBootRunConfigurationExtender create(@NotNull SpringBootApplicationRunConfiguration configuration, @NotNull SpringBootApplicationRunConfigurationOptions options) {
            if (configuration == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (options == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new SpringBootRunConfigurationExtender(configuration, options);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/run/lifecycle/configuration/SpringBootRunConfigurationExtender$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

