/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.env.model;

import com.intellij.spring.boot.run.lifecycle.env.model.RuntimeProperty;
import com.intellij.spring.runtime.SpringRuntimeResolverService;
import com.intellij.spring.runtime.SpringRuntimeResource;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spring/boot/run/lifecycle/env/model/RuntimePropertySource;", "", "name", "", "properties", "", "Lcom/intellij/spring/boot/run/lifecycle/env/model/RuntimeProperty;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getProperties", "()Ljava/util/List;", "resource", "Lcom/intellij/spring/runtime/SpringRuntimeResource;", "getResource", "()Lcom/intellij/spring/runtime/SpringRuntimeResource;", "document", "getDocument", "intellij.spring.boot.run"})
@SourceDebugExtension(value={"SMAP\nRuntimePropertySource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimePropertySource.kt\ncom/intellij/spring/boot/run/lifecycle/env/model/RuntimePropertySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class RuntimePropertySource {
    @NotNull
    private final String name;
    @NotNull
    private final List<RuntimeProperty> properties;
    @Nullable
    private final SpringRuntimeResource resource;
    @Nullable
    private final String document;

    public RuntimePropertySource(@NotNull String name, @NotNull List<RuntimeProperty> properties) {
        Object description;
        String details;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.name = name;
        this.properties = properties;
        Object object = StringsKt.substringBefore((String)StringsKt.substringAfter((String)this.name, (char)'\'', (String)""), (char)'\'', (String)"");
        String it = object;
        boolean bl = false;
        String string = details = ((CharSequence)it).length() > 0 ? object : null;
        if (details != null) {
            SpringRuntimeResolverService resolverService = SpringRuntimeResolverService.Companion.getInstance();
            String path = resolverService.extractPath(details);
            this.resource = path == null ? null : resolverService.createResource(details, path);
        } else if (StringsKt.startsWith$default((String)this.name, (String)"configserver:", (boolean)false, (int)2, null)) {
            String string2 = this.name.substring(13);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String path = string2;
            description = "Config Server " + path;
            this.resource = SpringRuntimeResolverService.Companion.getInstance().createResource((String)description, path);
        } else {
            this.resource = null;
        }
        SpringRuntimeResource springRuntimeResource = this.resource;
        if ((springRuntimeResource != null ? springRuntimeResource.getPath() : null) == null) {
            this.document = null;
        } else {
            object = new char[1];
            object[0] = 41;
            description = object = StringsKt.trimEnd((String)StringsKt.substringAfterLast((String)this.name, (String)"(document #", (String)""), (char[])object);
            RuntimePropertySource runtimePropertySource = this;
            boolean bl2 = false;
            boolean bl3 = ((CharSequence)it).length() > 0;
            runtimePropertySource.document = bl3 ? object : null;
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<RuntimeProperty> getProperties() {
        return this.properties;
    }

    @Nullable
    public final SpringRuntimeResource getResource() {
        return this.resource;
    }

    @Nullable
    public final String getDocument() {
        return this.document;
    }
}

