/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class SpringBootRunUsageTriggerCollector
extends CounterUsagesCollector {
    private static final EventLogGroup SPRING_BOOT_RUN_USAGES_GROUP = new EventLogGroup("spring.boot.run.usages", 4);
    private static final EventId1<String> EDIT_RUNTIME_BEAN = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("edit.runtime.bean", (EventField)EventFields.ActionPlace);
    private static final EventId1<String> EDIT_RUNTIME_RESOURCE = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("edit.runtime.resource", (EventField)EventFields.ActionPlace);
    private static final EventId1<String> RUNTIME_BEANS_NAVIGATION_HANDLER = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("runtime.beans.navigation.handler", (EventField)EventFields.ActionPlace);
    private static final EventId RUNTIME_BEAN_SELECTED = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("runtime.bean.selected");
    private static final EventId RUNTIME_RESOURCE_SELECTED = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("runtime.resource.selected");
    private static final ClassEventField ACTUATOR_FIELD = EventFields.Class((String)"actuator");
    private static final EventId2<Class<?>, PluginInfo> ACTUATOR_TAB_SELECTED = SPRING_BOOT_RUN_USAGES_GROUP.registerEvent("actuator.tab.selected", (EventField)ACTUATOR_FIELD, (EventField)EventFields.PluginInfo);

    public static void logEditRuntimeBean(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (place == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        EDIT_RUNTIME_BEAN.log(project, (Object)place);
    }

    public static void logEditRuntimeResource(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        EDIT_RUNTIME_RESOURCE.log(project, (Object)place);
    }

    public static void logRuntimeBeansNavigationHandler(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        if (place == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        RUNTIME_BEANS_NAVIGATION_HANDLER.log(project, (Object)place);
    }

    public static void logRuntimeBeanSelected(@NotNull Project project) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(6);
        }
        RUNTIME_BEAN_SELECTED.log(project);
    }

    public static void logRuntimeResourceSelected(@NotNull Project project) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        RUNTIME_RESOURCE_SELECTED.log(project);
    }

    public static void logActuatorTabSelected(@NotNull Project project, @NotNull Class<?> endpointClass) {
        if (project == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(8);
        }
        if (endpointClass == null) {
            SpringBootRunUsageTriggerCollector.$$$reportNull$$$0(9);
        }
        ACTUATOR_TAB_SELECTED.log(project, endpointClass, (Object)PluginInfoDetectorKt.getPluginInfo(endpointClass));
    }

    public EventLogGroup getGroup() {
        return SPRING_BOOT_RUN_USAGES_GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpointClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/statistics/SpringBootRunUsageTriggerCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logEditRuntimeBean";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logEditRuntimeResource";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logRuntimeBeansNavigationHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "logRuntimeBeanSelected";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logRuntimeResourceSelected";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "logActuatorTabSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

