/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.PlaceholderSplitEscaper;
import com.intellij.microservices.url.UrlConversionConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlSpecialSegmentMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.util.SplitEscaper;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"springLikePropertySplitEscaper", "Lcom/intellij/psi/util/SplitEscaper;", "input", "", "pattern", "", "extractSegmentLikeSpring", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segmentStr", "extractAnyPathVariable", "anySequenceSymbol", "extractPlaceholder", "extractPlaceholderAsUndefined", "wrap", "Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "extractPathVariable", "pathVariableWrap", "intellij.platform.lang"})
@JvmName(name="UrlExtractors")
public final class UrlExtractors {
    @NotNull
    public static final SplitEscaper springLikePropertySplitEscaper(@NotNull CharSequence input, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Object[] objectArray = new UrlSpecialSegmentMarker[]{UrlConversionConstants.SPRING_LIKE_PLACEHOLDER_BRACES, UrlConversionConstants.SPRING_LIKE_PATH_VARIABLE_BRACES};
        return PlaceholderSplitEscaper.INSTANCE.create(CollectionsKt.listOf((Object[])objectArray), input, pattern);
    }

    @NotNull
    public static final UrlPath.PathSegment extractSegmentLikeSpring(@NotNull String segmentStr) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        UrlPath.PathSegment pathSegment = UrlExtractors.extractPlaceholderAsUndefined(segmentStr, UrlConversionConstants.SPRING_LIKE_PLACEHOLDER_BRACES);
        if (pathSegment == null && (pathSegment = UrlExtractors.extractPathVariable(segmentStr, UrlConversionConstants.SPRING_LIKE_PATH_VARIABLE_BRACES)) == null && (pathSegment = UrlExtractors.extractAnyPathVariable(segmentStr, "*")) == null && (pathSegment = UrlExtractors.extractPlaceholder(segmentStr, "**")) == null) {
            pathSegment = new UrlPath.PathSegment.Exact(segmentStr);
        }
        return pathSegment;
    }

    @Nullable
    public static final UrlPath.PathSegment extractAnyPathVariable(@NotNull String segmentStr, @NotNull String anySequenceSymbol) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        Intrinsics.checkNotNullParameter((Object)anySequenceSymbol, (String)"anySequenceSymbol");
        return !Intrinsics.areEqual((Object)segmentStr, (Object)anySequenceSymbol) ? null : (UrlPath.PathSegment)new UrlPath.PathSegment.Variable(null, null, 2, null);
    }

    @Nullable
    public static final UrlPath.PathSegment extractPlaceholder(@NotNull String segmentStr, @NotNull String anySequenceSymbol) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        Intrinsics.checkNotNullParameter((Object)anySequenceSymbol, (String)"anySequenceSymbol");
        return !Intrinsics.areEqual((Object)segmentStr, (Object)anySequenceSymbol) ? null : (UrlPath.PathSegment)UrlPath.PathSegment.Undefined.INSTANCE;
    }

    @Nullable
    public static final UrlPath.PathSegment extractPlaceholderAsUndefined(@NotNull String segmentStr, @NotNull UrlSpecialSegmentMarker wrap) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        Intrinsics.checkNotNullParameter((Object)wrap, (String)"wrap");
        return wrap.matches(segmentStr) ? (UrlPath.PathSegment)UrlPath.PathSegment.Undefined.INSTANCE : null;
    }

    @Nullable
    public static final UrlPath.PathSegment extractPathVariable(@NotNull String segmentStr, @NotNull UrlSpecialSegmentMarker pathVariableWrap) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        Intrinsics.checkNotNullParameter((Object)pathVariableWrap, (String)"pathVariableWrap");
        List<Pair<TextRange, UrlSpecialSegmentMarker.ExtractionInfo>> allVariables = pathVariableWrap.extractAll(segmentStr);
        if (allVariables.isEmpty()) {
            return null;
        }
        Pair pair = (Pair)CollectionsKt.singleOrNull(allVariables);
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            TextRange range = (TextRange)pair2.component1();
            UrlSpecialSegmentMarker.ExtractionInfo second = (UrlSpecialSegmentMarker.ExtractionInfo)pair2.component2();
            if (range.getStartOffset() == 0 && range.getEndOffset() == segmentStr.length()) {
                return new UrlPath.PathSegment.Variable(second.getValue(), (String)CollectionsKt.getOrNull(second.getRegexGroups(), (int)2));
            }
        }
        SmartList resultSegments = new SmartList();
        int prevEnd = 0;
        for (Pair pair3 : allVariables) {
            TextRange varRange = (TextRange)pair3.component1();
            UrlSpecialSegmentMarker.ExtractionInfo v = (UrlSpecialSegmentMarker.ExtractionInfo)pair3.component2();
            if (prevEnd != varRange.getStartOffset()) {
                String string = segmentStr.substring(prevEnd, varRange.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                resultSegments.add((Object)new UrlPath.PathSegment.Exact(string));
            }
            resultSegments.add((Object)new UrlPath.PathSegment.Variable(v.getValue(), (String)CollectionsKt.getOrNull(v.getRegexGroups(), (int)2)));
            prevEnd = varRange.getEndOffset();
        }
        if (prevEnd != segmentStr.length()) {
            String string = segmentStr.substring(prevEnd, segmentStr.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            resultSegments.add((Object)new UrlPath.PathSegment.Exact(string));
        }
        return new UrlPath.PathSegment.Composite((List)resultSegments);
    }
}

