/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.core;

import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.component.PlotComponentProvider;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/charts/core/ChartPlotPanel;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "plotComponentProvider", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;", "<init>", "(Lorg/jetbrains/letsPlot/awt/plot/component/PlotComponentProvider;)V", "lastPreferredSize", "Ljava/awt/Dimension;", "showProgressFuture", "Ljava/util/concurrent/ScheduledFuture;", "recreateComponentFuture", "currentRebuildTask", "Ljava/util/concurrent/Future;", "dispose", "", "cancelScheduledTasks", "handleChildRemovedIntern", "child", "Ljava/awt/Component;", "showProgress", "rebuildPlotComponent", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nChartPlotPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPlotPanel.kt\ncom/intellij/charts/core/ChartPlotPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public class ChartPlotPanel
extends JPanel
implements Disposable {
    @NotNull
    private final PlotComponentProvider plotComponentProvider;
    @Nullable
    private Dimension lastPreferredSize;
    @Nullable
    private ScheduledFuture<?> showProgressFuture;
    @Nullable
    private ScheduledFuture<?> recreateComponentFuture;
    @Nullable
    private Future<?> currentRebuildTask;

    public ChartPlotPanel(@NotNull PlotComponentProvider plotComponentProvider) {
        Intrinsics.checkNotNullParameter((Object)plotComponentProvider, (String)"plotComponentProvider");
        super(new BorderLayout());
        this.plotComponentProvider = plotComponentProvider;
        this.setOpaque(false);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component2 = e.getChild();
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getChild(...)");
                this.handleChildRemovedIntern(component2);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.cancelScheduledTasks();
                showProgressFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ChartPlotPanel.access$showProgress(this), 1000L, TimeUnit.MILLISECONDS);
                recreateComponentFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ChartPlotPanel.access$rebuildPlotComponent(this), 200L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.cancelScheduledTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelScheduledTasks() {
        try {
            ScheduledFuture<?> scheduledFuture = this.showProgressFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this.showProgressFuture = null;
        }
        try {
            ScheduledFuture<?> scheduledFuture = this.recreateComponentFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this.recreateComponentFuture = null;
        }
        try {
            Future<?> future = this.currentRebuildTask;
            if (future != null) {
                future.cancel(true);
            }
        }
        finally {
            this.currentRebuildTask = null;
        }
    }

    private final void handleChildRemovedIntern(Component child) {
        Component component2 = child;
        if (component2 instanceof Disposable) {
            ((Disposable)((Object)child)).dispose();
        } else if (component2 instanceof JScrollPane) {
            Component component3 = ((JScrollPane)child).getViewport().getView();
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"getView(...)");
            this.handleChildRemovedIntern(component3);
        }
    }

    private final void showProgress() {
        DialogPanel dialogPanel;
        this.removeAll();
        DialogPanel $this$showProgress_u24lambda_u241 = dialogPanel = BuilderKt.panel(ChartPlotPanel::showProgress$lambda$0);
        boolean bl = false;
        $this$showProgress_u24lambda_u241.setOpaque(false);
        DialogPanel loadingPanel = dialogPanel;
        this.add((Component)loadingPanel);
        this.revalidate();
        this.repaint();
    }

    private final void rebuildPlotComponent() {
        Runnable action2 = () -> ChartPlotPanel.rebuildPlotComponent$lambda$0(this);
        this.currentRebuildTask = ApplicationManager.getApplication().executeOnPooledThread(action2);
    }

    private static final Unit showProgress$lambda$0$0$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ChartMessagesBundle.message("chart.loading", new Object[0])).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showProgress$lambda$0$0$0$1(Row $this$row) {
        void $this$showProgress_u24lambda_u240_u240_u240_u241_u240;
        JProgressBar jProgressBar;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JProgressBar jProgressBar2 = jProgressBar = new JProgressBar();
        Row row = $this$row;
        boolean bl = false;
        $this$showProgress_u24lambda_u240_u240_u240_u241_u240.setIndeterminate(true);
        row.cell((JComponent)jProgressBar).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit showProgress$lambda$0$0$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ChartPlotPanel::showProgress$lambda$0$0$0$0, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, ChartPlotPanel::showProgress$lambda$0$0$0$1, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit showProgress$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(ChartPlotPanel::showProgress$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit showProgress$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ChartPlotPanel::showProgress$lambda$0$0, (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void rebuildPlotComponent$lambda$0(ChartPlotPanel this$0) {
        Dimension plotContainerSize = this$0.getSize();
        if (plotContainerSize == null) {
            return;
        }
        SizingPolicy sizingPolicy = SizingPolicy.Companion.fitContainerSize(false);
        Dimension dimension = this$0.lastPreferredSize;
        Dimension dimension2 = this$0.lastPreferredSize;
        DoubleVector $this$rebuildPlotComponent_u24lambda_u240_u240 = sizingPolicy.resize(new DoubleVector((Number)(dimension != null ? dimension.width : 100), (Number)(dimension2 != null ? dimension2.height : 100)), new DoubleVector((Number)plotContainerSize.width, (Number)plotContainerSize.height));
        boolean bl = false;
        Dimension preferredSize = new Dimension(MathKt.roundToInt((double)$this$rebuildPlotComponent_u24lambda_u240_u240.getX()), MathKt.roundToInt((double)$this$rebuildPlotComponent_u24lambda_u240_u240.getY()));
        if (Intrinsics.areEqual((Object)this$0.lastPreferredSize, (Object)preferredSize)) {
            return;
        }
        this$0.lastPreferredSize = preferredSize;
        JComponent providedComponent = PlotComponentProvider.DefaultImpls.createComponent$default(this$0.plotComponentProvider, plotContainerSize, sizingPolicy, null, 4, null);
        try {
            ScheduledFuture<?> scheduledFuture = this$0.showProgressFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
        }
        finally {
            this$0.showProgressFuture = null;
        }
        this$0.removeAll();
        this$0.add(providedComponent);
        this$0.revalidate();
        this$0.repaint();
        this$0.currentRebuildTask = null;
    }

    public static final /* synthetic */ void access$showProgress(ChartPlotPanel $this) {
        $this.showProgress();
    }

    public static final /* synthetic */ void access$rebuildPlotComponent(ChartPlotPanel $this) {
        $this.rebuildPlotComponent();
    }
}

