/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.BuildHistory;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.PathCommand;

final class QuadraticSmooth
extends PathCommand {
    private final float x;
    private final float y;

    public QuadraticSmooth(boolean isRelative, float x2, float y2) {
        super(isRelative, 4);
        this.x = x2;
        this.y = y2;
    }

    @Override
    public void appendPath(@NotNull Path2D path2, @NotNull BuildHistory hist) {
        Point2D.Float offset = this.offset(hist);
        Point2D.Float knot = this.lastKnotReflection(hist);
        path2.quadTo(knot.x, knot.y, this.x + offset.x, this.y + offset.y);
        hist.setLastPoint(path2.getCurrentPoint());
        hist.setLastKnot(knot);
    }

    public String toString() {
        return "T " + this.x + " " + this.y;
    }
}

