/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.FloatInsets;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.util.PathLengthCalculator;

public final class GeometryUtil {
    private static final float EPS = 1.0E-4f;

    private GeometryUtil() {
    }

    public static boolean approximatelyEqual(double a2, double b2) {
        return Math.abs(a2 - b2) < (double)1.0E-4f;
    }

    public static boolean approximatelyZero(double a2) {
        return GeometryUtil.approximatelyEqual(a2, 0.0);
    }

    public static boolean notablyGreater(double a2, double b2) {
        return a2 - b2 > (double)1.0E-4f;
    }

    public static boolean approximatelyNegative(double a2) {
        return a2 < (double)1.0E-4f;
    }

    public static double scaleXOfTransform(@Nullable AffineTransform at) {
        if (at == null) {
            return 1.0;
        }
        double sx = at.getScaleX();
        double shy = at.getShearY();
        return Math.sqrt(sx * sx + shy * shy);
    }

    public static double scaleYOfTransform(@Nullable AffineTransform at) {
        if (at == null) {
            return 1.0;
        }
        double sy = at.getScaleY();
        double shx = at.getShearX();
        return Math.sqrt(sy * sy + shx * shx);
    }

    @NotNull
    public static Point2D.Float midPoint(@NotNull Point2D.Float x2, @NotNull Point2D.Float y2) {
        return new Point2D.Float((x2.x + y2.x) / 2.0f, (x2.y + y2.y) / 2.0f);
    }

    @NotNull
    public static Point2D.Float lerp(float t, @NotNull Point2D.Float a2, @NotNull Point2D.Float b2) {
        return new Point2D.Float(GeometryUtil.lerp(t, b2.x, a2.x), GeometryUtil.lerp(t, b2.y, a2.y));
    }

    public static float lerp(float t, float a2, float b2) {
        return (1.0f - t) * a2 + t * b2;
    }

    public static double distanceSquared(@NotNull Point2D.Float p1, @NotNull Point2D.Float p2, float scaleX, float scaleY) {
        return GeometryUtil.distanceSquared(scaleX * p1.x, scaleY * p1.y, (double)(scaleX * p2.x), (double)(scaleY * p2.y));
    }

    public static double distanceSquared(@NotNull Point2D.Float p1, @NotNull Point2D.Float p2) {
        return GeometryUtil.distanceSquared(p1.x, p1.y, (double)p2.x, (double)p2.y);
    }

    public static double distanceSquared(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double pathLength(@NotNull Shape shape) {
        PathLengthCalculator pathLengthCalculator = new PathLengthCalculator();
        PathIterator pathIterator = shape.getPathIterator(null);
        double length = 0.0;
        double[] args = new double[6];
        while (!pathIterator.isDone()) {
            length += pathLengthCalculator.segmentLength(pathIterator.currentSegment(args), args);
            pathIterator.next();
        }
        return length;
    }

    public static double lineLength(double x1, double y1, double x2, double y2) {
        return Math.sqrt(GeometryUtil.distanceSquared(x1, y1, x2, y2));
    }

    @NotNull
    public static Rectangle2D containingBoundsAfterTransform(@NotNull AffineTransform transform2, @NotNull Rectangle2D rect2) {
        Point2D.Double p1 = new Point2D.Double(rect2.getX(), rect2.getY());
        Point2D.Double p2 = new Point2D.Double(rect2.getX() + rect2.getWidth(), rect2.getY());
        Point2D.Double p3 = new Point2D.Double(rect2.getX(), rect2.getY() + rect2.getHeight());
        Point2D.Double p4 = new Point2D.Double(rect2.getX() + rect2.getWidth(), rect2.getY() + rect2.getHeight());
        Rectangle2D r1 = rect2.getBounds2D();
        r1.setFrameFromDiagonal(transform2.transform(p1, p1), transform2.transform(p2, p2));
        Rectangle2D r2 = rect2.getBounds2D();
        r2.setFrameFromDiagonal(transform2.transform(p3, p3), transform2.transform(p4, p4));
        Rectangle2D.union(r1, r2, r1);
        return r1;
    }

    public static float left(@NotNull Rectangle2D rect2) {
        return (float)rect2.getX();
    }

    public static float top(@NotNull Rectangle2D rect2) {
        return (float)rect2.getY();
    }

    public static float right(@NotNull Rectangle2D rect2) {
        return (float)(rect2.getX() + rect2.getWidth());
    }

    public static float bottom(@NotNull Rectangle2D rect2) {
        return (float)(rect2.getY() + rect2.getHeight());
    }

    @NotNull
    public static Rectangle2D grow(@NotNull Rectangle2D bounds, FloatInsets grow) {
        return new Rectangle2D.Double(bounds.getX() - (double)grow.left(), bounds.getY() - (double)grow.top(), bounds.getWidth() + (double)grow.left() + (double)grow.right(), bounds.getHeight() + (double)grow.top() + (double)grow.bottom());
    }

    @NotNull
    public static FloatInsets max(@NotNull FloatInsets in1, @NotNull FloatInsets in2) {
        return new FloatInsets(Math.max(in1.top(), in2.top()), Math.max(in1.left(), in2.left()), Math.max(in1.bottom(), in2.bottom()), Math.max(in1.right(), in2.right()));
    }

    @NotNull
    public static FloatInsets min(@NotNull FloatInsets in1, @NotNull FloatInsets in2) {
        return new FloatInsets(Math.min(in1.top(), in2.top()), Math.min(in1.left(), in2.left()), Math.min(in1.bottom(), in2.bottom()), Math.min(in1.right(), in2.right()));
    }

    @NotNull
    public static FloatInsets overhangInsets(@NotNull Rectangle2D reference, @NotNull Rectangle2D bounds) {
        return new FloatInsets(Math.max(0.0f, GeometryUtil.top(reference) - GeometryUtil.top(bounds)), Math.max(0.0f, GeometryUtil.left(reference) - GeometryUtil.left(bounds)), Math.max(0.0f, GeometryUtil.bottom(bounds) - GeometryUtil.bottom(reference)), Math.max(0.0f, GeometryUtil.right(bounds) - GeometryUtil.right(reference)));
    }

    @NotNull
    public static String compactRepresentation(@NotNull Rectangle2D rect2) {
        return "[" + rect2.getX() + ", " + rect2.getY() + ", " + rect2.getWidth() + "x" + rect2.getHeight() + "]";
    }
}

