/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes.mesh;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.UnitType;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.paint.SVGPaint;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.MeasureContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.SVGNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.Animate;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.AnimateTransform;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.animation.Set;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.container.ContainerNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.mesh.MeshBuilder;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.mesh.MeshPatch;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.mesh.MeshRow;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

@ElementCategories(value={Category.Gradient})
@PermittedContent(categories={Category.Descriptive}, anyOf={MeshRow.class, Animate.class, AnimateTransform.class, Set.class})
public final class MeshGradient
extends ContainerNode
implements SVGPaint {
    public static final String TAG = "meshgradient";
    private Length x;
    private Length y;
    private UnitType gradientUnits;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.x = attributeNode.getLength("x", 0.0f);
        this.y = attributeNode.getLength("y", 0.0f);
        this.gradientUnits = attributeNode.getEnum("gradientUnits", UnitType.ObjectBoundingBox);
        MeshBuilder.buildMesh(this, new Point2D.Float(this.x.raw(), this.y.raw()));
    }

    public void renderMesh(@NotNull MeasureContext measure, @NotNull Graphics2D g) {
        Graphics2D meshGraphics = (Graphics2D)g.create();
        meshGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (SVGNode sVGNode : this.children()) {
            MeshRow row = (MeshRow)sVGNode;
            for (SVGNode sVGNode2 : row.children()) {
                MeshPatch patch = (MeshPatch)sVGNode2;
                patch.renderPath(meshGraphics);
            }
        }
        meshGraphics.dispose();
    }

    @Override
    public void fillShape(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull Shape shape, @Nullable Rectangle2D bounds) {
        Shape clip2 = g.getClip();
        Rectangle2D b2 = bounds != null ? bounds : shape.getBounds2D();
        g.setClip(shape);
        g.translate(b2.getX(), b2.getY());
        this.renderMesh(context.measureContext(), g);
        g.setClip(clip2);
    }

    @Override
    public void drawShape(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull Shape shape, @Nullable Rectangle2D bounds) {
        Shape clip2 = g.getClip();
        Rectangle2D b2 = bounds != null ? bounds : shape.getBounds2D();
        g.setClip(g.getStroke().createStrokedShape(shape));
        g.translate(b2.getX(), b2.getY());
        this.renderMesh(context.measureContext(), g);
        g.setClip(clip2);
    }
}

