/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.javascript.karma.coverage.KarmaCoverageEngine;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.coverage.CoverageProjectDataLoader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KarmaCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(KarmaCoverageRunner.class);
    private NodeTargetRun myTargetRun;
    private Path myLocalProjectRoot;

    @NotNull
    public static KarmaCoverageRunner getInstance() {
        KarmaCoverageRunner karmaCoverageRunner = Objects.requireNonNull((KarmaCoverageRunner)CoverageRunner.getInstance(KarmaCoverageRunner.class));
        if (karmaCoverageRunner == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(0);
        }
        return karmaCoverageRunner;
    }

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        Path localProjectRoot;
        if (sessionDataFile == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(2);
        }
        if ((localProjectRoot = this.myLocalProjectRoot) != null) {
            CoverageLoadingResult coverageLoadingResult;
            try {
                coverageLoadingResult = CoverageProjectDataLoader.readProjectData((Path)sessionDataFile.toPath(), (Path)localProjectRoot, (NodeTargetRun)this.myTargetRun, (CoverageLoadErrorReporter)reporter);
            }
            catch (Exception e) {
                LOG.warn("Can't read coverage data", (Throwable)e);
                return new FailedCoverageLoadingResult(e, true);
            }
            if (coverageLoadingResult == null) {
                KarmaCoverageRunner.$$$reportNull$$$0(3);
            }
            return coverageLoadingResult;
        }
        String message = "The localProjectRoot is not set";
        LOG.warn(message);
        return new FailedCoverageLoadingResult(message);
    }

    public void setTargetRun(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(4);
        }
        this.myTargetRun = targetRun;
    }

    public void setProjectRoot(@NotNull Path localProjectRoot) {
        if (localProjectRoot == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(5);
        }
        this.myLocalProjectRoot = localProjectRoot;
    }

    @NotNull
    public String getPresentableName() {
        return "KarmaPresentableName";
    }

    @NotNull
    public String getId() {
        return "KarmaJavaScriptTestRunnerCoverage";
    }

    @NotNull
    public String getDataFileExtension() {
        return "dat";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            KarmaCoverageRunner.$$$reportNull$$$0(6);
        }
        return engine instanceof KarmaCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/coverage/KarmaCoverageRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProjectRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/coverage/KarmaCoverageRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoverageData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTargetRun";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProjectRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

