/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwitchExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            SwitchExpressionFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiSwitchBlock) {
            PsiSwitchBlock switchStatement = (PsiSwitchBlock)psiElement;
            Document doc = editor.getDocument();
            PsiJavaToken rParenth = switchStatement.getRParenth();
            PsiJavaToken lParenth = switchStatement.getLParenth();
            PsiExpression condition = switchStatement.getExpression();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(switchStatement.getTextRange().getStartOffset()));
                    PsiCodeBlock block = switchStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    doc.replaceString(switchStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"switch ()");
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/SwitchExpressionFixer", "apply"));
    }
}

