/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.impl.source.OldParserWhiteSpaceAndCommentSetHolder;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Deprecated
public class DeclarationParser {
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create((IElementType[])new IElementType[]{ElementType.IDENTIFIER, ElementType.COMMA, ElementType.EXTENDS_KEYWORD, ElementType.IMPLEMENTS_KEYWORD, ElementType.LPARENTH});
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create((IElementType[])new IElementType[]{ElementType.IDENTIFIER, ElementType.COMMA, ElementType.THROWS_KEYWORD});
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{ElementType.RPARENTH, ElementType.LBRACE, ElementType.ARROW});
    private static final TokenSet METHOD_PARAM_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{ElementType.RPARENTH, ElementType.LBRACE, ElementType.ARROW, ElementType.SEMICOLON});
    private static final TokenSet TYPE_START = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{ElementType.IDENTIFIER, ElementType.AT, ElementType.VAR_KEYWORD})});
    private static final String WHITESPACES = "\n\r \t";
    private static final String LINE_ENDS = "\n\r";
    private final TokenSet RESOURCE_EXPRESSIONS;
    private final JavaParser myParser;

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == ElementType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        JavaParserUtil.expectOrError(builder, ElementType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration, boolean isAnnotation, Context context) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        boolean isRecord = DeclarationParser.isRecordToken(builder, keywordTokenType);
        if (isRecord) {
            builder.remapCurrentToken(ElementType.RECORD_KEYWORD);
            if (builder.lookAhead(1) != ElementType.IDENTIFIER) {
                builder.advanceLexer();
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration.drop();
                return null;
            }
            IElementType afterIdent = builder.lookAhead(2);
            if (context == Context.CODE_BLOCK && afterIdent != ElementType.LPARENTH && afterIdent != ElementType.LT) {
                PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.lt.or.lparen", new Object[0]));
                declaration.drop();
                return null;
            }
            keywordTokenType = ElementType.RECORD_KEYWORD;
        }
        assert (ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == ElementType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.IDENTIFIER)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        ReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder);
        if (builder.getTokenType() == ElementType.LPARENTH) {
            this.parseElementList(builder, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder, ElementType.EXTENDS_KEYWORD, ElementType.EXTENDS_LIST, ElementType.COMMA);
        refParser.parseReferenceList(builder, ElementType.IMPLEMENTS_KEYWORD, ElementType.IMPLEMENTS_LIST, ElementType.COMMA);
        if (builder.getTokenType() == ElementType.IDENTIFIER && "permits".equals(builder.getTokenText())) {
            builder.remapCurrentToken(ElementType.PERMITS_KEYWORD);
        }
        if (builder.getTokenType() == ElementType.PERMITS_KEYWORD) {
            refParser.parseReferenceList(builder, ElementType.PERMITS_KEYWORD, ElementType.PERMITS_LIST, ElementType.COMMA);
        }
        if (builder.getTokenType() != ElementType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        if (builder.getTokenType() == ElementType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        JavaParserUtil.done(declaration, ElementType.CLASS, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        boolean first = true;
        while (builder.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == ElementType.PRIVATE_KEYWORD || builder.getTokenType() == ElementType.PROTECTED_KEYWORD) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null && builder.getTokenType() == ElementType.COMMA && first && (next = builder.lookAhead(1)) != ElementType.SEMICOLON && next != ElementType.RBRACE) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            first = false;
            int commaCount = 0;
            while (builder.getTokenType() == ElementType.COMMA) {
                if (commaCount > 0) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                builder.advanceLexer();
                ++commaCount;
            }
            if (commaCount != 0 || builder.getTokenType() == null || builder.getTokenType() == ElementType.SEMICOLON) continue;
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.IDENTIFIER)) {
            if (builder.getTokenType() == ElementType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder);
            } else {
                JavaParserUtil.emptyElement(builder, ElementType.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == ElementType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                JavaParserUtil.done(constantInit, ElementType.ENUM_CONSTANT_INITIALIZER, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            }
            JavaParserUtil.done(constant, ElementType.ENUM_CONSTANT, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        Context context = isAnnotation ? Context.ANNOTATION_INTERFACE : Context.CLASS;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != ElementType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == ElementType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, context);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder, Context context) {
        IElementType tokenType;
        if (builder == null) {
            DeclarationParser.$$$reportNull$$$0(0);
        }
        if ((tokenType = builder.getTokenType()) == null) {
            return null;
        }
        if (tokenType == ElementType.LBRACE) {
            if (context == Context.FILE || context == Context.CODE_BLOCK) {
                return null;
            }
        } else if (!(DeclarationParser.isRecordToken(builder, tokenType) || DeclarationParser.isSealedToken(builder, tokenType) || DeclarationParser.isNonSealedToken(builder, tokenType) || TYPE_START.contains(tokenType) && tokenType != ElementType.AT)) {
            if (tokenType instanceof ILazyParseableElementType) {
                builder.advanceLexer();
                return null;
            }
            if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == ElementType.AT || context != Context.CODE_BLOCK && tokenType == ElementType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.AT)) {
            if (builder.getTokenType() == ElementType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, true, context);
                return result != null ? result : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType()) || DeclarationParser.isRecordToken(builder, builder.getTokenType())) {
            PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, false, context);
            return result != null ? result : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == ElementType.LT && context != Context.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder);
        }
        if (builder.getTokenType() == ElementType.LBRACE) {
            if (context == Context.CODE_BLOCK) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier.or.type", new Object[0]), null);
                declaration.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder);
            assert (codeBlock != null) : builder.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), codeBlock);
            }
            JavaParserUtil.done(declaration, ElementType.CLASS_INITIALIZER, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            return declaration;
        }
        ReferenceParser.TypeInfo type = null;
        if (TYPE_START.contains(builder.getTokenType())) {
            PsiBuilder.Marker pos = builder.mark();
            int flags = 5;
            if (context == Context.CODE_BLOCK || context == Context.JSHELL) {
                flags |= 0x80;
            }
            if ((type = this.myParser.getReferenceParser().parseTypeInfo(builder, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder.getTokenType() == ElementType.LPARENTH || builder.getTokenType() == ElementType.LBRACE || builder.getTokenType() == ElementType.THROWS_KEYWORD) {
                    if (context == Context.CODE_BLOCK) {
                        declaration.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        JavaParserUtil.emptyElement(builder, ElementType.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder);
                    if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder.mark();
                        builder.advanceLexer();
                        primitive.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    if (builder.getTokenType() == ElementType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder, declaration, false, true);
                    }
                    if (builder.getTokenType() == ElementType.LBRACE) {
                        JavaParserUtil.emptyElement(builder, ElementType.THROWS_LIST);
                        return this.parseMethodBody(builder, declaration, false);
                    }
                    if (builder.getTokenType() == ElementType.THROWS_KEYWORD) {
                        this.myParser.getReferenceParser().parseReferenceList(builder, ElementType.THROWS_KEYWORD, ElementType.THROWS_LIST, ElementType.COMMA);
                        return this.parseMethodBody(builder, declaration, false);
                    }
                    declaration.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaPsiBundle.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.IDENTIFIER)) {
            if (context != Context.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type.isPrimitive && builder.getTokenType() != ElementType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type.marker);
                }
                builder.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration.drop();
                return modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (builder.getTokenType() == ElementType.LPARENTH && (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE || context == Context.FILE || context == Context.JSHELL)) {
            if (typeParams == null) {
                JavaParserUtil.emptyElement(type.marker, ElementType.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration, context == Context.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type.marker);
        }
        return this.parseFieldOrLocalVariable(builder, declaration, declarationStart, context);
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder, ElementType.MODIFIER_BIT_SET);
        if (pair == null) {
            DeclarationParser.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (DeclarationParser.isValueToken(builder, tokenType)) {
                builder.remapCurrentToken(ElementType.VALUE_KEYWORD);
                tokenType = ElementType.VALUE_KEYWORD;
            } else if (DeclarationParser.isSealedToken(builder, tokenType)) {
                builder.remapCurrentToken(ElementType.SEALED_KEYWORD);
                tokenType = ElementType.SEALED_KEYWORD;
            }
            if (DeclarationParser.isNonSealedToken(builder, tokenType)) {
                PsiBuilder.Marker nonSealed = builder.mark();
                PsiBuilderUtil.advance((PsiBuilder)builder, (int)3);
                nonSealed.collapse(ElementType.NON_SEALED_KEYWORD);
                isEmpty = false;
                continue;
            }
            if (modifiers.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != ElementType.AT || ElementType.KEYWORD_BIT_SET.contains(builder.lookAhead(1))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        JavaParserUtil.done(modList, ElementType.MODIFIER_LIST, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        Pair pair = Pair.create((Object)modList, (Object)isEmpty);
        if (pair == null) {
            DeclarationParser.$$$reportNull$$$0(2);
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        this.parseParameterList(builder);
        this.eatBrackets(builder, constructor ? "expected.lbrace" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder, ElementType.THROWS_KEYWORD, ElementType.THROWS_LIST, ElementType.COMMA);
        if (anno && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.DEFAULT_KEYWORD) && this.parseAnnotationValue(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.value", new Object[0]));
        }
        return this.parseMethodBody(builder, declaration, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != ElementType.SEMICOLON && tokenType != ElementType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text = builder.getOriginalText();
            block0: do {
                for (int i = builder.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.SEMICOLON) && builder.getTokenType() == ElementType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        }
        JavaParserUtil.done(declaration, anno ? ElementType.ANNOTATION_METHOD : ElementType.METHOD, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        PsiBuilder.Marker marker = declaration;
        if (marker == null) {
            DeclarationParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    public void parseParameterList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder, boolean typed) {
        this.parseElementList(builder, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder, ListType type) {
        boolean lambda = type == ListType.LAMBDA_TYPED || type == ListType.LAMBDA_UNTYPED;
        boolean resources = type == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder.mark();
        boolean leftParenth = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.LPARENTH);
        assert (lambda || leftParenth) : builder.getTokenType();
        IElementType delimiter = resources ? ElementType.SEMICOLON : ElementType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        PsiBuilder.Marker invalidElements = null;
        String errorMessage = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || type.getStopperTypes().contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda ? "expected.parameter" : "expected.identifier.or.type";
                    JavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
                }
                if (tokenType == ElementType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage);
                }
                invalidElements = null;
                if (!leftParenth) break;
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder, true, false, false, false) : (resources ? this.parseResource(builder) : (lambda ? this.parseLambdaParameter(builder, type == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message(noElementMsg, new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage = JavaPsiBundle.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage);
        }
        JavaParserUtil.done(elementList, type.getNodeType(), builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder, true, typeFlags, isParameter ? ElementType.PARAMETER : ElementType.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null && this.RESOURCE_EXPRESSIONS.contains(JavaParserUtil.exprType(expr)) && builder.getTokenType() != ElementType.IDENTIFIER) {
            marker.done(ElementType.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder, true, 128, ElementType.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder, boolean typed) {
        int flags = 2;
        if (JavaFeature.VAR_LAMBDA_PARAMETER.isSufficient(JavaParserUtil.getLanguageLevel(builder))) {
            flags |= 0x80;
        }
        return this.parseListElement(builder, typed, flags, ElementType.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean typed, int typeFlags, IElementType type) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        if (typed) {
            int flags = 5 | typeFlags;
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                JavaParserUtil.emptyElement(builder, ElementType.TYPE);
            }
        }
        if (typed && ((tokenType = builder.getTokenType()) == ElementType.THIS_KEYWORD || tokenType == ElementType.IDENTIFIER && builder.lookAhead(1) == ElementType.DOT)) {
            PsiBuilder.Marker mark = builder.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
            if (expr != null && JavaParserUtil.exprType(expr) == ElementType.THIS_EXPRESSION) {
                mark.drop();
                JavaParserUtil.done(param, ElementType.RECEIVER_PARAMETER, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.IDENTIFIER)) {
            if (type == ElementType.PARAMETER || type == ElementType.RECORD_COMPONENT) {
                this.eatBrackets(builder, null);
                JavaParserUtil.done(param, type, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
                return param;
            }
        } else {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (JavaParserUtil.expectOrError(builder, ElementType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(param, ElementType.RESOURCE_VARIABLE, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration, int declarationStart, Context context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == Context.CLASS || context == Context.ANNOTATION_INTERFACE || context == Context.FILE || context == Context.JSHELL) {
            varType = ElementType.FIELD;
        } else if (context == Context.CODE_BLOCK) {
            varType = ElementType.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context);
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != ElementType.COMMA) break;
            JavaParserUtil.done(variable, varType, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            builder.advanceLexer();
            if (builder.getTokenType() != ElementType.IDENTIFIER) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == ElementType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(spaceEnd - 1), (String)WHITESPACES);
                int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)spaceEnd, (String)LINE_ENDS);
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStart, (String)WHITESPACES);
                    declaration.rollbackTo();
                    return this.parse(JavaParserUtil.stoppingBuilder(builder, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            JavaParserUtil.done(variable, varType, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        }
        return declaration;
    }

    private boolean eatBrackets(PsiBuilder builder, @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") String errorKey) {
        boolean paired;
        IElementType tokenType = builder.getTokenType();
        if (tokenType != ElementType.LBRACKET && tokenType != ElementType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        int count = 0;
        while (true) {
            this.parseAnnotations(builder);
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.LBRACKET)) break;
            ++count;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.RBRACKET)) break;
            ++count;
        }
        if (count == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count % 2 == 0;
        if (!paired) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == ElementType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == ElementType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder.getTokenType() == ElementType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        }
        if (classRef == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        JavaParserUtil.done(anno, ElementType.ANNOTATION, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            DeclarationParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    private void parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.LPARENTH) || PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.RPARENTH)) {
            JavaParserUtil.done(list, ElementType.ANNOTATION_PARAMETER_LIST, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            return;
        }
        if (builder.getTokenType() == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter.or.rparen", new Object[0]));
            JavaParserUtil.done(list, ElementType.ANNOTATION_PARAMETER_LIST, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            return;
        }
        PsiBuilder.Marker elementMarker = this.parseAnnotationElement(builder);
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message(elementMarker == null ? "expected.parameter.or.rparen" : "expected.comma.or.rparen", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.RPARENTH)) break;
            if (tokenType == ElementType.COMMA) {
                builder.advanceLexer();
                elementMarker = this.parseAnnotationElement(builder);
                if (elementMarker != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message("annotation.name.is.missing", new Object[0]));
                tokenType = builder.getTokenType();
                if (tokenType == ElementType.COMMA || tokenType == ElementType.RPARENTH) continue;
                break;
            }
            JavaParserUtil.error(builder, JavaPsiBundle.message(elementMarker == null ? "expected.parameter.or.rparen" : "expected.comma.or.rparen", new Object[0]));
            tokenType = builder.lookAhead(1);
            if (tokenType != ElementType.COMMA && tokenType != ElementType.RPARENTH) break;
            builder.advanceLexer();
        }
        JavaParserUtil.done(list, ElementType.ANNOTATION_PARAMETER_LIST, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
    }

    private PsiBuilder.Marker parseAnnotationElement(PsiBuilder builder) {
        PsiBuilder.Marker pair = builder.mark();
        PsiBuilder.Marker valueMarker = this.parseAnnotationValue(builder);
        if (valueMarker == null && builder.getTokenType() != ElementType.EQ) {
            pair.drop();
            return null;
        }
        if (builder.getTokenType() != ElementType.EQ) {
            JavaParserUtil.done(pair, ElementType.NAME_VALUE_PAIR, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
            return pair;
        }
        pair.rollbackTo();
        pair = builder.mark();
        JavaParserUtil.expectOrError(builder, ElementType.IDENTIFIER, "expected.identifier");
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)ElementType.EQ);
        valueMarker = this.parseAnnotationValue(builder);
        if (valueMarker == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.value", new Object[0]));
        }
        JavaParserUtil.done(pair, ElementType.NAME_VALUE_PAIR, builder, OldParserWhiteSpaceAndCommentSetHolder.INSTANCE);
        return pair;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == ElementType.AT) {
            return this.parseAnnotation(builder);
        }
        if (tokenType == ElementType.LBRACE) {
            return this.myParser.getExpressionParser().parseArrayInitializer(builder, ElementType.ANNOTATION_ARRAY_INITIALIZER, this::parseAnnotationValue, "expected.value");
        }
        return this.myParser.getExpressionParser().parseConditional(builder);
    }

    static boolean isRecordToken(PsiBuilder builder, IElementType tokenType) {
        IElementType nextToken;
        if (tokenType == ElementType.IDENTIFIER && "record".equals(builder.getTokenText()) && ((nextToken = builder.lookAhead(1)) == ElementType.IDENTIFIER || ElementType.MODIFIER_BIT_SET.contains(nextToken) || ElementType.CLASS_KEYWORD_BIT_SET.contains(nextToken) || TYPE_START.contains(nextToken) || nextToken == ElementType.AT || nextToken == ElementType.LBRACE || nextToken == ElementType.RBRACE)) {
            return JavaFeature.RECORDS.isSufficient(JavaParserUtil.getLanguageLevel(builder));
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder, IElementType tokenType) {
        return JavaFeature.SEALED_CLASSES.isSufficient(JavaParserUtil.getLanguageLevel(builder)) && tokenType == ElementType.IDENTIFIER && "sealed".equals(builder.getTokenText());
    }

    private static boolean isValueToken(PsiBuilder builder, IElementType tokenType) {
        return JavaFeature.VALHALLA_VALUE_CLASSES.isSufficient(JavaParserUtil.getLanguageLevel(builder)) && tokenType == ElementType.IDENTIFIER && "value".equals(builder.getTokenText());
    }

    static boolean isNonSealedToken(PsiBuilder builder, IElementType tokenType) {
        if (!JavaFeature.SEALED_CLASSES.isSufficient(JavaParserUtil.getLanguageLevel(builder)) || tokenType != ElementType.IDENTIFIER || !"non".equals(builder.getTokenText()) || builder.lookAhead(1) != ElementType.MINUS || builder.lookAhead(2) != ElementType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder.mark();
        PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        boolean isNonSealed = "sealed".equals(builder.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    public DeclarationParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            DeclarationParser.$$$reportNull$$$0(5);
        }
        this.myParser = javaParser;
        this.RESOURCE_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{ElementType.REFERENCE_EXPRESSION, ElementType.THIS_EXPRESSION, ElementType.METHOD_CALL_EXPRESSION, ElementType.NEW_EXPRESSION});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/DeclarationParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/DeclarationParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModifierList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodBody";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Context {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE,
        JSHELL;

    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType() {
            if (this == RESOURCE) {
                return ElementType.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return ElementType.RECORD_HEADER;
            }
            return ElementType.PARAMETER_LIST;
        }

        TokenSet getStopperTypes() {
            if (this == METHOD) {
                return METHOD_PARAM_LIST_STOPPERS;
            }
            return PARAM_LIST_STOPPERS;
        }
    }
}

