/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadActionListener;
import com.intellij.openapi.application.WriteActionListener;
import com.intellij.openapi.application.WriteIntentReadActionListener;
import com.intellij.openapi.application.WriteLockReacquisitionListener;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApplicationEx
extends Application {
    public static final String LOCATOR_FILE_NAME = ".home";
    public static final String PRODUCT_INFO_FILE_NAME = "product-info.json";
    public static final String PRODUCT_INFO_FILE_NAME_MAC = "Resources/product-info.json";
    public static final int FORCE_EXIT = 1;
    public static final int EXIT_CONFIRMED = 2;
    public static final int SAVE = 4;
    public static final int ELEVATE = 8;

    public boolean isWriteActionInProgress();

    public boolean isWriteActionPending();

    @ApiStatus.Internal
    default public boolean isBackgroundWriteActionRunningOrPending() {
        return false;
    }

    public void setSaveAllowed(boolean var1);

    default public void exit(int flags) {
        this.exit();
    }

    default public void exit(int flags, int exitCode) {
        this.exit();
    }

    default public void exit() {
        this.exit(this.isSaveAllowed() ? 4 : 0);
    }

    default public void exit(boolean force, boolean exitConfirmed, int exitCode) {
        int flags = 4;
        if (force) {
            flags |= 1;
        }
        if (exitConfirmed) {
            flags |= 2;
        }
        this.exit(flags, exitCode);
    }

    default public void exit(boolean force, boolean exitConfirmed) {
        this.exit(force, exitConfirmed, 0);
    }

    public void restart(boolean var1);

    default public void restart() {
        this.restart(false);
    }

    default public void restart(boolean exitConfirmed, boolean elevate) {
        this.restart();
    }

    @ApiStatus.Internal
    default public void restart(int flags, String @NotNull [] beforeRestart) {
        if (beforeRestart == null) {
            ApplicationEx.$$$reportNull$$$0(0);
        }
        this.restart();
    }

    @ApiStatus.Internal
    default public boolean runProcessWithProgressSynchronously(@NotNull Runnable process, @NlsContexts.ProgressTitle @NotNull String progressTitle, boolean canBeCanceled, Project project) {
        if (process == null) {
            ApplicationEx.$$$reportNull$$$0(1);
        }
        if (progressTitle == null) {
            ApplicationEx.$$$reportNull$$$0(2);
        }
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, true, project, null, null);
    }

    @ApiStatus.Internal
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NlsContexts.ProgressTitle @NotNull String var2, boolean var3, boolean var4, @Nullable Project var5, @Nullable JComponent var6, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String var7);

    public void assertIsDispatchThread(@Nullable JComponent var1);

    public boolean tryRunReadAction(@NotNull Runnable var1);

    @ApiStatus.Internal
    default public void executeByImpatientReader(@NotNull Runnable runnable) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable == null) {
            ApplicationEx.$$$reportNull$$$0(3);
        }
        runnable.run();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithCancellableProgressInDispatchThread(@NlsContexts.ProgressTitle @NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationEx.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Experimental
    default public boolean runWriteActionWithNonCancellableProgressInDispatchThread(@NlsContexts.ModalProgressTitle @NotNull String title, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull Consumer<? super ProgressIndicator> action2) {
        if (title == null) {
            ApplicationEx.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    @ApiStatus.Internal
    default public boolean isInImpatientReader() {
        return false;
    }

    @ApiStatus.Internal
    default public void runIntendedWriteActionOnCurrentThread(@NotNull Runnable action2) {
        if (action2 == null) {
            ApplicationEx.$$$reportNull$$$0(8);
        }
        action2.run();
    }

    default public boolean isLightEditMode() {
        return false;
    }

    default public boolean isComponentCreated() {
        return true;
    }

    @Deprecated
    @ApiStatus.Internal
    default public void flushNativeEventQueue() {
    }

    @ApiStatus.Internal
    default public void dispatchCoroutineOnEDT(Runnable runnable, ModalityState state2, boolean acquireWriteIntentLockInNonBlockingWay) {
        this.invokeLater(runnable, state2, Conditions.alwaysFalse());
    }

    @ApiStatus.Internal
    default public void addReadActionListener(@NotNull ReadActionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ApplicationEx.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ApplicationEx.$$$reportNull$$$0(10);
        }
    }

    @ApiStatus.Experimental
    default public void addWriteActionListener(@NotNull WriteActionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ApplicationEx.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            ApplicationEx.$$$reportNull$$$0(12);
        }
    }

    @ApiStatus.Internal
    default public void addWriteIntentReadActionListener(@NotNull WriteIntentReadActionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ApplicationEx.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            ApplicationEx.$$$reportNull$$$0(14);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    default public void addSuspendingWriteActionListener(@NotNull WriteLockReacquisitionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ApplicationEx.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            ApplicationEx.$$$reportNull$$$0(16);
        }
    }

    @ApiStatus.Internal
    default public void prohibitTakingLocksInsideAndRun(@NotNull Runnable runnable, @NlsSafe String advice) {
        if (runnable == null) {
            ApplicationEx.$$$reportNull$$$0(17);
        }
        runnable.run();
    }

    @ApiStatus.Internal
    default public void invokeAndWaitRelaxed(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            ApplicationEx.$$$reportNull$$$0(18);
        }
        if (modalityState == null) {
            ApplicationEx.$$$reportNull$$$0(19);
        }
        this.invokeAndWait(runnable, modalityState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRestart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 3: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ex/ApplicationEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restart";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeByImpatientReader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runWriteActionWithCancellableProgressInDispatchThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runWriteActionWithNonCancellableProgressInDispatchThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runIntendedWriteActionOnCurrentThread";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addReadActionListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addWriteActionListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addWriteIntentReadActionListener";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addSuspendingWriteActionListener";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "prohibitTakingLocksInsideAndRun";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAndWaitRelaxed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

