/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.impl.GenericZipFile;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.ResourceHandle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ZipHandler
extends ZipHandlerBase {
    private static final FileAccessorCache<ZipHandler, GenericZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, GenericZipFile>(20, 10){

        @NotNull
        protected GenericZipFile createAccessor(ZipHandler handler) throws IOException {
            Path file = handler.getPath();
            BasicFileAttributes attrs2 = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            handler.myFileStamp = attrs2.lastModifiedTime().toMillis();
            handler.myFileLength = attrs2.size();
            GenericZipFile genericZipFile = ZipHandlerBase.getZipFileWrapper(file);
            if (genericZipFile == null) {
                1.$$$reportNull$$$0(0);
            }
            return genericZipFile;
        }

        protected void disposeAccessor(@NotNull GenericZipFile fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(1);
            }
            fileAccessor.close();
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandler$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAccessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAccessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandler$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeAccessor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private volatile long myFileStamp;
    private volatile long myFileLength;

    public ZipHandler(@NotNull String path) {
        if (path == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @Override
    @NotNull
    protected ResourceHandle<GenericZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle handle;
        try {
            FileAccessorCache.Handle handle2 = ourZipFileFileAccessorCache.get((Object)this);
            Path file = this.getPath();
            BasicFileAttributes attrs2 = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            if (attrs2.lastModifiedTime().toMillis() != this.myFileStamp || attrs2.size() != this.myFileLength) {
                this.clearCaches();
                handle2.release();
                handle2 = ourZipFileFileAccessorCache.get((Object)this);
            }
            handle = handle2;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        if (handle == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        return handle;
    }

    public void clearCaches() {
        ourZipFileFileAccessorCache.remove((Object)this);
        super.clearCaches();
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    @ApiStatus.Internal
    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

