/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml.datasource.action;

import com.intellij.javaee.persistence.database.config.yaml.processor.YamlConfigSinglePropertyProcessor;
import com.intellij.micronaut.config.datasource.MnDataSourceConfigType;
import com.intellij.micronaut.config.datasource.MnDataSourceProvider;
import com.intellij.micronaut.config.datasource.MnPropertiesConfigDatasourceLineMarkerProviderKt;
import com.intellij.micronaut.config.yaml.datasource.MnYamlLineMarkerProviderKt;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSourceProvider;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.KeyPrefixInfo;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/micronaut/config/yaml/datasource/action/MnYamlConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/javaee/persistence/database/config/yaml/processor/YamlConfigSinglePropertyProcessor;", "Lcom/intellij/micronaut/config/datasource/MnDataSourceConfigType;", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "<init>", "()V", "dataSourceProvider", "Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "getDataSourceProvider", "()Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "supportedDataSourceTypes", "", "getSupportedDataSourceTypes", "()Ljava/util/List;", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "convertToInfo", "property", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "documentId", "", "type", "intellij.micronaut.config.yaml"})
final class MnYamlConfigDataSourceSinglePropertyProcessor
extends YamlConfigSinglePropertyProcessor<MnDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> {
    @NotNull
    private final ConfigDataSourceProvider<MnDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> dataSourceProvider = new MnDataSourceProvider();
    @NotNull
    private final List<MnDataSourceConfigType> supportedDataSourceTypes = (List)MnDataSourceConfigType.getEntries();

    @NotNull
    public ConfigDataSourceProvider<MnDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    @NotNull
    public List<MnDataSourceConfigType> getSupportedDataSourceTypes() {
        return this.supportedDataSourceTypes;
    }

    public boolean isApplicable(@Nullable Module module, @Nullable Project project) {
        return MnPropertiesConfigDatasourceLineMarkerProviderKt.hasMicronaut(module, project);
    }

    @Nullable
    public DataSourcePropertyWithPrefixDataInfo convertToInfo(@NotNull YAMLKeyValue property, int documentId, @NotNull MnDataSourceConfigType type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)property);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String fullKey = string;
        KeyPrefixInfo keyPrefixInfo = type.tryToRetrieveApplicablePrefixRegexp(MnYamlLineMarkerProviderKt.withDotAtTheEnd(fullKey));
        if (keyPrefixInfo == null) {
            return null;
        }
        KeyPrefixInfo keyPrefixData = keyPrefixInfo;
        return new DataSourcePropertyWithPrefixDataInfo((PsiElement)property, documentId, keyPrefixData, null, 8, null);
    }
}

