/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.cache;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.JamNavigationUtilsKt;
import com.intellij.jam.JamService;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.cache.MnCacheModelKt;
import com.intellij.micronaut.jam.cache.model.MnCacheBaseElement;
import com.intellij.micronaut.jam.cache.model.MnCacheConfig;
import com.intellij.micronaut.jam.cache.model.MnCacheElement;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0014J,\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J$\u0010\"\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/micronaut/jam/cache/MnCacheableLineMarker;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getId", "", "getName", "getIcon", "Ljavax/swing/Icon;", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "doAnnotateCacheable", "elementToAnnotate", "cacheableElement", "Lcom/intellij/micronaut/jam/cache/model/MnCacheBaseElement;", "findCacheableWithTheSameName", "", "getDefaultCacheNames", "psiElement", "getCacheConfigJam", "Lcom/intellij/micronaut/jam/cache/model/MnCacheConfig;", "psiClass", "Lcom/intellij/psi/PsiClass;", "jamService", "Lcom/intellij/jam/JamService;", "hasSameNames", "names1", "names2", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnCacheableLineMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnCacheableLineMarker.kt\ncom/intellij/micronaut/jam/cache/MnCacheableLineMarker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1807#3,3:114\n*S KotlinDebug\n*F\n+ 1 MnCacheableLineMarker.kt\ncom/intellij/micronaut/jam/cache/MnCacheableLineMarker\n*L\n111#1:114,3\n*E\n"})
public final class MnCacheableLineMarker
extends RelatedItemLineMarkerProvider {
    @NotNull
    public String getId() {
        return "MnCacheableLineMarker";
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.cache.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowCacheable;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowCacheable");
        return icon;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Project project = first.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MicronautUtils.hasMicronautCache(project)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UDeclaration elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)element);
        if (!(elementToProcess instanceof UMethod) && !(elementToProcess instanceof UClass)) {
            return;
        }
        PsiElement psiElement = ((UElement)elementToProcess).getJavaPsi();
        if (psiElement == null) {
            return;
        }
        PsiElement javaPsiElement = psiElement;
        Set<MnCacheBaseElement> cacheableElements = MnCacheModelKt.findAllCacheable(javaPsiElement);
        for (MnCacheBaseElement cacheableElement : cacheableElements) {
            this.doAnnotateCacheable(element, result, cacheableElement);
        }
    }

    private final void doAnnotateCacheable(PsiElement elementToAnnotate, Collection<? super RelatedItemLineMarkerInfo<?>> result, MnCacheBaseElement cacheableElement) {
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)cacheableElement.getAnnotation())));
        if (Intrinsics.areEqual((Object)psiAnnotationIdentifier, (Object)elementToAnnotate)) {
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder customNavigationGutterIconBuilder;
            NotNullFunction convertor = MnCacheableLineMarker::doAnnotateCacheable$lambda$0;
            Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowCacheable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowCacheable");
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder $this$doAnnotateCacheable_u24lambda_u241 = customNavigationGutterIconBuilder = MnLineMarkerBuilder.createCustomNavigationBuilder(icon, convertor, null);
            boolean bl = false;
            $this$doAnnotateCacheable_u24lambda_u241.setTargets(NotNullLazyValue.lazy(() -> MnCacheableLineMarker.doAnnotateCacheable$lambda$1$0(this, cacheableElement)));
            $this$doAnnotateCacheable_u24lambda_u241.setTargetRenderer(JamNavigationUtilsKt::getCacheableTargetRenderer);
            $this$doAnnotateCacheable_u24lambda_u241.setPopupTitle(MicronautBundle.message("micronaut.cache.element.choose.title", new Object[0]));
            $this$doAnnotateCacheable_u24lambda_u241.setEmptyPopupText(MicronautBundle.message("micronaut.cache.element.no.operations", new Object[0]));
            $this$doAnnotateCacheable_u24lambda_u241.setTooltipText(MicronautBundle.message("micronaut.cache.element.tooltip.text", new Object[0]));
            MnLineMarkerBuilder.CustomNavigationGutterIconBuilder builder = customNavigationGutterIconBuilder;
            result.add(builder.createMergeableLineMarkerInfo(psiAnnotationIdentifier));
        }
    }

    private final Set<MnCacheBaseElement> findCacheableWithTheSameName(MnCacheBaseElement cacheableElement) {
        Set<String> cacheNames;
        if (!cacheableElement.isValid()) {
            return SetsKt.emptySet();
        }
        PsiAnnotation psiElement = cacheableElement.getAnnotation();
        Set cacheableElements = new LinkedHashSet();
        Set<String> set = cacheableElement.getCacheNames();
        Set<String> it = set;
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        Object object = !((Collection)it).isEmpty() ? set : null;
        if (object == null) {
            object = this.getDefaultCacheNames((PsiElement)psiElement);
        }
        if (!((Collection)(cacheNames = object)).isEmpty()) {
            Set<MnCacheBaseElement> allCacheable = MnCacheModelKt.findAllCacheable((PsiElement)psiElement);
            for (MnCacheBaseElement element : allCacheable) {
                Set<String> names;
                Set<String> set2;
                if (Intrinsics.areEqual((Object)element, (Object)cacheableElement)) continue;
                Set<String> it2 = set2 = element.getCacheNames();
                boolean bl2 = false;
                Intrinsics.checkNotNull(it2);
                Set<String> set3 = !((Collection)it2).isEmpty() ? set2 : null;
                if (set3 == null) {
                    set3 = this.getDefaultCacheNames((PsiElement)element.getAnnotation());
                }
                if (!this.hasSameNames(names = set3, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    private final Set<String> getDefaultCacheNames(PsiElement psiElement) {
        PsiClass psiClass;
        if (psiElement == null || !psiElement.isValid()) {
            return SetsKt.emptySet();
        }
        if ((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class) == null) {
            return SetsKt.emptySet();
        }
        JamService jamService = JamService.getJamService((Project)psiElement.getProject());
        Intrinsics.checkNotNull((Object)jamService);
        MnCacheConfig cacheConfigJam = this.getCacheConfigJam(psiClass, jamService);
        for (psiClass = v40210; psiClass != null && cacheConfigJam == null; psiClass = psiClass.getSuperClass()) {
            cacheConfigJam = this.getCacheConfigJam(psiClass, jamService);
        }
        Object object = cacheConfigJam;
        if (object == null || (object = ((MnCacheBaseElement)object).getCacheNames()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final MnCacheConfig getCacheConfigJam(PsiClass psiClass, JamService jamService) {
        MnCacheConfig mnCacheConfig;
        PsiClass psiClass2 = psiClass;
        if (psiClass2 != null) {
            PsiClass it = psiClass2;
            boolean bl = false;
            mnCacheConfig = (MnCacheConfig)jamService.getJamElement(MnCacheConfig.JAM_KEY, (PsiElement)it);
        } else {
            mnCacheConfig = null;
        }
        return mnCacheConfig;
    }

    private final boolean hasSameNames(Set<String> names1, Set<String> names2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = names2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!names1.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Collection doAnnotateCacheable$lambda$1$0(MnCacheableLineMarker this$0, MnCacheBaseElement $cacheableElement) {
        return this$0.findCacheableWithTheSameName($cacheableElement);
    }

    private static final Collection doAnnotateCacheable$lambda$0(MnCacheElement it) {
        return ContainerUtil.createMaybeSingletonList((Object)it.getAnnotation());
    }
}

