/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.events.EventSubscription;
import com.intellij.micronaut.events.MnEventUtilsKt;
import com.intellij.micronaut.events.PublishEventPoint;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.jam.beans.MnScheduled;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerGutterNavigationHandlerKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0014J&\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0014J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\f\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\u0006\u0010 \u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/micronaut/provider/beans/MnEventsLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "annotateClass", "", "uClass", "Lorg/jetbrains/uast/UClass;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodCall", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "getPublishEventRenderer", "Lcom/intellij/codeInsight/navigation/impl/PsiTargetPresentationRenderer;", "isLifecycleMethod", "", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "isScheduledMethod", "findEventPublishers", "", "findEventListeners", "psiElement", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnEventsLineMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnEventsLineMarkers.kt\ncom/intellij/micronaut/provider/beans/MnEventsLineMarkers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,160:1\n1#2:161\n171#3:162\n*S KotlinDebug\n*F\n+ 1 MnEventsLineMarkers.kt\ncom/intellij/micronaut/provider/beans/MnEventsLineMarkers\n*L\n145#1:162\n*E\n"})
public final class MnEventsLineMarkers
extends MnLineMarkerProvider {
    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.event.markers", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.Listener;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Listener");
        return icon;
    }

    @Override
    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (MnEventUtilsKt.isEventClass(psiClass)) {
            MnLineMarkerProvider mnLineMarkerProvider = this;
            Icon icon = JavaUltimateIcons.Cdi.Gutter.Event;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Event");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)MnLineMarkerProvider.marker$default(mnLineMarkerProvider, identifier, icon, MicronautBundle.message("micronaut.event.class.tooltip.text", new Object[0]), null, 8, null));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        block8: {
            RelatedItemLineMarkerInfo receiverMarker;
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo;
            Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            PsiMethod psiMethod = uMethod.getJavaPsi();
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
                return;
            }
            if (this.isScheduledMethod(psiMethod)) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.ScheduledEvent;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ScheduledEvent");
                relatedItemLineMarkerInfo = this.marker(identifier, icon, MicronautBundle.message("micronaut.scheduled.method.tooltip.text", new Object[0]), (GutterIconNavigationHandler<PsiElement>)ScheduledDebuggerGutterNavigationHandlerKt.scheduledDebuggerGutterNavigationHandler());
            } else if (this.isLifecycleMethod(psiMethod)) {
                MnLineMarkerProvider mnLineMarkerProvider = this;
                Icon icon = JavaUltimateIcons.Cdi.Gutter.Listener;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Listener");
                relatedItemLineMarkerInfo = MnLineMarkerProvider.marker$default(mnLineMarkerProvider, identifier, icon, MicronautBundle.message("micronaut.lifecycle.method.tooltip.text", new Object[0]), null, 8, null);
            } else if (MnEventUtilsKt.isEventListenerMethod(psiMethod)) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.Listener;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Listener");
                NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.create(icon).setPopupTitle(MicronautBundle.message("micronaut.event.publishers.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.event.publishers.popup.empty", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> MnEventsLineMarkers.annotateMethod$lambda$0(this, psiMethod))).setTooltipText(MicronautBundle.message("micronaut.event.listener.tooltip.text", new Object[0])).setTargetRenderer(this::getPublishEventRenderer);
                Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"setTargetRenderer(...)");
                NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
                relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
            } else {
                relatedItemLineMarkerInfo = null;
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo2 = receiverMarker = relatedItemLineMarkerInfo;
            if (relatedItemLineMarkerInfo2 == null) break block8;
            RelatedItemLineMarkerInfo it = relatedItemLineMarkerInfo2;
            boolean bl = false;
            result.add((RelatedItemLineMarkerInfo<PsiElement>)it);
        }
    }

    @Override
    protected void annotateMethodCall(@NotNull UCallExpression uMethodCall, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!MnEventUtilsKt.isPublishEventExpression(uMethodCall)) {
            return;
        }
        PsiElement psiElement = uMethodCall.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        PsiElement psiElement2 = UElementKt.getSourcePsiElement((UElement)((UElement)uMethodCall.getMethodIdentifier()));
        if (psiElement2 == null) {
            return;
        }
        PsiElement identifier = psiElement2;
        Icon icon = JavaUltimateIcons.Cdi.Gutter.Publisher;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Publisher");
        NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.create(icon).setPopupTitle(MicronautBundle.message("micronaut.event.listeners.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.event.listeners.popup.empty", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> MnEventsLineMarkers.annotateMethodCall$lambda$0(this, sourcePsi))).setTooltipText(MicronautBundle.message("micronaut.event.publisher.tooltip.text", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"setTooltipText(...)");
        NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
    }

    private final PsiTargetPresentationRenderer<PsiElement> getPublishEventRenderer() {
        return (PsiTargetPresentationRenderer)new PsiTargetPresentationRenderer<PsiElement>(){

            protected Icon getIcon(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof PsiMethodCallExpression ? JavaUltimateIcons.Cdi.Gutter.Publisher : super.getIcon(element);
            }

            public String getContainerText(PsiElement element) {
                PsiClass containingClass;
                PsiMethod psiMethod;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiMethodCallExpression && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null && (containingClass = psiMethod.getContainingClass()) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)containingClass))).append(".").append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)psiMethod)));
                    return sb.toString();
                }
                return super.getContainerText(element);
            }
        };
    }

    private final boolean isLifecycleMethod(PsiMethod psiMethod) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)MnBeansConstants.getBEANS_LIFECYCLE_METHODS(), (int)0);
    }

    private final boolean isScheduledMethod(PsiMethod psiMethod) {
        return MnScheduled.META.getJamElement((PsiModifierListOwner)psiMethod) != null;
    }

    private final Collection<PsiElement> findEventPublishers(PsiMethod psiMethod) {
        if (psiMethod.getParameterList().getParametersCount() != 1) {
            return CollectionsKt.emptyList();
        }
        PsiType psiType = psiMethod.getParameterList().getParameters()[0].getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType eventType = psiType;
        if (!eventType.isValid() || !(eventType instanceof PsiClassType)) {
            return CollectionsKt.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        Collection<PublishEventPoint> publishPoints = MnEventUtilsKt.getEventPublishPoints(module2, eventType);
        ArrayList<PsiElement> list = new ArrayList<PsiElement>(publishPoints.size());
        for (PublishEventPoint point : publishPoints) {
            PsiElement element = point.getElement();
            if (element == null) continue;
            list.add(element.getNavigationElement());
        }
        return list;
    }

    private final Collection<PsiElement> findEventListeners(PsiElement psiElement) {
        if (!psiElement.isValid()) {
            return CollectionsKt.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        PsiElement $this$toUElementOfType$iv = psiElement;
        boolean $i$f$toUElementOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
        if (uCallExpression == null) {
            return CollectionsKt.emptyList();
        }
        UCallExpression uCallExpression2 = uCallExpression;
        if (uCallExpression2.getValueArgumentCount() != 1) {
            return CollectionsKt.emptyList();
        }
        PsiType psiType = ((UExpression)uCallExpression2.getValueArguments().get(0)).getExpressionType();
        if (psiType == null) {
            return CollectionsKt.emptyList();
        }
        PsiType eventType = psiType;
        Collection<EventSubscription> eventListeners = MnEventUtilsKt.getEventListeners(module2, eventType);
        ArrayList<PsiElement> list = new ArrayList<PsiElement>(eventListeners.size());
        for (EventSubscription listener : eventListeners) {
            PsiMethod m = listener.getMethod();
            if (m == null) continue;
            list.add(m.getNavigationElement());
        }
        return list;
    }

    private static final Collection annotateMethod$lambda$0(MnEventsLineMarkers this$0, PsiMethod $psiMethod) {
        return this$0.findEventPublishers($psiMethod);
    }

    private static final Collection annotateMethodCall$lambda$0(MnEventsLineMarkers this$0, PsiElement $sourcePsi) {
        return this$0.findEventListeners($sourcePsi);
    }
}

