/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.http.MnHttpNavigationProvider;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getNavigationInfo", "Lcom/intellij/micronaut/provider/http/MnHttpNavigationProvider$MnHttpNavigationInfo;", "mnHttpMethodMapping", "Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "intellij.micronaut"})
public final class MnHttpLineMarkers
extends MnLineMarkerProvider {
    @Override
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (MnHttpUtils.hasHttpServerLibrary(project)) break block3;
                Project project2 = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (MnHttpUtils.hasHttpClientLibrary(project2)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.http.markers", new Object[0]);
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.hasModifierProperty("private") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
            return;
        }
        MnStereotypeElement mnStereotypeElement = MnHttpUtils.getHttpMappingsHolder(containingClass);
        if (mnStereotypeElement == null) {
            return;
        }
        MnStereotypeElement mappingsHolder = mnStereotypeElement;
        if (mappingsHolder instanceof MnController && psiMethod.hasModifierProperty("abstract")) {
            return;
        }
        MnHttpMethodMapping mnHttpMethodMapping = MnHttpUtils.getHttpMapping(psiMethod);
        if (mnHttpMethodMapping == null) {
            return;
        }
        MnHttpMethodMapping mapping = mnHttpMethodMapping;
        String urlMapping = MnHttpUtils.getHttpResourcePath(mapping, psiMethod.getContainingClass());
        MnHttpNavigationProvider.MnHttpNavigationInfo customNavigationInfo = this.getNavigationInfo(mapping);
        if (urlMapping != null && customNavigationInfo != null) {
            Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo2 = MnLineMarkerBuilder.createCustomNavigationBuilder(icon).addGotoRelatedItems(customNavigationInfo.getRelatedItems()).setNavigationHandler(customNavigationInfo.getNavigationHandler()).setTooltipText(customNavigationInfo.getTooltip()).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(identifier);
            Intrinsics.checkNotNull((Object)relatedItemLineMarkerInfo2);
            relatedItemLineMarkerInfo = relatedItemLineMarkerInfo2;
        } else {
            String toolTip = urlMapping == null ? MicronautBundle.message("micronaut.http.method.mapping.tooltip.text", new Object[0]) : (mapping.getHttpMethod() != null ? "[" + mapping.getHttpMethod() + "] " + urlMapping : urlMapping);
            MnLineMarkerProvider mnLineMarkerProvider = this;
            Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
            relatedItemLineMarkerInfo = MnLineMarkerProvider.marker$default(mnLineMarkerProvider, identifier, icon, toolTip, null, 8, null);
        }
        RelatedItemLineMarkerInfo marker = relatedItemLineMarkerInfo;
        result.add((RelatedItemLineMarkerInfo<PsiElement>)marker);
    }

    private final MnHttpNavigationProvider.MnHttpNavigationInfo getNavigationInfo(MnHttpMethodMapping mnHttpMethodMapping) {
        return (MnHttpNavigationProvider.MnHttpNavigationInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)MnHttpNavigationProvider.Companion.getEP_NAME$intellij_micronaut().getExtensionList()), arg_0 -> MnHttpLineMarkers.getNavigationInfo$lambda$0(mnHttpMethodMapping, arg_0)));
    }

    private static final MnHttpNavigationProvider.MnHttpNavigationInfo getNavigationInfo$lambda$0(MnHttpMethodMapping $mnHttpMethodMapping, MnHttpNavigationProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGutterNavigationInfo($mnHttpMethodMapping);
    }
}

