/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.action;

import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceProvider;
import com.intellij.persistence.database.config.properties.processor.PropertiesConfigDataSourceSinglePropertyProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.model.SpringBootPropertiesFileUtil;
import com.intellij.spring.boot.properties.datasource.SpringBootPropertiesConfigDatasourceLineMarkerProviderKt;
import com.intellij.spring.boot.properties.datasource.SpringDataSourceConfigType;
import com.intellij.spring.boot.properties.datasource.SpringDataSourceProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/spring/boot/properties/datasource/action/SpringBootPropertiesConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/persistence/database/config/properties/processor/PropertiesConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/spring/boot/properties/datasource/SpringDataSourceConfigType;", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "<init>", "()V", "dataSourceProvider", "Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "getDataSourceProvider", "()Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "supportedDataSourceTypes", "", "getSupportedDataSourceTypes", "()Ljava/util/List;", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "convertToInfo", "property", "Lcom/intellij/lang/properties/psi/Property;", "documentId", "", "type", "getDocuments", "Lcom/intellij/microservices/jvm/config/properties/MicroservicePropertiesDocument;", "file", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "intellij.spring.boot.properties.datasource"})
final class SpringBootPropertiesConfigDataSourceSinglePropertyProcessor
extends PropertiesConfigDataSourceSinglePropertyProcessor<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> {
    @NotNull
    private final ConfigDataSourceProvider<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> dataSourceProvider = new SpringDataSourceProvider();
    @NotNull
    private final List<SpringDataSourceConfigType> supportedDataSourceTypes = (List)SpringDataSourceConfigType.getEntries();

    @NotNull
    public ConfigDataSourceProvider<SpringDataSourceConfigType, ConfigDataSourcePropertyInfo> getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    @NotNull
    public List<SpringDataSourceConfigType> getSupportedDataSourceTypes() {
        return this.supportedDataSourceTypes;
    }

    public boolean isApplicable(@Nullable Module module, @Nullable Project project) {
        return SpringBootPropertiesConfigDatasourceLineMarkerProviderKt.hasSpringBoot(module, project);
    }

    @NotNull
    public ConfigDataSourcePropertyInfo convertToInfo(@NotNull Property property, int documentId, @NotNull SpringDataSourceConfigType type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new ConfigDataSourcePropertyInfo((PsiElement)property, documentId);
    }

    @NotNull
    public List<MicroservicePropertiesDocument> getDocuments(@NotNull Module module, @NotNull PropertiesFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SpringBootPropertiesFileUtil.Companion.getInstance().getDocuments((PsiFile)file, module);
    }
}

