/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.ext.tool.file.patch;

import ai.koog.agents.core.tools.annotations.LLMDescription;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\b\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lai/koog/agents/ext/tool/file/patch/FilePatch;", "", "original", "", "replacement", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getOriginal$annotations", "()V", "getOriginal", "()Ljava/lang/String;", "getReplacement$annotations", "getReplacement", "isDelete", "", "()Z", "isReplace", "isRewrite", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "agents-ext"})
public final class FilePatch {
    @NotNull
    private final String original;
    @NotNull
    private final String replacement;

    public FilePatch(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.original = original;
        this.replacement = replacement;
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    @LLMDescription(description="The original text to be modified or removed. If empty, the file patch represents a rewrite of whole file")
    public static /* synthetic */ void getOriginal$annotations() {
    }

    @NotNull
    public final String getReplacement() {
        return this.replacement;
    }

    @LLMDescription(description="The replacement text. If empty, the file patch represents a deletion.")
    public static /* synthetic */ void getReplacement$annotations() {
    }

    public final boolean isDelete() {
        return ((CharSequence)this.original).length() > 0 && ((CharSequence)this.replacement).length() == 0;
    }

    public final boolean isReplace() {
        return ((CharSequence)this.original).length() > 0 && ((CharSequence)this.replacement).length() > 0 && !Intrinsics.areEqual((Object)this.original, (Object)this.replacement);
    }

    public final boolean isRewrite() {
        return ((CharSequence)this.original).length() == 0 && ((CharSequence)this.replacement).length() > 0;
    }

    @NotNull
    public final String component1() {
        return this.original;
    }

    @NotNull
    public final String component2() {
        return this.replacement;
    }

    @NotNull
    public final FilePatch copy(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return new FilePatch(original, replacement);
    }

    public static /* synthetic */ FilePatch copy$default(FilePatch filePatch, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = filePatch.original;
        }
        if ((n & 2) != 0) {
            string2 = filePatch.replacement;
        }
        return filePatch.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "FilePatch(original=" + this.original + ", replacement=" + this.replacement + ")";
    }

    public int hashCode() {
        int result2 = this.original.hashCode();
        result2 = result2 * 31 + this.replacement.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FilePatch)) {
            return false;
        }
        FilePatch filePatch = (FilePatch)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)filePatch.original)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.replacement, (Object)filePatch.replacement);
    }
}

