/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc;

import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.mvc.model.feign.CustomEnableFeignClients;
import com.intellij.spring.boot.mvc.model.feign.CustomFeignClient;
import com.intellij.spring.boot.mvc.model.feign.EnableFeignClients;
import com.intellij.spring.boot.mvc.model.feign.EnableFeignClients2;
import com.intellij.spring.boot.mvc.model.feign.FeignClient;
import com.intellij.spring.boot.mvc.model.feign.FeignClient2;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/mvc/SpringBootMvcSemContributor;", "Lcom/intellij/semantic/SemContributor;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "registerSemProviders", "", "registrar", "Lcom/intellij/semantic/SemRegistrar;", "intellij.spring.boot.mvc"})
public final class SpringBootMvcSemContributor
extends SemContributor {
    protected boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringMvcLibraryUtil.hasSpringMvcLibrary((Project)project) || SpringMvcLibraryUtil.hasWebfluxLibrary((Project)project);
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiClassPattern classPattern = PsiJavaPatterns.psiClass();
        String[] stringArray = new String[]{"private"};
        PsiClassPattern nonAnnoClass = (PsiClassPattern)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(stringArray);
        EnableFeignClients.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.cloud.netflix.feign.EnableFeignClients"));
        EnableFeignClients2.META_SB2.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.cloud.openfeign.EnableFeignClients"));
        FeignClient.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.cloud.netflix.feign.FeignClient"));
        FeignClient2.META_SB2.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.cloud.openfeign.FeignClient"));
        SemService semService = SemService.getSemService((Project)project);
        JamMemberMeta[] jamMemberMetaArray = new JamMemberMeta[]{EnableFeignClients.META};
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)((ElementPattern)classPattern), CustomEnableFeignClients.META_KEY, CustomEnableFeignClients.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(CustomEnableFeignClients.JAM_KEY, (Collection)CollectionsKt.listOf((Object)"org.springframework.cloud.netflix.feign.EnableFeignClients"), (arg_0, arg_1) -> SpringBootMvcSemContributor.registerSemProviders$lambda$1(SpringBootMvcSemContributor::registerSemProviders$lambda$0, arg_0, arg_1), null, (BiFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomEnableFeignClients.JAM_ANNO_META_KEY, (JamMemberMeta[])jamMemberMetaArray), (boolean)false));
        jamMemberMetaArray = new JamMemberMeta[]{EnableFeignClients2.META_SB2};
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)((ElementPattern)classPattern), CustomEnableFeignClients.META_KEY, CustomEnableFeignClients.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(CustomEnableFeignClients.JAM_KEY, (Collection)CollectionsKt.listOf((Object)"org.springframework.cloud.openfeign.EnableFeignClients"), (arg_0, arg_1) -> SpringBootMvcSemContributor.registerSemProviders$lambda$3(SpringBootMvcSemContributor::registerSemProviders$lambda$2, arg_0, arg_1), null, (BiFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomEnableFeignClients.JAM_ANNO_META_KEY, (JamMemberMeta[])jamMemberMetaArray), (boolean)false));
        jamMemberMetaArray = new JamMemberMeta[]{FeignClient.META};
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)((ElementPattern)nonAnnoClass), CustomFeignClient.META_KEY, CustomFeignClient.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(CustomFeignClient.JAM_KEY, (Collection)CollectionsKt.listOf((Object)"org.springframework.cloud.netflix.feign.FeignClient"), (arg_0, arg_1) -> SpringBootMvcSemContributor.registerSemProviders$lambda$5(SpringBootMvcSemContributor::registerSemProviders$lambda$4, arg_0, arg_1), (Consumer)SpringSemContributorUtil.createStereotypeConsumer(), (BiFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomFeignClient.JAM_ANNO_META_KEY, (JamMemberMeta[])jamMemberMetaArray), (boolean)false));
        jamMemberMetaArray = new JamMemberMeta[]{FeignClient2.META_SB2};
        SpringSemContributorUtil.registerMetaComponents((SemService)semService, (SemRegistrar)registrar, (ElementPattern)((ElementPattern)nonAnnoClass), CustomFeignClient.META_KEY, CustomFeignClient.JAM_KEY, (Function)SpringSemContributorUtil.createFunction(CustomFeignClient.JAM_KEY, (Collection)CollectionsKt.listOf((Object)"org.springframework.cloud.openfeign.FeignClient"), (arg_0, arg_1) -> SpringBootMvcSemContributor.registerSemProviders$lambda$7(SpringBootMvcSemContributor::registerSemProviders$lambda$6, arg_0, arg_1), (Consumer)SpringSemContributorUtil.createStereotypeConsumer(), (BiFunction)SpringAliasForUtils.getAnnotationMetaProducer(CustomFeignClient.JAM_ANNO_META_KEY, (JamMemberMeta[])jamMemberMetaArray), (boolean)false));
    }

    private static final CustomEnableFeignClients registerSemProviders$lambda$0(String anno, PsiClass psi) {
        return new CustomEnableFeignClients(anno, psi, "org.springframework.cloud.netflix.feign.EnableFeignClients", FeignClient::getClients);
    }

    private static final CustomEnableFeignClients registerSemProviders$lambda$1(Function2 $tmp0, String p0, Object p1) {
        return (CustomEnableFeignClients)((Object)$tmp0.invoke((Object)p0, p1));
    }

    private static final CustomEnableFeignClients registerSemProviders$lambda$2(String anno, PsiClass psi) {
        return new CustomEnableFeignClients(anno, psi, "org.springframework.cloud.openfeign.EnableFeignClients", FeignClient2::getClients);
    }

    private static final CustomEnableFeignClients registerSemProviders$lambda$3(Function2 $tmp0, String p0, Object p1) {
        return (CustomEnableFeignClients)((Object)$tmp0.invoke((Object)p0, p1));
    }

    private static final CustomFeignClient registerSemProviders$lambda$4(String anno, PsiClass psi) {
        return new CustomFeignClient(anno, psi, "org.springframework.cloud.netflix.feign.FeignClient", FeignClient.META);
    }

    private static final CustomFeignClient registerSemProviders$lambda$5(Function2 $tmp0, String p0, Object p1) {
        return (CustomFeignClient)((Object)$tmp0.invoke((Object)p0, p1));
    }

    private static final CustomFeignClient registerSemProviders$lambda$6(String anno, PsiClass psi) {
        return new CustomFeignClient(anno, psi, "org.springframework.cloud.openfeign.FeignClient", FeignClient2.META_SB2);
    }

    private static final CustomFeignClient registerSemProviders$lambda$7(Function2 $tmp0, String p0, Object p1) {
        return (CustomFeignClient)((Object)$tmp0.invoke((Object)p0, p1));
    }
}

