/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.mvc.config.viewresolver.TemplateAvailabilityProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;

class MustacheTemplateAvailabilityProvider
extends TemplateAvailabilityProvider {
    MustacheTemplateAvailabilityProvider() {
    }

    @Override
    public boolean isTemplateAvailable(ConditionalOnEvaluationContext context, String viewName) {
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)"com.samskivert.mustache.Mustache") == null) {
            return false;
        }
        String prefix = MustacheTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.mustache.prefix");
        String suffix = MustacheTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.mustache.suffix");
        return MustacheTemplateAvailabilityProvider.isResourceAvailable(context, prefix + viewName + suffix);
    }
}

