/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.history;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.dataSource.history.ManualStateHolderKt;
import com.intellij.database.dataSource.history.StateHolder;
import com.intellij.database.util.InternedJDomReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/history/ManualStateHolder;", "Lcom/intellij/database/dataSource/history/StateHolder;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lorg/jdom/Element;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jdom/Element;)V", "Lorg/jetbrains/annotations/NotNull;", "cachedDataSource", "Lkotlin/Lazy;", "Lcom/intellij/database/dataSource/LocalDataSource;", "writeStateTo", "", "container", "resolveDataSource", "deserializeState", "intellij.database.connectivity"})
public final class ManualStateHolder
extends StateHolder {
    @NotNull
    private final Project project;
    @NotNull
    private final Element state;
    @NotNull
    private final Lazy<LocalDataSource> cachedDataSource;

    public ManualStateHolder(@NotNull Project project, @NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.project = project;
        Element element = JDOMUtil.internElement((Element)state);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"internElement(...)");
        this.state = element;
        this.cachedDataSource = LazyKt.lazy(() -> ManualStateHolder.cachedDataSource$lambda$0(this));
    }

    @Override
    public void writeStateTo(@NotNull Element container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        container.addContent(this.state.clone());
    }

    @Override
    @NotNull
    public LocalDataSource resolveDataSource() {
        return (LocalDataSource)this.cachedDataSource.getValue();
    }

    private final LocalDataSource deserializeState() {
        try {
            LocalDataSource ds = new LocalDataSource();
            LocalDataSourceSerialization.deserialize((Project)this.project, (LocalDataSource)ds, (HierarchicalStreamReader)((HierarchicalStreamReader)new InternedJDomReader(this.state)), (LocalDataSourceSerialization.SaveMode)LocalDataSourceSerialization.SaveMode.WITHOUT_SCHEMA);
            return ds;
        }
        catch (Throwable e) {
            ManualStateHolderKt.access$getLog$p().error("Failed to deserialize data source", e);
            throw e;
        }
    }

    private static final LocalDataSource cachedDataSource$lambda$0(ManualStateHolder this$0) {
        return this$0.deserializeState();
    }
}

