/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/model/impl/AbstractBuildFileProvider;", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectDependenciesModelClass", "Ljava/lang/Class;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "getProjectDependenciesModelClass", "()Ljava/lang/Class;", "importedPackages", "", "Lcom/intellij/packageChecker/model/Package;", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "getRoots", "", "", "pkgs", "intellij.packageChecker"})
public abstract class AbstractBuildFileProvider
implements BuildFileProvider {
    @NotNull
    private final Project project;

    public AbstractBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected abstract Class<? extends ProjectDependenciesModelBase<MutableModuleModel>> getProjectDependenciesModelClass();

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProjectDependenciesModelBase dependencyModel = (ProjectDependenciesModelBase)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(this.getProjectDependenciesModelClass(), (AreaInstance)this.project);
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return dependencyModel.importedPackages(virtualFile);
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = module.getModuleFile();
        if (virtualFile == null || (virtualFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)this.project)) == null) {
            return CollectionsKt.emptyList();
        }
        return this.importedPackages((PsiFile)virtualFile);
    }

    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        return ((ProjectDependenciesModelBase)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(this.getProjectDependenciesModelClass(), (AreaInstance)this.project)).getRoots(file);
    }
}

