/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model.utils;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J#\u0010\n\u001a\u00020\u00072\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/packageChecker/model/utils/StringUtils;", "", "<init>", "()V", "digits", "", "byteArrayToHexString", "", "bytes", "", "calculateContentsHashSha256", "content", "", "([Ljava/lang/Object;)Ljava/lang/String;", "encodeSpacesForUrl", "str", "intellij.packageChecker"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    @NotNull
    private static final char[] digits;

    private StringUtils() {
    }

    private final String byteArrayToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            byte bInt = b = bytes[i];
            result.append(digits[bInt >> 4 & 0xF]);
            result.append(digits[bInt & 0xF]);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String calculateContentsHashSha256(Object ... content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = ArraysKt.joinToString$default((Object[])content, (CharSequence)":", null, null, (int)0, null, StringUtils::calculateContentsHashSha256$lambda$0, (int)30, null);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return this.byteArrayToHexString(byArray2);
    }

    @NotNull
    public final String encodeSpacesForUrl(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.replace$default((String)str, (String)" ", (String)"%20", (boolean)false, (int)4, null);
    }

    private static final CharSequence calculateContentsHashSha256$lambda$0(Object word) {
        return String.valueOf(word);
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        digits = cArray;
    }
}

