/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.credentialStore.kdbx.SecureString;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/credentialStore/kdbx/ProtectedValue;", "Lorg/jdom/Text;", "Lcom/intellij/credentialStore/kdbx/SecureString;", "encryptedValue", "", "position", "", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "<init>", "([BILorg/bouncycastle/crypto/SkippingStreamCipher;)V", "get", "Lcom/intellij/credentialStore/OneTimeString;", "clearable", "", "setNewStreamCipher", "", "newStreamCipher", "decryptInto", "out", "getText", "", "encodeToBase64", "", "intellij.platform.credentialStore.impl"})
public final class ProtectedValue
extends Text
implements SecureString {
    @NotNull
    private byte[] encryptedValue;
    private int position;
    @NotNull
    private SkippingStreamCipher streamCipher;

    public ProtectedValue(@NotNull byte[] encryptedValue, int position, @NotNull SkippingStreamCipher streamCipher) {
        Intrinsics.checkNotNullParameter((Object)encryptedValue, (String)"encryptedValue");
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        this.encryptedValue = encryptedValue;
        this.position = position;
        this.streamCipher = streamCipher;
    }

    @Override
    @NotNull
    public synchronized OneTimeString get(boolean clearable) {
        byte[] output = new byte[this.encryptedValue.length];
        this.decryptInto(output);
        return OneTimeStringKt.OneTimeString$default((byte[])output, (int)0, (int)0, (boolean)clearable, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setNewStreamCipher(@NotNull SkippingStreamCipher newStreamCipher) {
        Intrinsics.checkNotNullParameter((Object)newStreamCipher, (String)"newStreamCipher");
        byte[] value = this.encryptedValue;
        this.decryptInto(value);
        SkippingStreamCipher skippingStreamCipher = newStreamCipher;
        synchronized (skippingStreamCipher) {
            boolean bl = false;
            this.position = (int)newStreamCipher.getPosition();
            int n = newStreamCipher.processBytes(value, 0, value.length, value, 0);
        }
        this.streamCipher = newStreamCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void decryptInto(byte[] out) {
        SkippingStreamCipher skippingStreamCipher = this.streamCipher;
        synchronized (skippingStreamCipher) {
            boolean bl = false;
            this.streamCipher.seekTo((long)this.position);
            int n = this.streamCipher.processBytes(this.encryptedValue, 0, this.encryptedValue.length, out, 0);
        }
    }

    @NotNull
    public Void getText() {
        throw new IllegalStateException("encodeToBase64 must be used for serialization");
    }

    @NotNull
    public final String encodeToBase64() {
        String string;
        if (this.encryptedValue.length == 0) {
            string = "";
        } else {
            String string2 = Base64.getEncoder().encodeToString(this.encryptedValue);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        }
        return string;
    }
}

