/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparatorCore;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl;", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "preferences", "", "Lorg/jetbrains/plugins/textmate/language/preferences/Preferences;", "leftHighlightingBraces", "", "", "rightHighlightingBraces", "leftSmartTypingBraces", "rightSmartTypingBraces", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;Ljava/util/Collection;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "isPossibleLeftHighlightingBrace", "", "firstLeftBraceChar", "", "isPossibleRightHighlightingBrace", "lastRightBraceChar", "isPossibleLeftSmartTypingBrace", "lastLeftBraceChar", "isPossibleRightSmartTypingBrace", "getPreferences", "", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "intellij.textmate.core"})
public final class PreferencesRegistryImpl
implements PreferencesRegistry {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final Collection<Preferences> preferences;
    @NotNull
    private final Set<Integer> leftHighlightingBraces;
    @NotNull
    private final Set<Integer> rightHighlightingBraces;
    @NotNull
    private final Set<Integer> leftSmartTypingBraces;
    @NotNull
    private final Set<Integer> rightSmartTypingBraces;

    public PreferencesRegistryImpl(@NotNull TextMateSelectorWeigher weigher, @NotNull Collection<Preferences> preferences, @NotNull Set<Integer> leftHighlightingBraces, @NotNull Set<Integer> rightHighlightingBraces, @NotNull Set<Integer> leftSmartTypingBraces, @NotNull Set<Integer> rightSmartTypingBraces) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        Intrinsics.checkNotNullParameter(preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter(leftHighlightingBraces, (String)"leftHighlightingBraces");
        Intrinsics.checkNotNullParameter(rightHighlightingBraces, (String)"rightHighlightingBraces");
        Intrinsics.checkNotNullParameter(leftSmartTypingBraces, (String)"leftSmartTypingBraces");
        Intrinsics.checkNotNullParameter(rightSmartTypingBraces, (String)"rightSmartTypingBraces");
        this.weigher = weigher;
        this.preferences = preferences;
        this.leftHighlightingBraces = leftHighlightingBraces;
        this.rightHighlightingBraces = rightHighlightingBraces;
        this.leftSmartTypingBraces = leftSmartTypingBraces;
        this.rightSmartTypingBraces = rightSmartTypingBraces;
    }

    public /* synthetic */ PreferencesRegistryImpl(TextMateSelectorWeigher textMateSelectorWeigher, Collection collection, Set set, Set set2, Set set3, Set set4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            set4 = SetsKt.emptySet();
        }
        this(textMateSelectorWeigher, collection, set, set2, set3, set4);
    }

    @Override
    public boolean isPossibleLeftHighlightingBrace(char firstLeftBraceChar) {
        return this.leftHighlightingBraces.contains(firstLeftBraceChar) || firstLeftBraceChar != ' ' && this.leftSmartTypingBraces.contains(firstLeftBraceChar);
    }

    @Override
    public boolean isPossibleRightHighlightingBrace(char lastRightBraceChar) {
        return this.rightHighlightingBraces.contains(lastRightBraceChar) || lastRightBraceChar != ' ' && this.rightSmartTypingBraces.contains(lastRightBraceChar);
    }

    @Override
    public boolean isPossibleLeftSmartTypingBrace(char lastLeftBraceChar) {
        return this.leftSmartTypingBraces.contains(lastLeftBraceChar);
    }

    @Override
    public boolean isPossibleRightSmartTypingBrace(char lastRightBraceChar) {
        return this.rightSmartTypingBraces.contains(lastRightBraceChar);
    }

    @Override
    @NotNull
    public List<Preferences> getPreferences(@NotNull TextMateScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new TextMateScopeComparatorCore<Preferences>(this.weigher, scope, (Function1)getPreferences.1.INSTANCE).sortAndFilter(this.preferences);
    }
}

