/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.rd.platform.util.CertificateExKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003$%&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate;", "", "<init>", "()V", "KEY_ALIAS", "", "cwmSessionCertificateData", "Lkotlin/Lazy;", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$SelfSignedCertificateData;", "getCwmSessionCertificateData", "()Lkotlin/Lazy;", "productCodesIdentifier", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "getProductCodesIdentifier", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "flsUrlIdentifier", "getFlsUrlIdentifier", "LS_URL_ENVIRONMENT_VAR", "generateNewCertificate", "keyPassword", "", "subjectName", "Lorg/bouncycastle/asn1/x500/X500Name;", "issuer", "Ljava/security/cert/X509Certificate;", "days", "", "productInfoFlags", "getProductInfo", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;", "createSubjectKeyId", "Lorg/bouncycastle/asn1/x509/SubjectKeyIdentifier;", "publicKey", "Ljava/security/PublicKey;", "createAuthorityKeyId", "Lorg/bouncycastle/asn1/x509/AuthorityKeyIdentifier;", "SelfSignedCertificateData", "ProductInfo", "PluginInfo", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nSelfSignedCertificate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelfSignedCertificate.kt\ncom/intellij/platform/split/connection/impl/SelfSignedCertificate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
public final class SelfSignedCertificate {
    @NotNull
    public static final SelfSignedCertificate INSTANCE = new SelfSignedCertificate();
    @NotNull
    private static final String KEY_ALIAS = "codewithme";
    @NotNull
    private static final Lazy<SelfSignedCertificateData> cwmSessionCertificateData = LazyKt.lazy(SelfSignedCertificate::cwmSessionCertificateData$lambda$0);
    @NotNull
    private static final ASN1ObjectIdentifier productCodesIdentifier;
    @NotNull
    private static final ASN1ObjectIdentifier flsUrlIdentifier;
    @NotNull
    private static final String LS_URL_ENVIRONMENT_VAR = "JETBRAINS_LICENSE_SERVER";

    private SelfSignedCertificate() {
    }

    @NotNull
    public final Lazy<SelfSignedCertificateData> getCwmSessionCertificateData() {
        return cwmSessionCertificateData;
    }

    @NotNull
    public final ASN1ObjectIdentifier getProductCodesIdentifier() {
        return productCodesIdentifier;
    }

    @NotNull
    public final ASN1ObjectIdentifier getFlsUrlIdentifier() {
        return flsUrlIdentifier;
    }

    @NotNull
    public final SelfSignedCertificateData generateNewCertificate(@NotNull char[] keyPassword, @NotNull X500Name subjectName, @Nullable X509Certificate issuer, int days, int productInfoFlags) {
        X509Certificate[] x509CertificateArray;
        String flsUrl;
        String string;
        KeyPairGenerator keyPairGenerator;
        Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkNotNullParameter((Object)subjectName, (String)"subjectName");
        KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        it.initialize(2048);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        KeyPair subjectKeyPair = keyPairGenerator2.genKeyPair();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        Instant now = instant;
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(Duration.ofDays(days)));
        X500Principal subjectPrincipal = new X500Principal(subjectName.getEncoded());
        BigInteger subjectSerial = BigInteger.valueOf(now.toEpochMilli());
        boolean isCA = issuer == null;
        X509Certificate x509Certificate = issuer;
        X500Principal issuerPrincipal = x509Certificate != null ? x509Certificate.getSubjectX500Principal() : subjectPrincipal;
        X509Certificate x509Certificate2 = issuer;
        PublicKey issuerPublicKey = x509Certificate2 != null ? x509Certificate2.getPublicKey() : subjectKeyPair.getPublic();
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(X500Name.getInstance((Object)issuerPrincipal.getEncoded()), subjectSerial, notBefore, notAfter, Locale.ENGLISH, X500Name.getInstance((Object)subjectPrincipal.getEncoded()), SubjectPublicKeyInfo.getInstance((Object)subjectKeyPair.getPublic().getEncoded()));
        PublicKey publicKey = subjectKeyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        X509v3CertificateBuilder x509v3CertificateBuilder2 = x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyId(publicKey));
        Intrinsics.checkNotNull((Object)issuerPublicKey);
        X509v3CertificateBuilder x509v3CertificateBuilder3 = x509v3CertificateBuilder2.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.createAuthorityKeyId(issuerPublicKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCA));
        Intrinsics.checkNotNullExpressionValue((Object)x509v3CertificateBuilder3, (String)"addExtension(...)");
        X509v3CertificateBuilder certificateBuilder = x509v3CertificateBuilder3;
        ProductInfo productInfo = this.getProductInfo(productInfoFlags);
        if (productInfo != null) {
            certificateBuilder.addExtension(productCodesIdentifier, false, (ASN1Encodable)new DERUTF8String(productInfo.toExternalForm()));
        }
        if ((string = EnvironmentUtil.getValue((String)LS_URL_ENVIRONMENT_VAR)) == null) {
            string = System.getProperty(LS_URL_ENVIRONMENT_VAR, null);
        }
        if ((flsUrl = string) != null) {
            certificateBuilder.addExtension(flsUrlIdentifier, false, (ASN1Encodable)new DERUTF8String(flsUrl));
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA512WithRSA").build(subjectKeyPair.getPrivate());
        X509Certificate x509Certificate3 = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
        Intrinsics.checkNotNull((Object)x509Certificate3);
        X509Certificate certificate = x509Certificate3;
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(null, null);
        if (issuer != null) {
            var23_23 = new X509Certificate[]{certificate, issuer};
            x509CertificateArray = var23_23;
        } else {
            var23_23 = new X509Certificate[]{certificate};
            x509CertificateArray = var23_23;
        }
        X509Certificate[] chain = x509CertificateArray;
        keystore.setKeyEntry(KEY_ALIAS, subjectKeyPair.getPrivate(), keyPassword, chain);
        String string2 = CertificateExKt.getSha3Fingerprint((Certificate)certificate);
        Intrinsics.checkNotNull((Object)keystore);
        return new SelfSignedCertificateData(certificate, string2, keystore, KEY_ALIAS, keyPassword, productInfo);
    }

    public static /* synthetic */ SelfSignedCertificateData generateNewCertificate$default(SelfSignedCertificate selfSignedCertificate, char[] cArray, X500Name x500Name, X509Certificate x509Certificate, int n, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        return selfSignedCertificate.generateNewCertificate(cArray, x500Name, x509Certificate, n, n2);
    }

    private final ProductInfo getProductInfo(int productInfoFlags) {
        Object hostStamp;
        Object object;
        ApplicationInfoEx app;
        ArrayList<PluginInfo> plugins;
        String platformPrefix;
        block10: {
            block9: {
                Object v4;
                block8: {
                    String string = PlatformUtils.getPlatformPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlatformPrefix(...)");
                    platformPrefix = string;
                    if (StringsKt.isBlank((CharSequence)platformPrefix)) {
                        return null;
                    }
                    plugins = new ArrayList<PluginInfo>();
                    for (IdeaPluginDescriptor plugin : PluginManagerCore.getLoadedPlugins()) {
                        String productCode = plugin.getProductCode();
                        if (productCode == null) continue;
                        String string2 = plugin.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        plugins.add(new PluginInfo(productCode, string2, plugin.getPluginId().getIdString(), plugin.getReleaseDate(), plugin.getReleaseVersion(), plugin.isLicenseOptional(), 0));
                    }
                    ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
                    app = applicationInfoEx;
                    object = LicensingFacade.getInstance();
                    if (object == null || (object = ((LicensingFacade)object).confirmationStamps) == null || (object = object.values()) == null) break block9;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        String it = (String)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.startsWith$default((String)it, (String)"rdhost:", (boolean)false, (int)2, null)) continue;
                        v4 = t;
                        break block8;
                    }
                    v4 = null;
                }
                if ((object = (String)v4) != null) break block10;
            }
            object = "";
        }
        if (StringsKt.startsWith$default((String)(hostStamp = object), (String)"rdhost:RMDVEH:", (boolean)false, (int)2, null)) {
            Comparable<Calendar> comparable = app.getMajorReleaseBuildDate();
            if (comparable == null || (comparable = comparable.getTime()) == null) {
                comparable = new Date();
            }
            plugins.add(new PluginInfo("RMDVEC", "Enterprise Client Plugin", "RMDVEC", (Date)comparable, app.getBuild().getBaselineVersion(), false, 0));
        }
        String string = app.getVersionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionName(...)");
        Calendar calendar = app.getMajorReleaseBuildDate();
        return new ProductInfo(platformPrefix, string, calendar != null ? calendar.getTime() : null, app.getBuild().getBaselineVersion(), (List<PluginInfo>)plugins, productInfoFlags, (String)hostStamp);
    }

    private final SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"getInstance(...)");
        SubjectPublicKeyInfo publicKeyInfo = subjectPublicKeyInfo;
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        Intrinsics.checkNotNullExpressionValue((Object)digestCalculator, (String)"get(...)");
        DigestCalculator digCalc = digestCalculator;
        return new X509ExtensionUtils(digCalc).createSubjectKeyIdentifier(publicKeyInfo);
    }

    private final AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)subjectPublicKeyInfo, (String)"getInstance(...)");
        SubjectPublicKeyInfo publicKeyInfo = subjectPublicKeyInfo;
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        Intrinsics.checkNotNullExpressionValue((Object)digestCalculator, (String)"get(...)");
        DigestCalculator digCalc = digestCalculator;
        return new X509ExtensionUtils(digCalc).createAuthorityKeyIdentifier(publicKeyInfo);
    }

    private static final SelfSignedCertificateData cwmSessionCertificateData$lambda$0() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] keyPassword = cArray;
        X500Name x500Name = new X500NameBuilder().addRDN(RFC4519Style.cn, UUID.randomUUID().toString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)x500Name, (String)"build(...)");
        return SelfSignedCertificate.generateNewCertificate$default(INSTANCE, keyPassword, x500Name, null, 60, 0, 16, null);
    }

    static {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.3.6.1.4.1.57712.78.1").intern();
        Intrinsics.checkNotNull((Object)aSN1ObjectIdentifier);
        productCodesIdentifier = aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier("1.3.6.1.4.1.57712.78.2").intern();
        Intrinsics.checkNotNull((Object)aSN1ObjectIdentifier2);
        flsUrlIdentifier = aSN1ObjectIdentifier2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003JQ\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\tH\u00c6\u0001J\u0014\u0010'\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010)\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010*\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$PluginInfo;", "", "productCode", "", "name", "id", "releaseDate", "Ljava/util/Date;", "releaseVersion", "", "optional", "", "flags", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;IZI)V", "getProductCode", "()Ljava/lang/String;", "getName", "getId", "getReleaseDate", "()Ljava/util/Date;", "getReleaseVersion", "()I", "getOptional", "()Z", "getFlags", "toStream", "", "out", "Ljava/io/DataOutput;", "toStream$intellij_platform_split_connection", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.platform.split.connection"})
    public static final class PluginInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String productCode;
        @NotNull
        private final String name;
        @NotNull
        private final String id;
        @Nullable
        private final Date releaseDate;
        private final int releaseVersion;
        private final boolean optional;
        private final int flags;

        public PluginInfo(@NotNull String productCode, @NotNull String name, @NotNull String id, @Nullable Date releaseDate, int releaseVersion, boolean optional, int flags) {
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.productCode = productCode;
            this.name = name;
            this.id = id;
            this.releaseDate = releaseDate;
            this.releaseVersion = releaseVersion;
            this.optional = optional;
            this.flags = flags;
        }

        @NotNull
        public final String getProductCode() {
            return this.productCode;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final Date getReleaseDate() {
            return this.releaseDate;
        }

        public final int getReleaseVersion() {
            return this.releaseVersion;
        }

        public final boolean getOptional() {
            return this.optional;
        }

        public final int getFlags() {
            return this.flags;
        }

        public final void toStream$intellij_platform_split_connection(@NotNull DataOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.flags);
            out.writeUTF(this.productCode);
            out.writeUTF(this.name);
            out.writeUTF(this.id);
            out.writeInt(ProductInfo.Companion.encodeDate$intellij_platform_split_connection(this.releaseDate));
            out.writeInt(this.releaseVersion);
            out.writeBoolean(this.optional);
        }

        @NotNull
        public final String component1() {
            return this.productCode;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.id;
        }

        @Nullable
        public final Date component4() {
            return this.releaseDate;
        }

        public final int component5() {
            return this.releaseVersion;
        }

        public final boolean component6() {
            return this.optional;
        }

        public final int component7() {
            return this.flags;
        }

        @NotNull
        public final PluginInfo copy(@NotNull String productCode, @NotNull String name, @NotNull String id, @Nullable Date releaseDate, int releaseVersion, boolean optional, int flags) {
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new PluginInfo(productCode, name, id, releaseDate, releaseVersion, optional, flags);
        }

        public static /* synthetic */ PluginInfo copy$default(PluginInfo pluginInfo, String string, String string2, String string3, Date date, int n, boolean bl, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = pluginInfo.productCode;
            }
            if ((n3 & 2) != 0) {
                string2 = pluginInfo.name;
            }
            if ((n3 & 4) != 0) {
                string3 = pluginInfo.id;
            }
            if ((n3 & 8) != 0) {
                date = pluginInfo.releaseDate;
            }
            if ((n3 & 0x10) != 0) {
                n = pluginInfo.releaseVersion;
            }
            if ((n3 & 0x20) != 0) {
                bl = pluginInfo.optional;
            }
            if ((n3 & 0x40) != 0) {
                n2 = pluginInfo.flags;
            }
            return pluginInfo.copy(string, string2, string3, date, n, bl, n2);
        }

        @NotNull
        public String toString() {
            return "PluginInfo(productCode=" + this.productCode + ", name=" + this.name + ", id=" + this.id + ", releaseDate=" + this.releaseDate + ", releaseVersion=" + this.releaseVersion + ", optional=" + this.optional + ", flags=" + this.flags + ")";
        }

        public int hashCode() {
            int result = this.productCode.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
            result = result * 31 + Integer.hashCode(this.releaseVersion);
            result = result * 31 + Boolean.hashCode(this.optional);
            result = result * 31 + Integer.hashCode(this.flags);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginInfo)) {
                return false;
            }
            PluginInfo pluginInfo = (PluginInfo)other;
            if (!Intrinsics.areEqual((Object)this.productCode, (Object)pluginInfo.productCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)pluginInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)pluginInfo.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.releaseDate, (Object)pluginInfo.releaseDate)) {
                return false;
            }
            if (this.releaseVersion != pluginInfo.releaseVersion) {
                return false;
            }
            if (this.optional != pluginInfo.optional) {
                return false;
            }
            return this.flags == pluginInfo.flags;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$PluginInfo$Companion;", "", "<init>", "()V", "fromStream", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$PluginInfo;", "input", "Ljava/io/DataInput;", "fromStream$intellij_platform_split_connection", "intellij.platform.split.connection"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PluginInfo fromStream$intellij_platform_split_connection(@NotNull DataInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                int flags = input.readInt();
                String productCode = input.readUTF();
                String name = input.readUTF();
                String id = input.readUTF();
                Date releaseDate = ProductInfo.Companion.decodeDate$intellij_platform_split_connection(input.readInt());
                int releaseVersion = input.readInt();
                boolean isOptional = input.readBoolean();
                Intrinsics.checkNotNull((Object)productCode);
                Intrinsics.checkNotNull((Object)name);
                Intrinsics.checkNotNull((Object)id);
                return new PluginInfo(productCode, name, id, releaseDate, releaseVersion, isOptional, flags);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003JW\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010-\u001a\u00020\u001c2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010/\u001a\u00020\bH\u00d6\u0081\u0004J\n\u00100\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011\u00a8\u00062"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;", "", "platformPrefix", "", "name", "releaseDate", "Ljava/util/Date;", "releaseVersion", "", "plugins", "", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$PluginInfo;", "flags", "hostStamp", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;ILjava/util/List;ILjava/lang/String;)V", "getPlatformPrefix", "()Ljava/lang/String;", "getName", "getReleaseDate", "()Ljava/util/Date;", "getReleaseVersion", "()I", "getPlugins", "()Ljava/util/List;", "getFlags", "getHostStamp", "isCE", "", "getEffectivePlatformPrefix", "isSet", "flagMask", "toExternalForm", "toStream", "", "out", "Ljava/io/DataOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.platform.split.connection"})
    public static final class ProductInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String platformPrefix;
        @NotNull
        private final String name;
        @Nullable
        private final Date releaseDate;
        private final int releaseVersion;
        @NotNull
        private final List<PluginInfo> plugins;
        private final int flags;
        @NotNull
        private final String hostStamp;
        public static final int FLAG_UNATTENDED_MODE = 1;

        public ProductInfo(@NotNull String platformPrefix, @NotNull String name, @Nullable Date releaseDate, int releaseVersion, @NotNull List<PluginInfo> plugins, int flags, @NotNull String hostStamp) {
            Intrinsics.checkNotNullParameter((Object)platformPrefix, (String)"platformPrefix");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
            Intrinsics.checkNotNullParameter((Object)hostStamp, (String)"hostStamp");
            this.platformPrefix = platformPrefix;
            this.name = name;
            this.releaseDate = releaseDate;
            this.releaseVersion = releaseVersion;
            this.plugins = plugins;
            this.flags = flags;
            this.hostStamp = hostStamp;
        }

        public /* synthetic */ ProductInfo(String string, String string2, Date date, int n, List list, int n2, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x40) != 0) {
                string3 = "";
            }
            this(string, string2, date, n, list, n2, string3);
        }

        @NotNull
        public final String getPlatformPrefix() {
            return this.platformPrefix;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Date getReleaseDate() {
            return this.releaseDate;
        }

        public final int getReleaseVersion() {
            return this.releaseVersion;
        }

        @NotNull
        public final List<PluginInfo> getPlugins() {
            return this.plugins;
        }

        public final int getFlags() {
            return this.flags;
        }

        @NotNull
        public final String getHostStamp() {
            return this.hostStamp;
        }

        public final boolean isCE() {
            return Intrinsics.areEqual((Object)this.platformPrefix, (Object)"Idea") || Intrinsics.areEqual((Object)this.platformPrefix, (Object)"PyCharmCore");
        }

        @NotNull
        public final String getEffectivePlatformPrefix() {
            return switch (this.platformPrefix) {
                case "Idea" -> "idea";
                case "IdeaEdu" -> "idea";
                case "PyCharmCore" -> "Python";
                default -> this.platformPrefix;
            };
        }

        public final boolean isSet(int flagMask) {
            return (this.flags & flagMask) != 0;
        }

        @NotNull
        public final String toExternalForm() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.toStream(new DataOutputStream(out));
            byte[] byArray = Base64.getMimeEncoder().encode(out.toByteArray());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return new String(byArray2, charset2);
        }

        private final void toStream(DataOutput out) {
            out.writeInt(this.flags);
            out.writeUTF(this.platformPrefix);
            out.writeUTF(this.name);
            out.writeInt(Companion.encodeDate$intellij_platform_split_connection(this.releaseDate));
            out.writeInt(this.releaseVersion);
            out.writeInt(this.plugins.size());
            for (PluginInfo pluginInfo : this.plugins) {
                pluginInfo.toStream$intellij_platform_split_connection(out);
            }
            out.writeUTF(this.hostStamp);
        }

        @NotNull
        public final String component1() {
            return this.platformPrefix;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final Date component3() {
            return this.releaseDate;
        }

        public final int component4() {
            return this.releaseVersion;
        }

        @NotNull
        public final List<PluginInfo> component5() {
            return this.plugins;
        }

        public final int component6() {
            return this.flags;
        }

        @NotNull
        public final String component7() {
            return this.hostStamp;
        }

        @NotNull
        public final ProductInfo copy(@NotNull String platformPrefix, @NotNull String name, @Nullable Date releaseDate, int releaseVersion, @NotNull List<PluginInfo> plugins, int flags, @NotNull String hostStamp) {
            Intrinsics.checkNotNullParameter((Object)platformPrefix, (String)"platformPrefix");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
            Intrinsics.checkNotNullParameter((Object)hostStamp, (String)"hostStamp");
            return new ProductInfo(platformPrefix, name, releaseDate, releaseVersion, plugins, flags, hostStamp);
        }

        public static /* synthetic */ ProductInfo copy$default(ProductInfo productInfo, String string, String string2, Date date, int n, List list, int n2, String string3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = productInfo.platformPrefix;
            }
            if ((n3 & 2) != 0) {
                string2 = productInfo.name;
            }
            if ((n3 & 4) != 0) {
                date = productInfo.releaseDate;
            }
            if ((n3 & 8) != 0) {
                n = productInfo.releaseVersion;
            }
            if ((n3 & 0x10) != 0) {
                list = productInfo.plugins;
            }
            if ((n3 & 0x20) != 0) {
                n2 = productInfo.flags;
            }
            if ((n3 & 0x40) != 0) {
                string3 = productInfo.hostStamp;
            }
            return productInfo.copy(string, string2, date, n, list, n2, string3);
        }

        @NotNull
        public String toString() {
            return "ProductInfo(platformPrefix=" + this.platformPrefix + ", name=" + this.name + ", releaseDate=" + this.releaseDate + ", releaseVersion=" + this.releaseVersion + ", plugins=" + this.plugins + ", flags=" + this.flags + ", hostStamp=" + this.hostStamp + ")";
        }

        public int hashCode() {
            int result = this.platformPrefix.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
            result = result * 31 + Integer.hashCode(this.releaseVersion);
            result = result * 31 + ((Object)this.plugins).hashCode();
            result = result * 31 + Integer.hashCode(this.flags);
            result = result * 31 + this.hostStamp.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProductInfo)) {
                return false;
            }
            ProductInfo productInfo = (ProductInfo)other;
            if (!Intrinsics.areEqual((Object)this.platformPrefix, (Object)productInfo.platformPrefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)productInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.releaseDate, (Object)productInfo.releaseDate)) {
                return false;
            }
            if (this.releaseVersion != productInfo.releaseVersion) {
                return false;
            }
            if (!Intrinsics.areEqual(this.plugins, productInfo.plugins)) {
                return false;
            }
            if (this.flags != productInfo.flags) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hostStamp, (Object)productInfo.hostStamp);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo$Companion;", "", "<init>", "()V", "FLAG_UNATTENDED_MODE", "", "getDateEncodeFormat", "Ljava/text/SimpleDateFormat;", "fromStream", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;", "input", "Ljava/io/DataInput;", "encodeDate", "date", "Ljava/util/Date;", "encodeDate$intellij_platform_split_connection", "decodeDate", "encoded", "decodeDate$intellij_platform_split_connection", "fromExternalForm", "data", "", "intellij.platform.split.connection"})
        public static final class Companion {
            private Companion() {
            }

            private final SimpleDateFormat getDateEncodeFormat() {
                return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            }

            private final ProductInfo fromStream(DataInput input) {
                String string;
                int flags = input.readInt();
                String platformPrefix = input.readUTF();
                String name = input.readUTF();
                Date releaseDate = this.decodeDate$intellij_platform_split_connection(input.readInt());
                int releaseVersion = input.readInt();
                int count = input.readInt();
                ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
                while (count-- > 0) {
                    plugins.add(PluginInfo.Companion.fromStream$intellij_platform_split_connection(input));
                }
                try {
                    string = input.readUTF();
                }
                catch (Throwable e) {
                    string = "";
                }
                String hostStamp = string;
                Intrinsics.checkNotNull((Object)platformPrefix);
                Intrinsics.checkNotNull((Object)name);
                List list = plugins;
                Intrinsics.checkNotNull((Object)hostStamp);
                return new ProductInfo(platformPrefix, name, releaseDate, releaseVersion, list, flags, hostStamp);
            }

            public final int encodeDate$intellij_platform_split_connection(@Nullable Date date) {
                int n;
                if (date != null) {
                    Integer n2 = Integer.valueOf(this.getDateEncodeFormat().format(date));
                    Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(...)");
                    n = ((Number)n2).intValue();
                } else {
                    n = -1;
                }
                return n;
            }

            @Nullable
            public final Date decodeDate$intellij_platform_split_connection(int encoded) {
                return encoded >= 0 ? this.getDateEncodeFormat().parse(String.valueOf(encoded)) : null;
            }

            @Nullable
            public final ProductInfo fromExternalForm(@NotNull String data) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                try {
                    Base64.Decoder decoder = Base64.getMimeDecoder();
                    object = data;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = ((String)object).getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = this.fromStream(new DataInputStream(new ByteArrayInputStream(decoder.decode(byArray))));
                }
                catch (Throwable e) {
                    object = null;
                }
                return object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$SelfSignedCertificateData;", "", "certificate", "Ljava/security/cert/X509Certificate;", "fingerprint", "", "keyStore", "Ljava/security/KeyStore;", "keyEntryAlias", "keyPassword", "", "productInfo", "Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;", "<init>", "(Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/security/KeyStore;Ljava/lang/String;[CLcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;)V", "getCertificate", "()Ljava/security/cert/X509Certificate;", "getFingerprint", "()Ljava/lang/String;", "getKeyStore", "()Ljava/security/KeyStore;", "getKeyEntryAlias", "getKeyPassword", "()[C", "getProductInfo", "()Lcom/intellij/platform/split/connection/impl/SelfSignedCertificate$ProductInfo;", "intellij.platform.split.connection"})
    public static final class SelfSignedCertificateData {
        @NotNull
        private final X509Certificate certificate;
        @NotNull
        private final String fingerprint;
        @NotNull
        private final KeyStore keyStore;
        @NotNull
        private final String keyEntryAlias;
        @NotNull
        private final char[] keyPassword;
        @Nullable
        private final ProductInfo productInfo;

        public SelfSignedCertificateData(@NotNull X509Certificate certificate, @NotNull String fingerprint, @NotNull KeyStore keyStore, @NotNull String keyEntryAlias, @NotNull char[] keyPassword, @Nullable ProductInfo productInfo) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
            Intrinsics.checkNotNullParameter((Object)keyEntryAlias, (String)"keyEntryAlias");
            Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
            this.certificate = certificate;
            this.fingerprint = fingerprint;
            this.keyStore = keyStore;
            this.keyEntryAlias = keyEntryAlias;
            this.keyPassword = keyPassword;
            this.productInfo = productInfo;
        }

        @NotNull
        public final X509Certificate getCertificate() {
            return this.certificate;
        }

        @NotNull
        public final String getFingerprint() {
            return this.fingerprint;
        }

        @NotNull
        public final KeyStore getKeyStore() {
            return this.keyStore;
        }

        @NotNull
        public final String getKeyEntryAlias() {
            return this.keyEntryAlias;
        }

        @NotNull
        public final char[] getKeyPassword() {
            return this.keyPassword;
        }

        @Nullable
        public final ProductInfo getProductInfo() {
            return this.productInfo;
        }
    }
}

