/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.quic.QuicStreamTransportKt;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicStreamTransport;", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "<init>", "()V", "receivedQueue", "Ljava/util/concurrent/BlockingDeque;", "", "getReceivedQueue", "()Ljava/util/concurrent/BlockingDeque;", "toSendQueue", "getToSendQueue", "wakeupQueue", "", "getWakeupQueue", "myQuicChannel", "Ljava/nio/channels/ByteChannel;", "byteChannel", "getByteChannel", "()Ljava/nio/channels/ByteChannel;", "intellij.platform.split.connection"})
public abstract class QuicStreamTransport
implements StreamTransport {
    @NotNull
    private final ByteChannel myQuicChannel;
    @NotNull
    private final ByteChannel byteChannel;

    public QuicStreamTransport() {
        this.byteChannel = this.myQuicChannel = (ByteChannel)new ByteChannel(this){
            final /* synthetic */ QuicStreamTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isOpen() {
                return Intrinsics.areEqual((Object)this.this$0.getConnected().getValue(), (Object)ConnectionState.CONNECTED.INSTANCE);
            }

            public long write(ByteBuffer[] srcs, int offset, int length) {
                Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
                long totalBytes = 0L;
                int n = offset + length;
                for (int i = offset; i < n; ++i) {
                    if (!((Buffer)srcs[i]).hasRemaining()) continue;
                    totalBytes += (long)this.write(srcs[i]);
                }
                return totalBytes;
            }

            public long write(ByteBuffer[] srcs) {
                Intrinsics.checkNotNullParameter((Object)srcs, (String)"srcs");
                return this.write(srcs, 0, srcs.length);
            }

            public int write(ByteBuffer src) {
                Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                byte[] arr = new byte[src.remaining()];
                src.get(arr);
                this.this$0.getToSendQueue().add(arr);
                this.this$0.getWakeupQueue().add(true);
                return arr.length;
            }

            public void close() {
            }

            /*
             * WARNING - void declaration
             */
            public int read(ByteBuffer dst) {
                Object buffer;
                void var6_6;
                void $this$trace$iv;
                Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                Logger logger = QuicStreamTransportKt.access$getLOG$p();
                QuicStreamTransport quicStreamTransport = this.this$0;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var6_6 = $this$trace$iv;
                    boolean bl = false;
                    var6_6.trace(quicStreamTransport.getName() + " Going to read. connected state: " + quicStreamTransport.getConnected().getValue());
                }
                while (ConnectionState.Companion.isConnected((ConnectionState)this.this$0.getConnected().getValue())) {
                    int n;
                    buffer = this.this$0.getReceivedQueue().poll(500L, TimeUnit.MILLISECONDS);
                    if (buffer == null) continue;
                    int available = dst.remaining();
                    if (available >= ((Logger)buffer).length) {
                        dst.put((byte[])buffer);
                        n = ((Logger)buffer).length;
                    } else {
                        dst.put(ArraysKt.sliceArray((byte[])buffer, (IntRange)RangesKt.until((int)0, (int)available)));
                        this.this$0.getReceivedQueue().addFirst(ArraysKt.sliceArray((byte[])buffer, (IntRange)RangesKt.until((int)available, (int)((Logger)buffer).length)));
                        n = available;
                    }
                    return n;
                }
                buffer = QuicStreamTransportKt.access$getLOG$p();
                quicStreamTransport = this.this$0;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var6_6 = $this$trace$iv;
                    boolean bl = false;
                    var6_6.trace(quicStreamTransport.getName() + " Finished reading. connected state: " + quicStreamTransport.getConnected().getValue());
                }
                return -1;
            }
        };
    }

    @NotNull
    protected abstract BlockingDeque<byte[]> getReceivedQueue();

    @NotNull
    protected abstract BlockingDeque<byte[]> getToSendQueue();

    @NotNull
    protected abstract BlockingDeque<Boolean> getWakeupQueue();

    @Override
    @NotNull
    public ByteChannel getByteChannel() {
        return this.byteChannel;
    }
}

