/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.wire;

import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.transport.stats.TransportStatisticsData;
import com.intellij.platform.split.connection.protocol.wire.WireStatsCounter;
import com.intellij.platform.split.connection.protocol.wire.WireStatsMode;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.base.IRdWireable;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.protocol.DelegatedRdWireable;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0019\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\r2\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b(\u0010&J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0*H\u0016\u00a2\u0006\u0002\u0010+J\u0019\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00105\u001a\u00020!2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0004\b6\u00104J\u0018\u00107\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u000bH\u0016J\u0019\u00109\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b:\u0010&J\u0014\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\b\u0010?\u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006@"}, d2={"Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounterImpl;", "Lcom/intellij/platform/split/connection/protocol/wire/WireStatsCounter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wire", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;)V", "rdidToEntity", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/rd/framework/RdId;", "Lcom/jetbrains/rd/framework/base/IRdWireable;", "myTotalStats", "Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "value", "Lcom/intellij/platform/split/connection/protocol/wire/WireStatsMode;", "myStatsMode", "setMyStatsMode", "(Lcom/intellij/platform/split/connection/protocol/wire/WireStatsMode;)V", "perEntityStats", "storedNames", "", "cumulativeEntities", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Ljava/util/Optional;", "totalStats", "getTotalStats", "()Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "statsMode", "getStatsMode", "()Lcom/intellij/platform/split/connection/protocol/wire/WireStatsMode;", "setStatsMode", "", "mode", "getEntityStats", "rdId", "getEntityStats-s1GeQ58", "(J)Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "addCumulativeEntity", "addCumulativeEntity-s1GeQ58", "getStoredIds", "", "()[Lcom/jetbrains/rd/framework/RdId;", "getStoredName", "getStoredName-s1GeQ58", "(J)Ljava/lang/String;", "onSend", "id", "numBytes", "", "onSend-311-pGg", "(JJ)V", "onReceive", "onReceive-311-pGg", "onAdvise", "entity", "findCumulativeParentStats", "findCumulativeParentStats-s1GeQ58", "getBindable", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "dyn", "Lcom/jetbrains/rd/framework/IRdDynamic;", "updateMomentarySpeeds", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nWireStatsCounterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStatsCounterImpl.kt\ncom/intellij/platform/split/connection/protocol/wire/WireStatsCounterImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n221#2,2:165\n221#2,2:182\n540#3:167\n525#3,6:168\n37#4,2:174\n72#5,2:176\n72#5,2:179\n1#6:178\n1#6:181\n1#6:195\n1642#7,10:184\n1915#7:194\n1916#7:196\n1652#7:197\n1915#7,2:198\n*S KotlinDebug\n*F\n+ 1 WireStatsCounterImpl.kt\ncom/intellij/platform/split/connection/protocol/wire/WireStatsCounterImpl\n*L\n35#1:165,2\n156#1:182,2\n75#1:167\n75#1:168,6\n82#1:174,2\n94#1:176,2\n103#1:179,2\n94#1:178\n103#1:181\n159#1:195\n159#1:184,10\n159#1:194\n159#1:196\n159#1:197\n159#1:198,2\n*E\n"})
public final class WireStatsCounterImpl
implements WireStatsCounter {
    @NotNull
    private final ICodeWithMeWire wire;
    @NotNull
    private final ConcurrentHashMap<RdId, IRdWireable> rdidToEntity;
    @NotNull
    private final TransportStatisticsData myTotalStats;
    @NotNull
    private WireStatsMode myStatsMode;
    @NotNull
    private final ConcurrentHashMap<RdId, TransportStatisticsData> perEntityStats;
    @NotNull
    private final ConcurrentHashMap<RdId, String> storedNames;
    @NotNull
    private AtomicReference<Map<RdId, Optional<TransportStatisticsData>>> cumulativeEntities;

    public WireStatsCounterImpl(@NotNull Lifetime lifetime, @NotNull ICodeWithMeWire wire) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)wire, (String)"wire");
        this.wire = wire;
        this.rdidToEntity = new ConcurrentHashMap();
        this.myTotalStats = new TransportStatisticsData();
        this.myStatsMode = SystemProperties.getBooleanProperty((String)"rdct.wire.stats.full", (boolean)false) ? WireStatsMode.PerEntity : WireStatsMode.Simple;
        this.perEntityStats = new ConcurrentHashMap();
        this.storedNames = new ConcurrentHashMap();
        this.cumulativeEntities = new AtomicReference<Map>(MapsKt.emptyMap());
        ScheduledFuture<?> task = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::updateMomentarySpeeds, 0L, 1L, TimeUnit.SECONDS);
        lifetime.onTermination(() -> WireStatsCounterImpl._init_$lambda$0(task));
    }

    private final void setMyStatsMode(WireStatsMode value) {
        if (this.myStatsMode == value) {
            return;
        }
        this.myStatsMode = value;
        this.perEntityStats.clear();
        this.cumulativeEntities.set(MapsKt.emptyMap());
        this.storedNames.clear();
        if (value == WireStatsMode.PerEntity) {
            Map $this$forEach$iv = this.rdidToEntity;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                long rdid = ((RdId)entry.getKey()).unbox-impl();
                IRdWireable wireable = (IRdWireable)entry.getValue();
                ((Map)this.storedNames).put(RdId.box-impl((long)rdid), wireable.getLocation().toString());
            }
        }
    }

    @Override
    @NotNull
    public TransportStatisticsData getTotalStats() {
        return this.myTotalStats;
    }

    @Override
    @NotNull
    public WireStatsMode getStatsMode() {
        return this.myStatsMode;
    }

    @Override
    public void setStatsMode(@NotNull WireStatsMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.setMyStatsMode(mode);
    }

    @Override
    @Nullable
    public TransportStatisticsData getEntityStats-s1GeQ58(long rdId) {
        return this.perEntityStats.get(RdId.box-impl((long)rdId));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TransportStatisticsData addCumulativeEntity-s1GeQ58(long rdId) {
        Map destination$iv$iv;
        Map newEntries;
        Map<RdId, Optional<TransportStatisticsData>> entries;
        TransportStatisticsData data = new TransportStatisticsData();
        do {
            void $this$filterTo$iv$iv;
            entries = this.cumulativeEntities.get();
            Intrinsics.checkNotNull(entries);
            Map<RdId, Optional<TransportStatisticsData>> $this$filter$iv = entries;
            boolean $i$f$filter = false;
            Map<RdId, Optional<TransportStatisticsData>> map = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!((Optional)it.getValue()).isPresent()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
        } while (!this.cumulativeEntities.compareAndSet(entries, newEntries = MapsKt.plus((Map)destination$iv$iv, (Pair)new Pair((Object)RdId.box-impl((long)rdId), Optional.of(data)))));
        return data;
    }

    @Override
    @NotNull
    public RdId[] getStoredIds() {
        Set set = this.perEntityStats.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RdId[0]);
    }

    @Override
    @Nullable
    public String getStoredName-s1GeQ58(long rdId) {
        return this.storedNames.get(RdId.box-impl((long)rdId));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSend-311-pGg(long id, long numBytes) {
        block3: {
            void $this$getOrPut$iv;
            this.getTotalStats().logSend(numBytes);
            if (this.getStatsMode() == WireStatsMode.Simple) {
                return;
            }
            ConcurrentMap concurrentMap = this.perEntityStats;
            RdId key$iv = RdId.box-impl((long)id);
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                TransportStatisticsData default$iv = new TransportStatisticsData();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((TransportStatisticsData)object).logSend(numBytes);
            TransportStatisticsData transportStatisticsData = this.findCumulativeParentStats-s1GeQ58(id);
            if (transportStatisticsData == null) break block3;
            transportStatisticsData.logSend(numBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onReceive-311-pGg(long id, long numBytes) {
        block3: {
            void $this$getOrPut$iv;
            this.getTotalStats().logReceive(numBytes);
            if (this.getStatsMode() == WireStatsMode.Simple) {
                return;
            }
            ConcurrentMap concurrentMap = this.perEntityStats;
            RdId key$iv = RdId.box-impl((long)id);
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                TransportStatisticsData default$iv = new TransportStatisticsData();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((TransportStatisticsData)object).logReceive(numBytes);
            TransportStatisticsData transportStatisticsData = this.findCumulativeParentStats-s1GeQ58(id);
            if (transportStatisticsData == null) break block3;
            transportStatisticsData.logReceive(numBytes);
        }
    }

    @Override
    public void onAdvise(@NotNull Lifetime lifetime, @NotNull IRdWireable entity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!RLifetimeKt.isAlive((Lifetime)lifetime)) {
            return;
        }
        long rdid = entity.getRdid-yyTGXKE();
        ((Map)this.rdidToEntity).put(RdId.box-impl((long)rdid), entity);
        lifetime.onTermination(() -> WireStatsCounterImpl.onAdvise$lambda$0(this, rdid));
        if (this.getStatsMode() == WireStatsMode.Simple) {
            return;
        }
        ((Map)this.storedNames).put(RdId.box-impl((long)rdid), entity.getLocation().toString());
    }

    private final TransportStatisticsData findCumulativeParentStats-s1GeQ58(long rdId) {
        Map<RdId, Optional<TransportStatisticsData>> entries = this.cumulativeEntities.get();
        Optional<TransportStatisticsData> cached = entries.get(RdId.box-impl((long)rdId));
        if (cached != null) {
            return cached.orElse(null);
        }
        RdBindableBase cur = this.getBindable((IRdDynamic)this.wire.tryGetById-s1GeQ58(rdId));
        while (cur != null) {
            Optional<TransportStatisticsData> data = entries.get(RdId.box-impl((long)cur.getRdid-yyTGXKE()));
            if (data != null) {
                Intrinsics.checkNotNull(entries);
                Map newEntries = MapsKt.plus(entries, (Pair)new Pair((Object)RdId.box-impl((long)rdId), data));
                if (this.cumulativeEntities.compareAndSet(entries, newEntries)) {
                    return data.orElse(null);
                }
                return this.findCumulativeParentStats-s1GeQ58(rdId);
            }
            cur = this.getBindable(cur.getParent());
        }
        Intrinsics.checkNotNull(entries);
        Map newEntries = MapsKt.plus(entries, (Pair)new Pair((Object)RdId.box-impl((long)rdId), Optional.empty()));
        this.cumulativeEntities.compareAndSet(entries, newEntries);
        return null;
    }

    private final RdBindableBase getBindable(IRdDynamic dyn) {
        if (dyn instanceof DelegatedRdWireable) {
            IRdWireable iRdWireable = ((DelegatedRdWireable)dyn).getDelegate();
            return iRdWireable instanceof RdBindableBase ? (RdBindableBase)iRdWireable : null;
        }
        return dyn instanceof RdBindableBase ? (RdBindableBase)dyn : null;
    }

    private final void updateMomentarySpeeds() {
        this.getTotalStats().updateSpeeds();
        Map $this$forEach$iv = this.perEntityStats;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl = false;
            TransportStatisticsData stats = (TransportStatisticsData)entry2.getValue();
            stats.updateSpeeds();
        }
        Map<RdId, Optional<TransportStatisticsData>> entries = this.cumulativeEntities.get();
        Iterable $this$mapNotNull$iv = entries.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TransportStatisticsData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Optional it = (Optional)element$iv$iv;
            boolean bl2 = false;
            if ((TransportStatisticsData)OptionalsKt.getOrNull((Optional)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            TransportStatisticsData it = (TransportStatisticsData)element$iv3;
            boolean bl = false;
            it.updateSpeeds();
        }
    }

    private static final Unit _init_$lambda$0(ScheduledFuture $task) {
        $task.cancel(false);
        return Unit.INSTANCE;
    }

    private static final Unit onAdvise$lambda$0(WireStatsCounterImpl this$0, long $rdid) {
        this$0.rdidToEntity.remove(RdId.box-impl((long)$rdid));
        return Unit.INSTANCE;
    }
}

