/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.diff;

import com.intellij.flyway.core.util.FlywayConfig;
import com.intellij.flyway.core.util.FlywayState;
import com.intellij.flyway.core.util.MigrationVersion;
import com.intellij.flyway.core.util.ResourceName;
import com.intellij.flyway.core.util.ResourceNameParser;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfiguration;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfigurationKt;
import com.intellij.jpa.jpb.model.core.es.BuildVersion;
import com.intellij.jpa.jpb.model.core.es.ExternalSystemInfo;
import com.intellij.jpa.jpb.model.core.util.JpbVfsUtil;
import com.intellij.jpa.jpb.model.properties.PropertySource;
import com.intellij.jpa.jpb.model.properties.SpringProperty;
import com.intellij.jpa.jpb.model.util.SCollectionUtilKt;
import com.intellij.liquibase.orm.FormatterTemplate;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ \u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u0015H\u0002J\u0006\u0010\u001d\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/flyway/diff/FlywayDiffHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dbMigrationState", "Lcom/intellij/flyway/core/util/FlywayState;", "createMigrationFile", "Lcom/intellij/psi/PsiFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "fileName", "", "source", "generateVersionedName", "existScriptNames", "", "module", "Lcom/intellij/openapi/module/Module;", "generateChangelogDirPath", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateFlywayDir", "findSourceRootsForChangelog", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFirstFlywayLocation", "findFlywayLocationInPropertySources", "allPropertySources", "", "Lcom/intellij/jpa/jpb/model/properties/PropertySource;", "findAllVersionedMigrationNames", "Lcom/intellij/flyway/core/util/ResourceName;", "Companion", "FlywayFormatterTemplate", "intellij.flyway.diff"})
@SourceDebugExtension(value={"SMAP\nFlywayDiffHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n37#2,2:249\n1#3:251\n1#3:263\n1642#4,10:252\n1915#4:262\n1916#4:264\n1652#4:265\n777#4:266\n873#4,2:267\n*S KotlinDebug\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper\n*L\n103#1:249,2\n148#1:263\n148#1:252,10\n148#1:262\n148#1:264\n148#1:265\n168#1:266\n168#1:267,2\n*E\n"})
public final class FlywayDiffHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final FlywayState dbMigrationState;
    @NotNull
    public static final String SEMANTIC_VERSION_VAR_NAME = "semVer";
    @NotNull
    private static final String FLYWAY_LOCATION_PROP = "flyway.locations";
    @NotNull
    private static final String SPRING_FLYWAY_LOCATION_PROP = "spring.flyway.locations";
    @NotNull
    private static final String CLASSPATH_PREFIX = "classpath:";
    @NotNull
    private static final String DEFAULT_FLYWAY_LOCATION = "db/migration";

    public FlywayDiffHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dbMigrationState = FlywayConfig.Companion.getInstance(this.project).getState();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PsiFile createMigrationFile(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull String source) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("MIGRATION_SOURCE", source);
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate("com.intellij.jpb.FlywayMigrationScript.sql");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)directory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create flyway SQL migration file: '" + fileName + "'"), (Throwable)e).post(this.project);
            psiFile = null;
        }
        return psiFile;
    }

    public static /* synthetic */ PsiFile createMigrationFile$default(FlywayDiffHelper flywayDiffHelper, PsiDirectory psiDirectory, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return flywayDiffHelper.createMigrationFile(psiDirectory, string, string2);
    }

    @NotNull
    public final String generateVersionedName(@NotNull Collection<String> existScriptNames, @Nullable Module module) {
        Map map;
        String versionPattern;
        Intrinsics.checkNotNullParameter(existScriptNames, (String)"existScriptNames");
        String string = this.dbMigrationState.getFlywayVersionPattern();
        if (string == null) {
            string = "1";
        }
        if (StringsKt.contains$default((CharSequence)(versionPattern = string), (CharSequence)"${semVer", (boolean)false, (int)2, null)) {
            BuildVersion buildVersion = ExternalSystemInfo.Companion.findBuildVersion(this.project);
            if (buildVersion == null) {
                buildVersion = new BuildVersion("0.0.1", 0, 0, 1, null, null, 48, null);
            }
            BuildVersion buildVersion2 = buildVersion;
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEMANTIC_VERSION_VAR_NAME, (Object)buildVersion2));
        } else {
            map = MapsKt.emptyMap();
        }
        Map attributes = map;
        String string2 = this.dbMigrationState.getFlywayMigrationPrefixNN();
        String string3 = this.dbMigrationState.getFlywayMigrationSeparatorNN();
        String string4 = this.dbMigrationState.getFlywayMigrationDescription();
        if (string4 == null) {
            string4 = "";
        }
        String migrationNamePattern = string2 + versionPattern + string3 + string4;
        return new FlywayFormatterTemplate(module, migrationNamePattern, attributes, existScriptNames).run();
    }

    public static /* synthetic */ String generateVersionedName$default(FlywayDiffHelper flywayDiffHelper, Collection collection, Module module, int n, Object object) {
        if ((n & 2) != 0) {
            module = null;
        }
        return flywayDiffHelper.generateVersionedName(collection, module);
    }

    @NotNull
    public final String generateChangelogDirPath(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Module module = (Module)event.getData(PlatformDataKeys.MODULE);
        if (module == null) {
            return this.generateFlywayDir();
        }
        Module module2 = module;
        return this.generateFlywayDir(module2);
    }

    @NotNull
    public final String generateFlywayDir() {
        List sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object)JavaResourceRootType.RESOURCE));
        if (sourceRoots.isEmpty()) {
            Set set = JavaModuleSourceRootTypes.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SOURCES");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaSourceRootType[] javaSourceRootTypeArray = thisCollection$iv.toArray(new JavaSourceRootType[0]);
            sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object[])Arrays.copyOf(javaSourceRootTypeArray, javaSourceRootTypeArray.length)));
        }
        String flywayLocation = this.getFirstFlywayLocation();
        if (sourceRoots.isEmpty()) {
            return flywayLocation;
        }
        return ((VirtualFile)sourceRoots.get(0)).getPath() + "/" + flywayLocation;
    }

    @NotNull
    public final String generateFlywayDir(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List<VirtualFile> sourceRoots = this.findSourceRootsForChangelog(module);
        if (sourceRoots.isEmpty()) {
            return this.getFirstFlywayLocation(module);
        }
        return ((VirtualFile)CollectionsKt.first(sourceRoots)).getPath() + "/" + this.getFirstFlywayLocation(module);
    }

    private final List<VirtualFile> findSourceRootsForChangelog(Module $this$findSourceRootsForChangelog) {
        List list;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)$this$findSourceRootsForChangelog);
        List it = list = rootManager.getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            List list3 = rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSourceRoots(...)");
        }
        return list2;
    }

    @NotNull
    public final String getFirstFlywayLocation() {
        List allPropertySources = SpringPropertiesConfiguration.Companion.getInstance(this.project).loadAllPropertySources();
        String string = this.findFlywayLocationInPropertySources(allPropertySources);
        if (string == null) {
            string = DEFAULT_FLYWAY_LOCATION;
        }
        return string;
    }

    private final String getFirstFlywayLocation(Module module) {
        List propertySources = SpringPropertiesConfigurationKt.loadPropertySourcesFromModule$default((SpringPropertiesConfiguration)SpringPropertiesConfiguration.Companion.getInstance(this.project), (Module)module, (boolean)false, (int)2, null);
        String string = this.findFlywayLocationInPropertySources(propertySources);
        if (string == null) {
            string = DEFAULT_FLYWAY_LOCATION;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String findFlywayLocationInPropertySources(List<? extends PropertySource> allPropertySources) {
        for (PropertySource propertySource : allPropertySources) {
            String string;
            void $this$mapNotNullTo$iv$iv;
            SpringProperty flywayLocationProp = propertySource.findProperty(FLYWAY_LOCATION_PROP);
            if (flywayLocationProp == null) {
                flywayLocationProp = propertySource.findProperty(SPRING_FLYWAY_LOCATION_PROP);
            }
            if (flywayLocationProp == null) continue;
            String[] stringArray = new String[]{","};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)flywayLocationProp.getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                String trimmedValue = ((Object)StringsKt.trim((CharSequence)it)).toString();
                if ((StringsKt.startsWith$default((String)trimmedValue, (String)CLASSPATH_PREFIX, (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)trimmedValue, (String)CLASSPATH_PREFIX, null, (int)2, null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            String string2 = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (string2 == null) continue;
            String firstClasspath = string2;
            if (StringsKt.startsWith$default((String)firstClasspath, (String)"/", (boolean)false, (int)2, null)) {
                String string3 = firstClasspath.substring(1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = firstClasspath;
            }
            return string;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final Collection<ResourceName> findAllVersionedMigrationNames(@Nullable Module module) {
        block8: {
            block7: {
                v0 = module;
                if (v0 == null) ** GOTO lbl-1000
                it = v0;
                $i$a$-let-FlywayDiffHelper$findAllVersionedMigrationNames$fileIndex$1 = false;
                v1 = ModuleRootManager.getInstance((Module)it).getFileIndex();
                v0 = v1;
                if (v1 != null) {
                    v2 = (FileIndex)v0;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = ProjectFileIndex.getInstance((Project)this.project);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                    v2 = fileIndex = (FileIndex)v3;
                }
                if ((v4 /* !! */  = module) == null) break block7;
                it = v4 /* !! */ ;
                $i$a$-let-FlywayDiffHelper$findAllVersionedMigrationNames$sourceRoots$1 = false;
                var9_10 = new JpsElementType[]{JavaSourceRootType.SOURCE, JavaResourceRootType.RESOURCE};
                v5 = JpbVfsUtil.getModuleSourceRoots((Module)it, (Set)SetsKt.setOf((Object[])var9_10));
                v4 /* !! */  = v5;
                if (v5 != null) break block8;
            }
            v4 /* !! */  = JpbVfsUtil.getAllSourceRoots((Project)this.project, (boolean)true);
        }
        var4_11 /* !! */  = v4 /* !! */ ;
        Intrinsics.checkNotNull((Object)var4_11 /* !! */ );
        var4_11 /* !! */  = (Iterable)var4_11 /* !! */ ;
        $i$f$filter = false;
        $i$a$-let-FlywayDiffHelper$findAllVersionedMigrationNames$fileIndex$1 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-FlywayDiffHelper$findAllVersionedMigrationNames$sourceRoots$2 = false;
            if (!(fileIndex.isInTestSourceContent(it) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        sourceRoots = (List)destination$iv$iv;
        result = new LinkedHashSet<ResourceName>();
        for (VirtualFile sourceRoot : sourceRoots) {
            var7_8 = new VirtualFileVisitor.Option[]{};
            VfsUtil.visitChildrenRecursively((VirtualFile)sourceRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, result, var7_8){
                final /* synthetic */ FlywayDiffHelper this$0;
                final /* synthetic */ LinkedHashSet<ResourceName> $result;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                    ResourceName resourceName;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isDirectory() && (resourceName = ResourceNameParser.parse((Project)this.this$0.getProject(), (String)file.getName())) != null) {
                        this.$result.add(resourceName);
                    }
                    VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"CONTINUE");
                    return result;
                }
            }));
        }
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/flyway/diff/FlywayDiffHelper$Companion;", "", "<init>", "()V", "SEMANTIC_VERSION_VAR_NAME", "", "FLYWAY_LOCATION_PROP", "SPRING_FLYWAY_LOCATION_PROP", "CLASSPATH_PREFIX", "DEFAULT_FLYWAY_LOCATION", "getInstance", "Lcom/intellij/flyway/diff/FlywayDiffHelper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.flyway.diff"})
    @SourceDebugExtension(value={"SMAP\nFlywayDiffHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,248:1\n30#2,2:249\n*S KotlinDebug\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper$Companion\n*L\n52#1:249,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlywayDiffHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FlywayDiffHelper> serviceClass$iv = FlywayDiffHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FlywayDiffHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/flyway/diff/FlywayDiffHelper$FlywayFormatterTemplate;", "Lcom/intellij/liquibase/orm/FormatterTemplate;", "module", "Lcom/intellij/openapi/module/Module;", "content", "", "attributes", "", "", "existScriptNames", "", "<init>", "(Lcom/intellij/flyway/diff/FlywayDiffHelper;Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/util/Map;Ljava/util/Collection;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "processIncrementPattern", "completeName", "templateFormatter", "Lcom/intellij/liquibase/orm/FormatterTemplate$TemplateFormatter;", "completePatternIncrementVersion", "Ljava/util/regex/Pattern;", "name", "intellij.flyway.diff"})
    @SourceDebugExtension(value={"SMAP\nFlywayDiffHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper$FlywayFormatterTemplate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1586#2:249\n1661#2,3:250\n1642#2,10:253\n1915#2:263\n1916#2:265\n1652#2:266\n1080#2:267\n1#3:264\n*S KotlinDebug\n*F\n+ 1 FlywayDiffHelper.kt\ncom/intellij/flyway/diff/FlywayDiffHelper$FlywayFormatterTemplate\n*L\n203#1:249\n203#1:250,3\n203#1:253,10\n203#1:263\n203#1:265\n203#1:266\n206#1:267\n203#1:264\n*E\n"})
    public final class FlywayFormatterTemplate
    extends FormatterTemplate {
        @Nullable
        private final Module module;
        @NotNull
        private final Collection<String> existScriptNames;

        public FlywayFormatterTemplate(@NotNull Module module, @NotNull String content, @NotNull Map<String, ? extends Object> attributes, Collection<String> existScriptNames) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(existScriptNames, (String)"existScriptNames");
            super(content, attributes, null, null, 12, null);
            this.module = module;
            this.existScriptNames = existScriptNames;
        }

        @Nullable
        public final Module getModule() {
            return this.module;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String processIncrementPattern(@NotNull String completeName, @NotNull FormatterTemplate.TemplateFormatter templateFormatter) {
            void $this$sortedByDescending$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)completeName, (String)"completeName");
            Intrinsics.checkNotNullParameter((Object)templateFormatter, (String)"templateFormatter");
            if (!StringsKt.contains$default((CharSequence)completeName, (CharSequence)"$INCREMENT_LOCATION$", (boolean)false, (int)2, null)) {
                return completeName;
            }
            double incrementValue = templateFormatter.getIncrementStart().doubleValue();
            String processedFileName = this.replaceIncrementValue(completeName, incrementValue, templateFormatter.getIncrementPattern());
            Iterable iterable = this.existScriptNames;
            Collection<ResourceName> collection = FlywayDiffHelper.this.findAllVersionedMigrationNames(this.module);
            boolean $i$f$map22 = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string2 = FileUtilRt.getExtension((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
                collection2.add(StringsKt.isBlank((CharSequence)string2) ? (String)it + "d.sql" : it);
            }
            $this$map$iv = (List)destination$iv$iv;
            FlywayDiffHelper $i$f$map22 = FlywayDiffHelper.this;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ResourceName it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (ResourceNameParser.parse((Project)$i$f$map22.getProject(), (String)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = SCollectionUtilKt.union(collection, (Collection)((List)destination$iv$iv2));
            boolean $i$f$sortedByDescending = false;
            List sortedMigrations = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceName it = (ResourceName)b;
                    boolean bl = false;
                    MigrationVersion migrationVersion = it.getVersion();
                    if (migrationVersion == null) {
                        migrationVersion = MigrationVersion.EMPTY;
                    }
                    it = (ResourceName)a;
                    Comparable comparable = (Comparable)migrationVersion;
                    bl = false;
                    MigrationVersion migrationVersion2 = it.getVersion();
                    if (migrationVersion2 == null) {
                        migrationVersion2 = MigrationVersion.EMPTY;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)migrationVersion2));
                }
            });
            ResourceName processedResourceName = ResourceNameParser.parse((Project)FlywayDiffHelper.this.getProject(), (String)(processedFileName + "d.sql"));
            ResourceName resourceName = processedResourceName;
            if (resourceName == null || (resourceName = resourceName.getVersion()) == null) {
                return processedFileName;
            }
            ResourceName processedVersion = resourceName;
            Pattern patternIncrementVersion = this.completePatternIncrementVersion(completeName);
            for (ResourceName existMigration : sortedMigrations) {
                MigrationVersion maxVersion;
                if (existMigration.getVersion() == null) {
                    return processedFileName;
                }
                if (maxVersion.compareTo((MigrationVersion)processedVersion) < 0) break;
                Matcher maxMatcher = patternIncrementVersion.matcher(existMigration.getRawResourceName());
                if (!maxMatcher.find() || 1 > maxMatcher.groupCount()) continue;
                String string = maxMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                Double d = StringsKt.toDoubleOrNull((String)string);
                if (d == null) {
                    continue;
                }
                double versionValue = d;
                double incrementBy = templateFormatter.getIncrementBy().doubleValue();
                processedFileName = this.replaceIncrementValue(completeName, versionValue + incrementBy, templateFormatter.getIncrementPattern());
                break;
            }
            return processedFileName;
        }

        private final Pattern completePatternIncrementVersion(String name) {
            String separator;
            Object processedName = ((Object)StringsKt.trim((CharSequence)name)).toString();
            int separatorIdx = StringsKt.indexOf$default((CharSequence)((CharSequence)processedName), (String)(separator = FlywayConfig.Companion.getInstance(FlywayDiffHelper.this.getProject()).getState().getFlywayMigrationSeparatorNN()), (int)0, (boolean)false, (int)6, null);
            if (separatorIdx != -1) {
                String string = ((String)processedName).substring(0, separatorIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                processedName = string + separator;
            }
            String string = StringUtil.escapeToRegexp((String)processedName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeToRegexp(...)");
            String string2 = StringUtil.escapeToRegexp((String)"$INCREMENT_LOCATION$");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeToRegexp(...)");
            Pattern pattern = Pattern.compile("^" + StringsKt.replace$default((String)string, (String)string2, (String)"([0-9]+\\.?[0-9]*?)", (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            return pattern;
        }
    }
}

