/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization.server;

import com.jetbrains.fus.reporting.anonymization.LogAnonymizer;
import com.jetbrains.fus.reporting.anonymization.server.Event;
import com.jetbrains.fus.reporting.anonymization.server.Group;
import com.jetbrains.fus.reporting.anonymization.server.LambdaFieldsToAnonymizeStorage;
import com.jetbrains.fus.reporting.anonymization.server.LogRecord;
import com.jetbrains.fus.reporting.anonymization.server.Recorder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/server/LambdaLogAnonymizer;", "", "fieldsToAnonymizeStorage", "Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage;", "salt", "", "(Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage;[B)V", "anonymizer", "Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer;", "anonymizeEvent", "Lcom/jetbrains/fus/reporting/anonymization/server/Event;", "event", "groupId", "", "recorderId", "anonymizeIds", "", "ids", "anonymizeRecord", "Lcom/jetbrains/fus/reporting/anonymization/server/LogRecord;", "record", "anonymization"})
@SourceDebugExtension(value={"SMAP\nLambdaLogAnonymizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LambdaLogAnonymizer.kt\ncom/jetbrains/fus/reporting/anonymization/server/LambdaLogAnonymizer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n453#2:60\n403#2:61\n1238#3,4:62\n*S KotlinDebug\n*F\n+ 1 LambdaLogAnonymizer.kt\ncom/jetbrains/fus/reporting/anonymization/server/LambdaLogAnonymizer\n*L\n29#1:60\n29#1:61\n29#1:62,4\n*E\n"})
public final class LambdaLogAnonymizer {
    @NotNull
    private final LambdaFieldsToAnonymizeStorage fieldsToAnonymizeStorage;
    @NotNull
    private final LogAnonymizer anonymizer;

    public LambdaLogAnonymizer(@NotNull LambdaFieldsToAnonymizeStorage fieldsToAnonymizeStorage, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)fieldsToAnonymizeStorage, (String)"fieldsToAnonymizeStorage");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.fieldsToAnonymizeStorage = fieldsToAnonymizeStorage;
        this.anonymizer = new LogAnonymizer(salt, LogAnonymizer.Mode.SERVER);
    }

    private final Event anonymizeEvent(Event event, String groupId, String recorderId) {
        Set<String> fieldsToAnonymize = this.fieldsToAnonymizeStorage.getFieldsToAnonymize(groupId, event.getId(), recorderId);
        HashMap anonymizedData = new HashMap();
        for (Map.Entry<String, Object> entry : event.getData().entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            ((Map)anonymizedData).put(field, fieldsToAnonymize.contains(field) ? this.anonymizer.anonymizeValue(field, value, fieldsToAnonymize) : value);
        }
        return new Event(event.getId(), event.getCount(), anonymizedData);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> anonymizeIds(Map<String, String> ids) {
        void $this$mapValuesTo$iv$iv;
        Set<String> skipAnonymizationIds = this.fieldsToAnonymizeStorage.getSkipAnonymizationIds();
        Map<String, String> $this$mapValues$iv = ids;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            String string = skipAnonymizationIds.contains(key) ? value : this.anonymizer.anonymize(value);
            map4.put(k, string);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final LogRecord anonymizeRecord(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Recorder recorder = Recorder.copy$default(record.getRecorder(), null, null, 3, null);
        Event event = this.anonymizeEvent(record.getEvent(), record.getGroup().getId(), record.getRecorder().getId());
        String string2 = record.getCountry();
        String string3 = record.getProduct();
        Boolean bl = record.getInternal();
        long l = record.getTime();
        String string4 = record.getBuild();
        String string5 = record.getBucket();
        Map<String, Object> map2 = record.getClient_data();
        if (record.getSession() == null) {
            string = null;
        } else {
            String string6 = record.getSession();
            Intrinsics.checkNotNull((Object)string6);
            string = this.anonymizer.anonymize(string6);
        }
        String string7 = string;
        Map<String, String> map3 = this.anonymizeIds(record.getIds());
        Group group = Group.copy$default(record.getGroup(), null, null, false, 7, null);
        Object object = record.getSystem_data();
        Object object2 = record.getTrace_data();
        return new LogRecord(recorder, string3, string2, bl, string4, string7, l, map3, event, group, string5, object, map2, object2);
    }
}

