/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtilKt;
import com.intellij.spring.boot.application.yaml.SpringBootYamlImportsKt;
import com.intellij.spring.boot.application.yaml.SpringBootYamlScanner;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootConfigImportStatement;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public final class SpringBootModelApplicationYamlConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationYamlConfigFileContributor() {
        super((FileType)YAMLFileType.YML);
    }

    @NotNull
    public List<SpringBootConfigImportStatement> getImportStatements(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(1);
        }
        Map data = FileBasedIndex.getInstance().getFileData(SpringBootYamlImportsKt.YAML_IMPORTS_INDEX_KEY, configFile, project);
        List list = ContainerUtil.map(data.keySet(), ix -> new SpringBootConfigImportStatement(ix.getFilePointerText(), ix.getDocumentId()));
        if (list == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(@NotNull PsiFile configFile, @NotNull ConfigurationValueSearchParams params) {
        if (configFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(3);
        }
        if (params == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = configFile.getVirtualFile();
        params.getProcessedFiles().add(virtualFile);
        YAMLFile yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)configFile, YAMLFile.class);
        if (yamlFile == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(5);
            }
            return list;
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (!SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevant((ConfigurationValueSearchParams)params, (String)profileSuffix)) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(6);
            }
            return list;
        }
        MetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        SmartList results = new SmartList();
        boolean enableBooleanVersion22 = SpringBootLibraryUtil.isAtLeastVersion((Module)params.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0);
        SpringBootYamlScanner scanner = new SpringBootYamlScanner(binder, enableBooleanVersion22);
        List documents = yamlFile.getDocuments();
        if (!documents.isEmpty()) {
            boolean processAllDocuments = params.isProcessAllProfiles();
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                YAMLDocument document = (YAMLDocument)documents.get(documentId);
                String profileText = SpringBootModelApplicationYamlConfigFileContributor.getProfileText(document, params, profileSuffix);
                if (!processAllDocuments && !SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(params, profileText)) continue;
                SpringBootModelApplicationYamlConfigFileContributor.processImports((ConfigurationValueSearchParams)params, (VirtualFile)virtualFile, (List)results, (int)documentId);
                if (!scanner.processDocument(document, documentId, profileText, params, ((List)results)::add) && !processAllDocuments) break;
            }
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    public List<? extends PsiElement> getDocumentAnchors(@NotNull PsiFile configFile, @Nullable Module module) {
        YAMLFile yamlFile;
        if (configFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(8);
        }
        List list = (yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)configFile, YAMLFile.class)) != null ? yamlFile.getDocuments() : Collections.emptyList();
        if (list == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(9);
        }
        return list;
    }

    public List<? extends PsiElement> getDocumentAnchors(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Set<String> activeProfiles) {
        Module module;
        if (project == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(11);
        }
        if (activeProfiles == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(12);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project)) == null) {
            return Collections.emptyList();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        YAMLFile yamlFile = (YAMLFile)ObjectUtils.tryCast((Object)psiFile, YAMLFile.class);
        if (yamlFile == null) {
            return Collections.emptyList();
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        SmartList result = new SmartList();
        List documents = yamlFile.getDocuments();
        if (!documents.isEmpty()) {
            for (int documentId = documents.size() - 1; documentId >= 0; --documentId) {
                YAMLValue topLevelValue;
                YAMLDocument document = (YAMLDocument)documents.get(documentId);
                String profileText = SpringBootModelApplicationYamlConfigFileContributor.getProfileText(document, module, profileSuffix);
                if (!SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(activeProfiles, profileText) || (topLevelValue = document.getTopLevelValue()) == null) continue;
                result.add(topLevelValue);
            }
        }
        return result;
    }

    private static boolean isProfileRelevantDocument(ConfigurationValueSearchParams params, @Nullable String profileText) {
        Set activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty((Collection)activeProfiles) || profileText == null) {
            return true;
        }
        return SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(activeProfiles, profileText);
    }

    private static boolean isProfileRelevantDocument(Set<String> activeProfiles, @Nullable String profileText) {
        if (profileText == null) {
            return activeProfiles.isEmpty();
        }
        try {
            Predicate profiles = SpringProfilesFactory.getInstance().parseProfileExpressions((Collection)StringUtil.split((String)profileText, (String)","));
            return profiles.test(activeProfiles);
        }
        catch (SpringProfilesFactory.MalformedProfileExpressionException e) {
            return false;
        }
    }

    private static String getProfileText(YAMLDocument document, ConfigurationValueSearchParams params, String fileProfile) {
        return SpringBootModelApplicationYamlConfigFileContributor.getProfileText(document, params.getModule(), fileProfile);
    }

    private static String getProfileText(YAMLDocument document, Module module, String fileProfile) {
        ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, module, (MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance());
        String profileText = SpringBootModelApplicationYamlConfigFileContributor.getProfileByKey("spring.profiles", accessor, null);
        if (profileText == null) {
            profileText = SpringBootModelApplicationYamlConfigFileContributor.getProfileByKey("spring.config.activate.on-profile", accessor, fileProfile);
        }
        return profileText;
    }

    private static String getProfileByKey(String key, ConfigYamlAccessor accessor, String fileProfile) {
        YAMLKeyValue profilesKey = accessor.findExistingKey(key);
        if (profilesKey == null) {
            return fileProfile;
        }
        YAMLValue valueElement = profilesKey.getValue();
        if (valueElement instanceof YAMLScalar) {
            YAMLScalar scalar = (YAMLScalar)valueElement;
            return scalar.getTextValue();
        }
        if (valueElement instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)valueElement;
            List profiles = ContainerUtil.mapNotNull((Collection)sequence.getItems(), item -> {
                YAMLValue value = item.getValue();
                if (value instanceof YAMLScalar) {
                    YAMLScalar scalar = (YAMLScalar)value;
                    return scalar.getTextValue();
                }
                return null;
            });
            return StringUtil.join((Collection)profiles, (String)",");
        }
        return fileProfile;
    }

    public boolean processAllKeys(@NotNull PsiFile configFile, Processor<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> processor) {
        if (configFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(13);
        }
        if (!(configFile instanceof YAMLFile)) {
            return true;
        }
        YAMLFile yamlFile = (YAMLFile)configFile;
        Processor yamlProcessor = keyValue -> processor.process((Object)com.intellij.openapi.util.Pair.create((Object)keyValue, (Object)keyValue.getValue()));
        for (YAMLDocument document : ContainerUtil.reverse((List)yamlFile.getDocuments())) {
            if (ConfigYamlAccessor.processAllKeysReversed((YAMLPsiElement)document, (Processor)yamlProcessor)) continue;
            return false;
        }
        return true;
    }

    public void addConfiguration(@NotNull VirtualFile vFile, @NotNull String key, @NotNull String value, @NotNull Project project) {
        PsiManager psiManager;
        PsiFile psiFile;
        if (vFile == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(14);
        }
        if (key == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(15);
        }
        if (value == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(16);
        }
        if (project == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(17);
        }
        if (!((psiFile = (psiManager = PsiManager.getInstance((Project)project)).findFile(vFile)) instanceof YAMLFile)) {
            return;
        }
        YAMLFile yamlFile = (YAMLFile)psiFile;
        List<? extends PsiElement> anchors = this.getDocumentAnchors(project, vFile, Collections.emptySet());
        if (anchors.isEmpty()) {
            YAMLMapping newMapping = SpringBootApplicationYamlUtilKt.generateMappingHierarchy(key, value, project);
            if (newMapping == null) {
                return;
            }
            List documents = yamlFile.getDocuments();
            if (!documents.isEmpty()) {
                ((YAMLDocument)documents.getFirst()).add((PsiElement)newMapping);
            }
        } else if (anchors.size() == 1) {
            PsiElement firstAnchor = anchors.getFirst();
            if (!(firstAnchor instanceof YAMLMapping)) {
                return;
            }
            YAMLMapping rootMapping = (YAMLMapping)firstAnchor;
            Pair<YAMLMapping, String> result = SpringBootApplicationYamlUtilKt.getDeepestMatchingYamlMapping(rootMapping, key);
            if (result != null) {
                YAMLMapping matchingMapping = (YAMLMapping)result.getFirst();
                YAMLKeyValue newKeyValue = SpringBootApplicationYamlUtilKt.generateKeyValueHierarchy((String)result.getSecond(), value, project);
                if (newKeyValue != null) {
                    matchingMapping.putKeyValue(newKeyValue);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentAnchors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationValues";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentAnchors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

