/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scroll.LatchingScroll;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JLayer;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010#\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001cJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0013H\u0002J*\u0010(\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0)2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u001cH\u0002J\u0018\u0010.\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000fH\u0002J\n\u00100\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u00102\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\rH\u0002J\u0012\u00105\u001a\u00020\"2\b\u00106\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u00107\u001a\u00020\"2\u0006\u00106\u001a\u00020\u0005H\u0002J\b\u00108\u001a\u00020\"H\u0002J\u0010\u00109\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lcom/intellij/notebooks/visualization/ui/NestedScrollingSupportImpl;", "", "<init>", "()V", "_currentMouseWheelOwner", "Ljava/awt/Component;", "value", "currentMouseWheelOwner", "getCurrentMouseWheelOwner", "()Ljava/awt/Component;", "setCurrentMouseWheelOwner", "(Ljava/awt/Component;)V", "timestamp", "", "dispatchingEvent", "Ljava/awt/event/MouseEvent;", "isNewEventCreated", "", "e", "Ljava/awt/event/MouseWheelEvent;", "isDispatchingInProgress", "latchingScroll", "Lcom/intellij/ui/scroll/LatchingScroll;", "getLatchingScroll", "()Lcom/intellij/ui/scroll/LatchingScroll;", "latchingScroll$delegate", "Lkotlin/Lazy;", "scrolledPane", "Ljavax/swing/JScrollPane;", "scrolledPaneTimestamp", "scrollOwnershipTimeout", "getScrollOwnershipTimeout", "()J", "processMouseWheelEvent", "", "processMouseEvent", "scrollPane", "processMouseMotionEvent", "dispatchEvent", "event", "getScrollbarAndSize", "Lkotlin/Triple;", "Ljavax/swing/JScrollBar;", "", "canScroll", "owner", "dispatchEventSync", "redispatchEvent", "resetOwnerIfTimeoutExceeded", "resetOwnerIfEventIsOutside", "isEventInsideOwner", "isTimeoutExceeded", "timeoutMillis", "updateOwner", "component", "replaceOwner", "resetOwner", "isAsync", "Companion", "intellij.notebooks.visualization"})
public final class NestedScrollingSupportImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Component _currentMouseWheelOwner;
    private long timestamp;
    @Nullable
    private MouseEvent dispatchingEvent;
    @NotNull
    private final Lazy latchingScroll$delegate = LazyKt.lazy(NestedScrollingSupportImpl::latchingScroll_delegate$lambda$0);
    @Nullable
    private JScrollPane scrolledPane;
    private long scrolledPaneTimestamp;
    @NotNull
    private static final Set<KClass<?>> asyncComponents = new LinkedHashSet();

    private final Component getCurrentMouseWheelOwner() {
        return this.resetOwnerIfTimeoutExceeded();
    }

    private final void setCurrentMouseWheelOwner(Component value) {
        this._currentMouseWheelOwner = value;
    }

    private final boolean isNewEventCreated(MouseWheelEvent e) {
        return !Intrinsics.areEqual((Object)this.dispatchingEvent, (Object)e);
    }

    private final boolean isDispatchingInProgress() {
        return this.dispatchingEvent != null;
    }

    private final LatchingScroll getLatchingScroll() {
        Lazy lazy = this.latchingScroll$delegate;
        return (LatchingScroll)lazy.getValue();
    }

    private final long getScrollOwnershipTimeout() {
        return Registry.Companion.intValue("jupyter.editor.scroll.mousewheel.timeout", 750);
    }

    public final void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component component = e.getComponent();
        if (this.isDispatchingInProgress()) {
            if (!this.isNewEventCreated(e)) {
                return;
            }
            if (this._currentMouseWheelOwner != null) {
                e.consume();
                return;
            }
        }
        this.resetOwnerIfTimeoutExceeded();
        Component owner = this.resetOwnerIfEventIsOutside(e);
        if (owner instanceof JScrollPane && !this.canScroll(e, (JScrollPane)owner)) {
            this.resetOwner();
        }
        if (e.isConsumed()) {
            return;
        }
        if (owner != null) {
            if (!Intrinsics.areEqual((Object)component, (Object)owner)) {
                MouseEvent mouseEvent = SwingUtilities.convertMouseEvent(component, e, owner);
                Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"convertMouseEvent(...)");
                this.redispatchEvent(mouseEvent);
                e.consume();
            } else {
                this.dispatchEvent(e);
            }
        }
    }

    public final void processMouseEvent(@NotNull MouseEvent e, @NotNull JScrollPane scrollPane) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        if (e.getID() == 500 || e.getID() == 502 || e.getID() == 501) {
            this.updateOwner(scrollPane);
        }
    }

    public final void processMouseMotionEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component owner = this.getCurrentMouseWheelOwner();
        if (owner != null && this.isTimeoutExceeded(100L) && !this.isEventInsideOwner(owner, e)) {
            this.resetOwner();
        }
    }

    private final void dispatchEvent(MouseWheelEvent event) {
        Component owner = event.getComponent();
        Intrinsics.checkNotNull((Object)owner);
        if (this.isAsync(owner)) {
            return;
        }
        if (owner instanceof JLayer) {
            Container ownerParent = ((JLayer)owner).getParent();
            if (ownerParent instanceof JLayer) {
                Container container = ((JLayer)ownerParent).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
                this.dispatchEventSync(event, container);
            } else {
                Intrinsics.checkNotNull((Object)ownerParent);
                this.dispatchEventSync(event, ownerParent);
            }
        } else {
            this.dispatchEventSync(event, owner);
        }
    }

    private final Triple<JScrollBar, Integer, Integer> getScrollbarAndSize(MouseWheelEvent event, JScrollPane scrollPane) {
        return event.isShiftDown() ? new Triple((Object)scrollPane.getHorizontalScrollBar(), (Object)scrollPane.getViewport().getWidth(), (Object)scrollPane.getViewport().getPreferredSize().width) : new Triple((Object)scrollPane.getVerticalScrollBar(), (Object)scrollPane.getViewport().getHeight(), (Object)scrollPane.getViewport().getPreferredSize().height);
    }

    private final boolean canScroll(MouseWheelEvent event, JScrollPane owner) {
        boolean result;
        int preferredSize;
        if (event.getSource() instanceof JScrollPane && this.getLatchingScroll().shouldBeIgnored(event)) {
            event.consume();
            return true;
        }
        Triple<JScrollBar, Integer, Integer> triple = this.getScrollbarAndSize(event, owner);
        JScrollBar scrollBar = (JScrollBar)triple.component1();
        int size = ((Number)triple.component2()).intValue();
        if (size >= (preferredSize = ((Number)triple.component3()).intValue())) {
            return false;
        }
        boolean bl = event.getPreciseWheelRotation() > 0.0 ? scrollBar.getMaximum() > scrollBar.getValue() + size : (result = scrollBar.getMinimum() < scrollBar.getValue());
        if (result && Intrinsics.areEqual((Object)this.scrolledPane, (Object)owner)) {
            this.scrolledPaneTimestamp = System.currentTimeMillis();
        } else if (!result && Intrinsics.areEqual((Object)this.scrolledPane, (Object)owner)) {
            boolean bl2;
            if (System.currentTimeMillis() - this.scrolledPaneTimestamp < this.getScrollOwnershipTimeout()) {
                event.consume();
                bl2 = true;
            } else {
                bl2 = false;
            }
            return bl2;
        }
        this.scrolledPane = owner;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatchEventSync(MouseWheelEvent event, Component owner) {
        MouseEvent oldDispatchingEvent = this.dispatchingEvent;
        this.dispatchingEvent = event;
        try {
            owner.dispatchEvent(event);
            if (event.isConsumed() && this._currentMouseWheelOwner == null) {
                this.updateOwner(owner);
            } else {
                this.updateOwner(this._currentMouseWheelOwner);
            }
        }
        finally {
            this.dispatchingEvent = oldDispatchingEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void redispatchEvent(MouseEvent event) {
        MouseEvent oldDispatchingEvent = this.dispatchingEvent;
        this.dispatchingEvent = null;
        try {
            Component owner = event.getComponent();
            owner.dispatchEvent(event);
        }
        finally {
            this.dispatchingEvent = oldDispatchingEvent;
        }
    }

    private final Component resetOwnerIfTimeoutExceeded() {
        Component component;
        Component currentOwner = this._currentMouseWheelOwner;
        if (currentOwner == null) {
            return null;
        }
        if (this.isTimeoutExceeded(this.getScrollOwnershipTimeout())) {
            this.resetOwner();
            component = null;
        } else {
            component = currentOwner;
        }
        return component;
    }

    private final Component resetOwnerIfEventIsOutside(MouseWheelEvent e) {
        Component component;
        Component currentOwner = this._currentMouseWheelOwner;
        if (currentOwner != null && this.isEventInsideOwner(currentOwner, e)) {
            component = currentOwner;
        } else {
            this.resetOwner();
            component = e.getComponent();
        }
        return component;
    }

    private final boolean isEventInsideOwner(Component owner, MouseEvent e) {
        boolean bl;
        Component component = e.getComponent();
        if (component == null) {
            bl = false;
        } else {
            Point p = SwingUtilities.convertPoint(component, e.getPoint(), owner);
            bl = owner.contains(p);
        }
        return bl;
    }

    private final boolean isTimeoutExceeded(long timeoutMillis) {
        return this.timestamp + timeoutMillis < System.currentTimeMillis();
    }

    private final void updateOwner(Component component) {
        if (component != null) {
            this.replaceOwner(component);
        } else {
            this.resetOwner();
        }
    }

    private final void replaceOwner(Component component) {
        this._currentMouseWheelOwner = component;
        this.timestamp = System.currentTimeMillis();
    }

    private final void resetOwner() {
        this.timestamp = 0L;
        this._currentMouseWheelOwner = null;
    }

    private final boolean isAsync(Component owner) {
        return asyncComponents.contains(Reflection.getOrCreateKotlinClass(owner.getClass()));
    }

    private static final LatchingScroll latchingScroll_delegate$lambda$0() {
        return new LatchingScroll();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/ui/NestedScrollingSupportImpl$Companion;", "", "<init>", "()V", "asyncComponents", "", "Lkotlin/reflect/KClass;", "getAsyncComponents$intellij_notebooks_visualization", "()Ljava/util/Set;", "registerAsyncComponent", "", "type", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<KClass<?>> getAsyncComponents$intellij_notebooks_visualization() {
            return asyncComponents;
        }

        public final void registerAsyncComponent(@NotNull KClass<?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.getAsyncComponents$intellij_notebooks_visualization().add(type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

