/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.model.serialization.converters.RelativeReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\rH\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_0;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "SimpleRenamedProperties", "", "", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "adjustSequence", "node", "Lcom/intellij/database/model/serialization/ModelElementMem;", "adjustColumns", "mm", "property", "Lcom/intellij/database/model/serialization/MutableNameAndValue;", "adjustRefKey", "adjustUnderlyingIndex", "adjustRenamedProperty", "colNames", "removeProperty", "", "name", "representedShortNumber", "Ljava/lang/Short;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_0.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_0.kt\ncom/intellij/database/model/serialization/converters/Converter_4_0\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,177:1\n37#2,2:178\n37#2,2:180\n*S KotlinDebug\n*F\n+ 1 Converter_4_0.kt\ncom/intellij/database/model/serialization/converters/Converter_4_0\n*L\n30#1:178,2\n52#1:180,2\n*E\n"})
public final class Converter_4_0
extends Converter {
    @NotNull
    public static final Converter_4_0 INSTANCE = new Converter_4_0();
    @NotNull
    private static final Map<String, String> SimpleRenamedProperties;

    private Converter_4_0() {
        int[] nArray = new int[]{4, 0};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Dbms dbms = modelMem.getDbms();
        Collection $this$toTypedArray$iv = modelMem.getNodes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (ModelElementMem node : thisCollection$iv.toArray(new ModelElementMem[0])) {
            Dbms dbms2 = dbms;
            if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.ORACLE)) {
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) {
                    ModelSerializationFun.remove(node.getProperties(), "ref-col-names");
                }
            } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.MSSQL)) {
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)"routine")) {
                    MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node.getProperties(), "type");
                    if (mutableNameAndValue != null) {
                        mutableNameAndValue.setName("routine-type");
                    }
                }
            } else if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.SYBASE) && Intrinsics.areEqual((Object)node.getKind(), (Object)"routine")) {
                this.removeProperty(node, "routine-kind");
                Short num = this.representedShortNumber(node.getName());
                if (num != null) {
                    List<MutableNameAndValue> list = node.getProperties();
                    String string = num.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    list.add(new MutableNameAndValue("position", string));
                }
            }
            if (Intrinsics.areEqual((Object)node.getKind(), (Object)"sequence")) {
                this.adjustSequence(node);
            }
            Collection $this$toTypedArray$iv2 = node.getProperties();
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            for (MutableNameAndValue property : thisCollection$iv2.toArray(new MutableNameAndValue[0])) {
                String propName;
                switch (propName = property.getName()) {
                    case "columns": {
                        this.adjustColumns(modelMem, node, property);
                        break;
                    }
                    case "ref-key": {
                        this.adjustRefKey(modelMem, node, property);
                        break;
                    }
                    case "underlying-index": {
                        this.adjustUnderlyingIndex(modelMem, node, property);
                        break;
                    }
                    default: {
                        this.adjustRenamedProperty(property);
                    }
                }
                if (SimpleRenamedProperties.containsKey(propName) && ((CharSequence)property.getValue()).length() == 0) {
                    node.getProperties().remove(property);
                }
                if (!Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.ORACLE) || !Intrinsics.areEqual((Object)propName, (Object)"on-update") && !Intrinsics.areEqual((Object)propName, (Object)"cascade-update-rule")) continue;
                node.getProperties().remove(property);
            }
        }
    }

    private final void adjustSequence(ModelElementMem node) {
        Object s;
        MutableNameAndValue minP = ModelSerializationFun.find(node.getProperties(), "min-value");
        MutableNameAndValue maxP = ModelSerializationFun.find(node.getProperties(), "max-value");
        MutableNameAndValue incP = ModelSerializationFun.find(node.getProperties(), "increment-by");
        MutableNameAndValue nextP = ModelSerializationFun.find(node.getProperties(), "next-value");
        if (minP == null && maxP == null && incP == null && nextP == null) {
            return;
        }
        MutableNameAndValue mutableNameAndValue = minP;
        String min = mutableNameAndValue != null ? mutableNameAndValue.getValue() : null;
        MutableNameAndValue mutableNameAndValue2 = maxP;
        String max = mutableNameAndValue2 != null ? mutableNameAndValue2.getValue() : null;
        MutableNameAndValue mutableNameAndValue3 = incP;
        String inc = mutableNameAndValue3 != null ? mutableNameAndValue3.getValue() : null;
        MutableNameAndValue mutableNameAndValue4 = nextP;
        String next = mutableNameAndValue4 != null ? mutableNameAndValue4.getValue() : null;
        Object object = min;
        if (object == null) {
            object = s = "1";
        }
        if (next != null) {
            s = (String)s + "(" + next + ")";
        }
        if (inc != null) {
            s = (String)s + (String)(ModelSerializationFun.startsWith(inc, '-') || ModelSerializationFun.startsWith(inc, '+') ? inc : "+" + inc);
        }
        if (max != null) {
            s = (String)s + ".." + max;
        }
        if (minP != null) {
            node.getProperties().remove(minP);
        }
        if (maxP != null) {
            node.getProperties().remove(maxP);
        }
        if (incP != null) {
            node.getProperties().remove(incP);
        }
        if (nextP != null) {
            node.getProperties().remove(nextP);
        }
        ModelSerializationFun.add(node.getProperties(), "sequence-identity", (String)s);
    }

    /*
     * Unable to fully structure code
     */
    private final void adjustColumns(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        var4_4 = node.getKind();
        switch (var4_4.hashCode()) {
            case 100346066: {
                if (!var4_4.equals("index")) {
                    break;
                }
                ** GOTO lbl17
            }
            case -1449326106: {
                if (!var4_4.equals("foreign-key")) {
                    break;
                }
                ** GOTO lbl17
            }
            case 94627080: {
                if (!var4_4.equals("check")) {
                    break;
                }
                ** GOTO lbl17
            }
            case 106079: {
                if (!var4_4.equals("key")) break;
lbl17:
                // 4 sources

                property.setName("col-names");
            }
        }
    }

    private final void adjustRefKey(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        ModelElementMem tableMem = ModelSerializationFun.findParentOf(mm, node);
        RelativeReference relativeReference = RelativeReference.of(property.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)relativeReference, (String)"of(...)");
        RelativeReference ref = relativeReference;
        Intrinsics.checkNotNullExpressionValue((Object)ref.path, (String)"path");
        String[] path = ref.path;
        int n = path.length;
        boolean ora = Intrinsics.areEqual((Object)mm.getDbms(), (Object)Dbms.ORACLE);
        switch (n) {
            case 1: {
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, tableMem, "key", path[0]);
                ModelElementMem modelElementMem = tableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[0]);
                if (ora) break;
                ModelElementMem modelElementMem2 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem2 != null ? this.colNames(modelElementMem2) : null);
                break;
            }
            case 2: {
                ModelElementMem refTableMem = ModelSerializationFun.findSibling(mm, tableMem, path[0]);
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, refTableMem, "key", path[1]);
                ModelElementMem modelElementMem = refTableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[1]);
                if (ora) break;
                ModelElementMem modelElementMem3 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem3 != null ? this.colNames(modelElementMem3) : null);
                break;
            }
            case 3: {
                ModelElementMem schemaMem = ModelSerializationFun.findParentOf(mm, tableMem);
                ModelElementMem refSchemaMem = ModelSerializationFun.findSibling(mm, schemaMem, path[0]);
                ModelElementMem refTableMem = ModelSerializationFun.findChildOf(mm, refSchemaMem, "table", path[1]);
                ModelElementMem refKeyMem = ModelSerializationFun.findChildOf(mm, refTableMem, "key", path[2]);
                ModelElementMem modelElementMem = refSchemaMem;
                ModelSerializationFun.add(node.getProperties(), "ref-schema-name", modelElementMem != null ? modelElementMem.getName() : null);
                ModelElementMem modelElementMem4 = refTableMem;
                ModelSerializationFun.add(node.getProperties(), "ref-table-name", modelElementMem4 != null ? modelElementMem4.getName() : null);
                ModelSerializationFun.add(node.getProperties(), "ref-key-name", path[2]);
                if (ora) break;
                ModelElementMem modelElementMem5 = refKeyMem;
                ModelSerializationFun.add(node.getProperties(), "ref-col-names", modelElementMem5 != null ? this.colNames(modelElementMem5) : null);
            }
        }
        node.getProperties().remove(property);
    }

    private final void adjustUnderlyingIndex(ModelMem mm, ModelElementMem node, MutableNameAndValue property) {
        String refStr = property.getValue();
        if (!ModelSerializationFun.startsWith(refStr, '#') && !ModelSerializationFun.startsWith(refStr, '~')) {
            property.setName("underlying-index-name");
        }
    }

    private final void adjustRenamedProperty(MutableNameAndValue property) {
        String name1 = property.getName();
        String name2 = SimpleRenamedProperties.get(name1);
        if (name2 != null && !Intrinsics.areEqual((Object)name2, (Object)name1)) {
            property.setName(name2);
        }
    }

    private final String colNames(ModelElementMem $this$colNames) {
        MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find($this$colNames.getProperties(), "col-names");
        if (mutableNameAndValue == null) {
            mutableNameAndValue = ModelSerializationFun.find($this$colNames.getProperties(), "columns");
        }
        return mutableNameAndValue != null ? mutableNameAndValue.getValue() : null;
    }

    private final boolean removeProperty(ModelElementMem $this$removeProperty, String name) {
        return CollectionsKt.removeAll($this$removeProperty.getProperties(), arg_0 -> Converter_4_0.removeProperty$lambda$0(name, arg_0));
    }

    private final Short representedShortNumber(String $this$representedShortNumber) {
        CharSequence charSequence = $this$representedShortNumber;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        char c2 = $this$representedShortNumber.charAt(0);
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            try {
                return new Short($this$representedShortNumber);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static final boolean removeProperty$lambda$0(String $name, MutableNameAndValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"mandatory", (Object)"not-null"), TuplesKt.to((Object)"direction", (Object)"argument-direction"), TuplesKt.to((Object)"cascade-update-rule", (Object)"on-update"), TuplesKt.to((Object)"cascade-delete-rule", (Object)"on-delete"), TuplesKt.to((Object)"trig-turn", (Object)"turn"), TuplesKt.to((Object)"trig-events", (Object)"events"), TuplesKt.to((Object)"trig-columns", (Object)"col-names"), TuplesKt.to((Object)"desc-columns", (Object)"reverse-col-names")};
        SimpleRenamedProperties = MapsKt.mapOf((Pair[])pairArray);
    }
}

