/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0082\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/types/DasArrayTypeBase;", "Lcom/intellij/database/types/DasArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "<init>", "(Lcom/intellij/database/types/DasType;)V", "getComponentType", "getDescription", "", "toDataType", "Lcom/intellij/database/model/DataType;", "equals", "", "other", "", "hashCode", "", "intellij.database.core.impl"})
public abstract class DasArrayTypeBase
implements DasArrayType {
    @NotNull
    private final DasType componentType;

    public DasArrayTypeBase(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        this.componentType = componentType;
    }

    @NotNull
    public DasType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public String getDescription() {
        if (Intrinsics.areEqual((Object)this.componentType, DasTypeSystemBase.UNKNOWN)) {
            String string = this.getTypeClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        return this.getTypeClass().getName() + "(" + this.componentType.getDescription() + ")";
    }

    @NotNull
    public DataType toDataType() {
        Object object = Intrinsics.areEqual((Object)this.componentType, DasTypeSystemBase.UNKNOWN) ? this.getTypeClass().getName() : this.componentType.getSpecification() + "[]";
        Intrinsics.checkNotNull((Object)object);
        Object spec = object;
        DataType dataType = DataTypeFactory.of((String)spec);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.types.DasArrayTypeBase");
        DasArrayTypeBase cfr_ignored_0 = (DasArrayTypeBase)object2;
        return Intrinsics.areEqual((Object)this.componentType, (Object)((DasArrayTypeBase)other).componentType) && Intrinsics.areEqual((Object)this.getTypeClass(), (Object)((DasArrayTypeBase)other).getTypeClass());
    }

    public int hashCode() {
        int result = this.componentType.hashCode();
        result = 31 * result + this.getTypeClass().hashCode();
        return result;
    }
}

