/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class HCodeFragmentFactory {
    private final Project project;
    private final JavaCodeFragmentFactory factory;

    public HCodeFragmentFactory(Project project) {
        this.project = project;
        this.factory = JavaCodeFragmentFactory.getInstance((Project)project);
    }

    public static HCodeFragmentFactory getInstance(Project project) {
        return (HCodeFragmentFactory)project.getService(HCodeFragmentFactory.class);
    }

    @NotNull
    public Document createTypeCodeDocument(@NotNull PsiDirectory directory, @Nullable JavaCodeFragment.VisibilityChecker visibilityChecker) {
        if (directory == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(0);
        }
        PsiPackage pkg = JavaDirectoryService.getInstance().getPackage(directory);
        PsiJavaCodeReferenceCodeFragment fragment = this.factory.createReferenceCodeFragment("", (PsiElement)pkg, true, true);
        fragment.setVisibilityChecker(visibilityChecker);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
        Document document = documentManager.getDocument((PsiFile)fragment);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(1);
        }
        return document2;
    }

    @NotNull
    public Document createTypeCodeDocument(@NotNull PsiClass entityClass, @Nullable JavaCodeFragment.VisibilityChecker visibilityChecker) {
        if (entityClass == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(2);
        }
        Document document = this.createCodeFragmentDocument(entityClass, visibilityChecker, context -> JavaCodeFragmentFactory.getInstance((Project)this.project).createTypeCodeFragment("", context, true, 1));
        if (document == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(3);
        }
        return document;
    }

    public Document createReferenceCodeDocument(@NotNull PsiClass entityClass, @Nullable JavaCodeFragment.VisibilityChecker visibilityChecker) {
        if (entityClass == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(4);
        }
        return this.createCodeFragmentDocument(entityClass, visibilityChecker, context -> JavaCodeFragmentFactory.getInstance((Project)this.project).createReferenceCodeFragment("", context, true, true));
    }

    private Document createCodeFragmentDocument(@NotNull PsiClass entityClass, @Nullable JavaCodeFragment.VisibilityChecker visibilityChecker, CodeFragmentCreator codeFragmentCreator) {
        if (entityClass == null) {
            HCodeFragmentFactory.$$$reportNull$$$0(5);
        }
        PsiClass context = entityClass;
        if (entityClass.getFields().length != 0) {
            context = entityClass.getFields()[0];
        } else if (entityClass.getMethods().length != 0) {
            context = entityClass.getMethods()[0];
        }
        JavaCodeFragment typeCodeFragment = codeFragmentCreator.create((PsiElement)context);
        typeCodeFragment.setVisibilityChecker(visibilityChecker);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
        Document document = documentManager.getDocument((PsiFile)typeCodeFragment);
        return Objects.requireNonNull(document);
    }

    @Nullable
    public PsiType getMigrationType(Document document) {
        return (PsiType)WriteCommandAction.runWriteCommandAction((Project)this.project, () -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
            if (psiFile instanceof PsiTypeCodeFragment) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(document);
                try {
                    return ((PsiTypeCodeFragment)psiFile).getType();
                }
                catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                    Logger.getInstance(HCodeFragmentFactory.class).debug(e);
                    return null;
                }
            }
            if (psiFile instanceof PsiJavaCodeReferenceCodeFragment) {
                if (psiFile.getChildren().length == 0) {
                    return null;
                }
                PsiJavaCodeReferenceElement classReference = ((PsiJavaCodeReferenceCodeFragment)psiFile).getReferenceElement();
                if (classReference != null) {
                    return PsiElementFactory.getInstance((Project)this.project).createType(classReference);
                }
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/HCodeFragmentFactory";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/HCodeFragmentFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeCodeDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCodeDocument";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceCodeDocument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragmentDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static interface CodeFragmentCreator {
        public JavaCodeFragment create(PsiElement var1);
    }
}

