/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action;

import com.intellij.ide.IdeView;
import com.intellij.jpa.jpb.model.action.JpbProjectAction;
import com.intellij.jpa.jpb.model.action.StructureKeys;
import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.service.BeanService;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.sequences.Sequence;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class JpbElementCreationAction
extends JpbProjectAction
implements WriteActionAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JpbElementCreationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e, @NotNull Project project) {
        PsiDirectory dir;
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(2);
        }
        if ((dir = this.getDir(project, e)) == null) {
            return;
        }
        PsiElement[] createdElements = this.createElements(project, e, dir);
        this.afterCreation(e, createdElements);
    }

    @Nullable
    protected PsiDirectory getDir(@NotNull Project project, @NotNull AnActionEvent e) {
        PsiDirectory dir;
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(4);
        }
        if ((dir = this.findDirByActionDataElement(project, e)) == null || !dir.isWritable() || !JpbElementCreationAction.isFromSourceRoot(dir)) {
            dir = this.foundPackageForCreation(project, e);
        }
        return dir;
    }

    @Nullable
    protected PsiDirectory findDirByActionDataElement(@NotNull Project project, @NotNull AnActionEvent e) {
        VirtualFile[] virtualFiles;
        PsiElement psiElement;
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(5);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(6);
        }
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = null;
        if (view != null) {
            dir = view.getOrChooseDirectory();
        }
        if (dir == null && (psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) != null && psiElement.getContainingFile() != null) {
            dir = psiElement.getContainingFile().getContainingDirectory();
        }
        if (dir == null) {
            PsiFile editorFile;
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            PsiFile psiFile = editorFile = editor == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (editorFile != null) {
                dir = editorFile.getContainingDirectory();
            }
        }
        if (dir == null && (virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            for (VirtualFile virtualFile : virtualFiles) {
                VirtualFile directoryVf = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
                PsiDirectory psiDirectory = dir = directoryVf == null ? null : PsiManager.getInstance((Project)project).findDirectory(directoryVf);
                if (dir != null) break;
            }
        }
        return dir;
    }

    private static boolean isFromSourceRoot(PsiDirectory dir) {
        List sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)dir.getProject());
        VirtualFile dirVirtualFile = dir.getVirtualFile();
        return ContainerUtil.or((Iterable)sourceRoots, sourceRoot -> VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)dirVirtualFile, (boolean)false));
    }

    @Nullable
    protected PsiDirectory foundPackageForCreation(@NotNull Project project, @NotNull AnActionEvent e) {
        PsiDirectory foundDir;
        Module module;
        PsiDirectory bootClassDir;
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(7);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(8);
        }
        if (JpaUtils.isSpringBootProject(project) && (bootClassDir = JpbElementCreationAction.findSpringBootDir(project, module = EventDataProviderEP.Companion.getAGGREGATOR().getModule(e))) != null) {
            return bootClassDir;
        }
        if (JpaUtils.isJpaProject(project, null) && (foundDir = JpbElementCreationAction.findPersistenceUnitDir(project, e)) != null) {
            return foundDir;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length == 0) {
            HNotificationManager.getInstance(project).showNotification(JpaModelBundle.message("notification.title.project.not.contains.modules", new Object[0]), JpaModelBundle.message("notification.content.please.select.directory.for.create.action", new Object[0]));
            return null;
        }
        for (Module module2 : modules) {
            VirtualFile[] sourceRoots;
            for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots(false)) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
                if (psiDirectory == null) continue;
                return psiDirectory;
            }
        }
        return null;
    }

    @Nullable
    private static PsiDirectory findSpringBootDir(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(9);
        }
        Sequence<PsiClass> bootApplicationClasses = BeanService.getInstance(project).collectSpringBootApplications(module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.allScope((Project)project));
        return StreamEx.of((Iterator)bootApplicationClasses.iterator()).map(psiClass -> {
            PsiFile containingFile = psiClass.getContainingFile();
            return containingFile == null ? null : containingFile.getContainingDirectory();
        }).nonNull().findFirst().orElseGet(() -> module != null ? JpbElementCreationAction.findSpringBootDir(project, null) : null);
    }

    @Nullable
    private static PsiDirectory findPersistenceUnitDir(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(10);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(11);
        }
        return JpbElementCreationAction.getPersistenceUnits(project, e).stream().map(it -> it.getDefaultDirectory()).filter(it -> it != null).findFirst().orElse(null);
    }

    @NotNull
    private static List<VirtualFile> getSuitableSourceRoots(@NotNull Project project, @NotNull AnActionEvent e) {
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(12);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(13);
        }
        List sourceRootsFromScope = new ArrayList();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module != null) {
            JavaProjectRootsUtil.collectSuitableDestinationSourceRoots((Module)module, sourceRootsFromScope);
        } else {
            sourceRootsFromScope = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
        }
        List list = ((StreamEx)StreamEx.of(sourceRootsFromScope).filter(virtualFile -> !fileIndex.isInTestSourceContent(virtualFile))).toList();
        if (list == null) {
            JpbElementCreationAction.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static Set<OrmUnit> getPersistenceUnits(@NotNull Project project, @NotNull AnActionEvent e) {
        OrmUnit unit;
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(15);
        }
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(16);
        }
        if ((unit = (OrmUnit)e.getData(StructureKeys.ORM_UNIT)) != null) {
            Set<OrmUnit> set = Set.of(unit);
            if (set == null) {
                JpbElementCreationAction.$$$reportNull$$$0(17);
            }
            return set;
        }
        OrmUnitsProvider unitsProvider = OrmUnitsProvider.Companion.getForProject(project);
        if (unitsProvider == null) {
            throw new IllegalStateException();
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module != null) {
            return new HashSet<OrmUnit>(unitsProvider.getUnits(module));
        }
        return new HashSet<OrmUnit>(unitsProvider.getUnits(project));
    }

    protected void afterCreation(@NotNull AnActionEvent e, @Nullable PsiElement[] createdElements) {
        IdeView view;
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(18);
        }
        if (createdElements != null && (view = (IdeView)e.getData(LangDataKeys.IDE_VIEW)) != null) {
            StreamEx.of((Object[])createdElements).nonNull().forEachOrdered(element -> {
                try {
                    view.selectElement(element);
                }
                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void customUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(19);
        }
        if (project == null) {
            JpbElementCreationAction.$$$reportNull$$$0(20);
        }
        Presentation presentation = e.getPresentation();
        if (EventDataProviderEP.Companion.getAGGREGATOR().isGlobalActionPlace(e)) {
            presentation.setEnabledAndVisible(true);
            return;
        }
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        boolean isEnabledAndVisible = false;
        if (view != null) {
            JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : view.getDirectories()) {
                if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || javaDirectoryService.getPackage(dir) == null) continue;
                isEnabledAndVisible = true;
            }
        } else {
            isEnabledAndVisible = this.isNonIdeaViewVisibleAction(e);
        }
        presentation.setEnabledAndVisible(isEnabledAndVisible);
    }

    protected boolean isNonIdeaViewVisibleAction(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        PsiFile containingFile;
        if (e == null) {
            JpbElementCreationAction.$$$reportNull$$$0(21);
        }
        PsiFile psiFile = containingFile = (psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) == null ? null : psiElement.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            PsiClass anyClass = StreamEx.of((Object[])((PsiClassOwner)containingFile).getClasses()).findFirst().orElse(null);
            return anyClass != null;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        EventDataProviderEP eventDataProvider = EventDataProviderEP.Companion.getAGGREGATOR();
        return eventDataProvider.getEntityPsi(e) != null || eventDataProvider.getPersistenceUnit(e) != null;
    }

    @Nullable
    protected abstract PsiElement[] createElements(@NotNull Project var1, @NotNull AnActionEvent var2, @NotNull PsiDirectory var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/action/JpbElementCreationAction";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/action/JpbElementCreationAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableSourceRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doActionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDir";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDirByActionDataElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "foundPackageForCreation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSpringBootDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPersistenceUnitDir";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableSourceRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceUnits";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "afterCreation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "customUpdate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNonIdeaViewVisibleAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

