/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action.creation.entity;

import com.intellij.jpa.jpb.model.action.creation.entity.SequenceItem;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0082\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/action/creation/entity/GenerateForEntityItem;", "Lcom/intellij/jpa/jpb/model/action/creation/entity/SequenceItem;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "name", "", "getName", "()Ljava/lang/String;", "doUpdate", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "entity", "Lcom/intellij/jpa/jpb/model/model/EntityModel;", "equals", "", "other", "", "hashCode", "", "intellij.javaee.jpa.jpb.model"})
public final class GenerateForEntityItem
extends SequenceItem {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;

    public GenerateForEntityItem(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.name = "<Generate exclusively for entity>";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void doUpdate(@NotNull EntityAttributeModel attribute, @NotNull EntityModel entity) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        attribute.setGeneratedStrategy(EntityAttribute.GeneratedStrategy.SEQUENCE);
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.Companion.getInstance(this.project);
        attribute.setGeneratorName(namingStrategy.toSequenceName(entity.getClassName() + "_SEQ"));
        attribute.setSequenceGeneratorOnAttribute(true);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GenerateForEntityItem && Intrinsics.areEqual((Object)this.getName(), (Object)((GenerateForEntityItem)other).getName()) && Intrinsics.areEqual((Object)this.project, (Object)((GenerateForEntityItem)other).project);
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }
}

