/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationWithConstants;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010`\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/JpaAbstractColumnAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationWithConstants;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/JpaAttributeAnnotation;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/JpaAttributeAnnotation;)V", "insertCondition", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "getParams", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "module", "Lcom/intellij/openapi/module/Module;", "knownAttributes", "", "intellij.javaee.jpa.jpb.model"})
public abstract class JpaAbstractColumnAnnotation
extends AnnotationWithConstants {
    public JpaAbstractColumnAnnotation(@NotNull Project project, @NotNull JpaAttributeAnnotation descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(project, descriptor);
    }

    public boolean insertCondition(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return (!attribute.isEmbedded() || attribute.isElementCollection()) && !attribute.isTransient() && !entity.isRegisterInMetaData() && !((Map)this.getParams(attribute, entity.getModule())).isEmpty();
    }

    @Override
    @NotNull
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, @Nullable Module module) {
        String attributeLength;
        Object object;
        LinkedHashMap<String, String> params;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                params = new LinkedHashMap<String, String>();
                CharSequence charSequence = attribute.getColumnPhysical();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    ((Map)params).put("name", AnnotationHelper.wrap(attribute.getColumnPhysical()));
                }
                if (attribute.isMandatory()) break block12;
                object = attribute.getType();
                Datatypes.BasicDatatype basicDatatype = object instanceof Datatypes.BasicDatatype ? (Datatypes.BasicDatatype)object : null;
                boolean bl = basicDatatype != null ? basicDatatype.isPrimitive() : false;
                if (!bl) break block13;
            }
            ((Map)params).put("nullable", "false");
        }
        if (attribute.isUnique()) {
            ((Map)params).put("unique", "true");
        }
        if (!attribute.isInsertable()) {
            ((Map)params).put("insertable", "false");
        }
        if (!attribute.isUpdatable()) {
            ((Map)params).put("updatable", "false");
        }
        if (!((object = (CharSequence)(attributeLength = attribute.getLength())) == null || object.length() == 0) && !Intrinsics.areEqual((Object)"255", (Object)attributeLength)) {
            ((Map)params).put("length", attributeLength);
        }
        if (!((object = (CharSequence)attribute.getColumnDefinition()) == null || StringsKt.isBlank((CharSequence)object))) {
            ((Map)params).put("columnDefinition", "\"" + attribute.getColumnDefinition() + "\"");
        }
        if (attribute.getType() == Datatypes.BasicDatatype.BigDecimal) {
            if (attribute.getPrecision() != 0) {
                ((Map)params).put("precision", String.valueOf(attribute.getPrecision()));
            }
            if (attribute.getScale() != 0) {
                ((Map)params).put("scale", String.valueOf(attribute.getScale()));
            }
        }
        return params;
    }

    @Override
    @Nullable
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        Object[] objectArray = new String[]{"name", "nullable", "unique", "length", "precision", "scale", "columnDefinition", "updatable", "insertable"};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

