/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/jpa/jpb/model/core/util/DocumentUtils;", "", "<init>", "()V", "tryCommitDocument", "", "element", "Lcom/intellij/psi/PsiElement;", "tryDoPostponedOperations", "intellij.javaee.jpa.jpb.model.core"})
public final class DocumentUtils {
    @NotNull
    public static final DocumentUtils INSTANCE = new DocumentUtils();

    private DocumentUtils() {
    }

    public final void tryCommitDocument(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)element.getProject());
        Document document = documentManager.getDocument(element.getContainingFile());
        if (document != null && !documentManager.isCommitted(document)) {
            documentManager.commitDocument(document);
        }
    }

    public final void tryDoPostponedOperations(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)element.getProject());
        Document document = documentManager.getDocument(element.getContainingFile());
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
        }
    }
}

