/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtil;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.MutableComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SPackageNameReferenceEditorCombo
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    @NlsContexts.DialogTitle
    private final String chooserTitle;
    @Nullable
    private Module module;
    @NotNull
    private final Project project;

    public SPackageNameReferenceEditorCombo(@Nullable String text, @NotNull Project project, @Nullable String recentsKey, @NlsContexts.DialogTitle String chooserTitle) {
        List recentEntries;
        if (project == null) {
            SPackageNameReferenceEditorCombo.$$$reportNull$$$0(0);
        }
        super((JComponent)((Object)new MyEditorComboBox(JavaReferenceEditorUtil.createDocument((String)(StringUtil.isEmpty((String)text) ? "" : text), (Project)project, (boolean)false, (JavaCodeFragment.VisibilityChecker)JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE), project, (FileType)JavaFileType.INSTANCE)), null);
        this.chooserTitle = chooserTitle;
        this.project = project;
        List list = recentEntries = recentsKey == null ? null : RecentsManager.getInstance((Project)project).getRecentEntries(recentsKey);
        if (recentEntries != null) {
            this.setHistory(ArrayUtil.toStringArray((Collection)recentEntries));
        }
        if (text != null && !text.isEmpty()) {
            this.prependItem(text);
        } else if (text != null) {
            ((EditorComboBox)this.getChildComponent()).setSelectedItem(null);
        }
        this.addActionListener(this::browsePackage);
    }

    private void browsePackage(ActionEvent e) {
        PsiPackage aPackage;
        PackageChooserDialog chooser = this.module != null ? new PackageChooserDialog(this.chooserTitle, this.module) : new PackageChooserDialog(this.chooserTitle, this.project);
        chooser.selectPackage(this.getText());
        if (chooser.showAndGet() && (aPackage = chooser.getSelectedPackage()) != null) {
            this.setText(aPackage.getQualifiedName());
        }
    }

    @Nullable
    public Module getModule() {
        return this.module;
    }

    public void setModule(@Nullable Module module) {
        this.module = module;
    }

    public String getText() {
        return ((EditorComboBox)this.getChildComponent()).getText().trim();
    }

    public void setText(String text) {
        ((EditorComboBox)this.getChildComponent()).setText(text);
    }

    public void setHistory(String[] history) {
        ((EditorComboBox)this.getChildComponent()).setHistory(history);
    }

    public void prependItem(String item) {
        ((EditorComboBox)this.getChildComponent()).prependItem(item);
    }

    public EditorComboBox getTextField() {
        return (EditorComboBox)this.getChildComponent();
    }

    public void addOptions(List<@NlsSafe String> options, boolean setFirstSelected) {
        ComboBoxModel comboBoxModel;
        if (options.isEmpty() || !((comboBoxModel = ((EditorComboBox)this.getChildComponent()).getModel()) instanceof MutableComboBoxModel)) {
            return;
        }
        MutableComboBoxModel model2 = (MutableComboBoxModel)comboBoxModel;
        HashSet existingOptions = new HashSet();
        for (int i = 0; i < model2.getSize(); ++i) {
            existingOptions.add(model2.getElementAt(i));
        }
        for (String option : options.reversed()) {
            if (existingOptions.contains(option)) continue;
            model2.insertElementAt(option, setFirstSelected ? 0 : 1);
        }
        if (setFirstSelected) {
            ((EditorComboBox)this.getChildComponent()).setSelectedIndex(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/jpb/model/ui/component/SPackageNameReferenceEditorCombo", "<init>"));
    }

    public static class MyEditorComboBox
    extends EditorComboBox {
        private final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        private final DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.getProject());

        MyEditorComboBox(Document document, Project project, FileType fileType) {
            super(document, project, fileType);
        }

        public void addNotify() {
            super.addNotify();
            PsiFile psiFile = this.psiDocumentManager.getPsiFile(this.getDocument());
            if (psiFile != null) {
                this.daemonCodeAnalyzer.setHighlightingEnabled(psiFile, false);
            }
        }
    }
}

