/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jpa/jpb/model/util/ActionIntentionWrapper;", "Lcom/intellij/codeInsight/daemon/impl/GutterIntentionAction;", "order", "", "anAction", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(ILjava/util/function/Supplier;)V", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "checkElementOffset", "psiClass", "Lcom/intellij/psi/PsiClass;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javaee.jpa.jpb.model"})
public class ActionIntentionWrapper
extends GutterIntentionAction {
    @NotNull
    private final Supplier<AnAction> anAction;

    public ActionIntentionWrapper(int order, @NotNull Supplier<AnAction> anAction) {
        Intrinsics.checkNotNullParameter(anAction, (String)"anAction");
        super(anAction, order);
        this.anAction = anAction;
        this.updateFromPresentation(this.anAction.get().getTemplatePresentation());
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.HIGH;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!super.isAvailable(project, editor, psiFile)) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile2);
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        PsiElement psiElement = psiFile2.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        PsiClass psiClass = SUastUtils.getSelectedClass(psiFile, editor);
        if (psiClass == null) {
            return false;
        }
        PsiClass selectedClass = psiClass;
        if (EntityUtil.isEntity(selectedClass)) {
            return this.checkElementOffset(selectedClass, element);
        }
        return false;
    }

    public boolean checkElementOffset(@NotNull PsiClass psiClass, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)psiClass);
        if (templateHelper == null || (templateHelper = templateHelper.getLBrace(psiClass)) == null) {
            return true;
        }
        TemplateHelper lBrace = templateHelper;
        return lBrace.getTextOffset() > element.getTextOffset();
    }
}

