/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.google.common.base.CaseFormat;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.jpa.jpb.model.backend.config.SpringConfigurationSearch;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeService;
import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.core.backend.LibraryModificationTracker;
import com.intellij.jpa.jpb.model.core.util.LibraryUtils;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.util.DependenciesUtils;
import com.intellij.jpa.jpb.model.util.HProjectUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
public final class JpaUtils {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String KOTLIN_ARTIFACT_NAME = "org.jetbrains.kotlin";
    public static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("(?=\\p{Upper})");
    public static final String PLUGIN_ID = "com.intellij.jpa.jpb.model";
    public static final String HIBERNATE_DEPENDENCY_NAME = "org.hibernate:hibernate-core";
    public static final String HIBERNATE_NEW_DEPENDENCY_NAME = "org.hibernate.orm:hibernate-core";

    @NotNull
    public static String decapitalize(@Nullable String value) {
        String string = StringUtil.isEmpty((String)value) ? "" : StringUtil.decapitalize((String)value);
        if (string == null) {
            JpaUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String convertTextToFullHtml(String text) {
        return "<html><body><div class='content'>" + text.replaceAll("\\n", "<br>") + "</div></body></html>";
    }

    @Nullable
    public static String getKeyFromValue(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!DbIdentifierHelper.compareIdentifier(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T> T runWriteCommandAction(Project project, @NlsContexts.Command String commandName, @NotNull Computable<T> computable) {
        if (computable == null) {
            JpaUtils.$$$reportNull$$$0(1);
        }
        return (T)WriteCommandAction.writeCommandAction((Project)project).withName(commandName).compute(() -> computable.compute());
    }

    public static boolean checkSdk(@NotNull Project project) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(2);
        }
        return ProjectRootManager.getInstance((Project)project).getProjectSdk() != null;
    }

    public static String toString(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    @Nullable
    public static String substringAfterLast(String text, String ... parts) {
        if (parts == null) {
            JpaUtils.$$$reportNull$$$0(3);
        }
        for (String part : parts) {
            String substring = StringUtil.substringAfterLast((String)text, (String)part);
            if (substring == null) continue;
            return substring;
        }
        return null;
    }

    public static boolean containsIgnoreCase(Collection<String> collection, String value) {
        for (String s : collection) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUltimate() {
        return IDEA_PREFIX.equals(JpaUtils.getPlatformPrefix()) && !PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    @NotNull
    private static String getPlatformPrefix() {
        String string = System.getProperty(PLATFORM_PREFIX_KEY, IDEA_PREFIX);
        if (string == null) {
            JpaUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isJpaProject(Project project, @Nullable Module module) {
        return DependenciesUtils.INSTANCE.isJpaProject(project, module);
    }

    public static boolean isJakartaProject(Project project, Module module) {
        if (!HProjectUtils.isClassAvailableInLibraries(project, module, "jakarta.persistence." + String.valueOf(JpaEntityAnnotation.Entity))) {
            return false;
        }
        if (!HProjectUtils.isClassAvailableInLibraries(project, module, "javax.persistence." + String.valueOf(JpaEntityAnnotation.Entity))) {
            return true;
        }
        return !HProjectUtils.isClassAvailableInLibraries(project, module, "io.micronaut.runtime.Micronaut");
    }

    public static boolean isJacksonProject(Project project, Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "com.fasterxml.jackson.annotation.JsonIgnoreProperties");
    }

    public static boolean isJakarta3_1Project(Project project) {
        PsiClass generationTypeClass = JpaUtils.getLibraryClassInAllScope(project, "jakarta.persistence.GenerationType");
        Object[] generationTypes = generationTypeClass != null ? generationTypeClass.getFields() : null;
        return generationTypes != null && ContainerUtil.exists((Object[])generationTypes, it -> it.getName().equals("UUID"));
    }

    public static boolean isSpringBootProject(Project project) {
        return JpaUtils.isSpringBootProject(project, null);
    }

    public static boolean isSpringBootProject(Project project, @Nullable Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.springframework.boot.autoconfigure.SpringBootApplication");
    }

    @Deprecated
    public static boolean isHibernateProject(Project project) {
        return JpaUtils.isHibernateProject(project, null);
    }

    public static boolean isHibernateProject(Project project, Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.hibernate.jpa.HibernatePersistenceProvider");
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isHibernate6Project(Project project) {
        return JpaUtils.isHibernate6Project(project, null);
    }

    public static boolean isHibernate6Project(Project project, Module module) {
        return (Boolean)ReadAction.compute(() -> HProjectUtils.isClassAvailableInLibraries(project, module, "org.hibernate.annotations.JdbcTypeCode"));
    }

    public static boolean isHibernate_6_1_Project(@NotNull Project project) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(5);
        }
        return JpaUtils.isHibernateVersionPlus(project, 6, 1);
    }

    public static boolean isHibernate_6_2_Project(@NotNull Project project) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(6);
        }
        return JpaUtils.isHibernateVersionPlus(project, 6, 2);
    }

    public static boolean isHibernate_5_6_Plus(@NotNull Project project) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(7);
        }
        return JpaUtils.isHibernateVersionPlus(project, 5, 6);
    }

    private static boolean isHibernateVersionPlus(@NotNull Project project, int major, int minor) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(8);
        }
        return ReadAction.compute(() -> {
            Key key = CacheKeyStore.getInstance(project).getKey("isHibernate_" + major + "_" + minor + "_Plus");
            return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
                Library[] libraries = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                if (libraries.length == 0) {
                    return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                }
                boolean isHibernateVersionPlus = true;
                for (Library library : libraries) {
                    String groupAndArtifact;
                    String[] coordinatesSplit;
                    String coordinates = LibraryUtils.extractCoordinates(library);
                    if (StringUtil.isEmpty((String)coordinates) || (coordinatesSplit = coordinates.split(":")).length != 3 || !HIBERNATE_DEPENDENCY_NAME.equalsIgnoreCase(groupAndArtifact = coordinatesSplit[0] + ":" + coordinatesSplit[1]) && !HIBERNATE_NEW_DEPENDENCY_NAME.equalsIgnoreCase(groupAndArtifact)) continue;
                    String version = coordinatesSplit[2];
                    SemVer hibernateVersion = JpaUtils.parseSemVerFromText(version);
                    isHibernateVersionPlus = hibernateVersion == null || hibernateVersion.getMajor() > major || hibernateVersion.getMajor() == major && hibernateVersion.getMinor() >= minor;
                    break;
                }
                return CachedValueProvider.Result.create((Object)isHibernateVersionPlus, (Object[])new Object[]{LibraryModificationTracker.getInstance(project)});
            }, false);
        }) == Boolean.TRUE;
    }

    public static SemVer parseSemVerFromText(@Nullable String text) {
        int minorEndIdx;
        int majorEndIdx;
        if (text != null && (majorEndIdx = text.indexOf(46)) >= 0 && (minorEndIdx = text.indexOf(46, majorEndIdx + 1)) >= 0) {
            int major = StringUtil.parseInt((String)text.substring(0, majorEndIdx), (int)-1);
            int minor = StringUtil.parseInt((String)text.substring(majorEndIdx + 1, minorEndIdx), (int)-1);
            if (major >= 0 && minor >= 0) {
                return new SemVer(text, major, minor, 0, null);
            }
        }
        return null;
    }

    @Deprecated
    public static boolean isHibernateEnversProject(Project project) {
        return HProjectUtils.isClassAvailableInLibraries(project, null, "org.hibernate.envers.Audited");
    }

    public static boolean isHibernateEnversProject(Project project, Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.hibernate.envers.Audited");
    }

    public static boolean isEclipseLinkProject(Project project) {
        return HProjectUtils.isClassAvailableInLibraries(project, null, "org.eclipse.persistence.jpa.PersistenceProvider");
    }

    public static boolean isSpringDataJpaProject(Project project) {
        return JpaUtils.isSpringDataJpaProject(project, null);
    }

    public static boolean isSpringDataJpaProject(Project project, @Nullable Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.springframework.data.jpa.repository.JpaRepository");
    }

    public static boolean isSpringDataMongoDbProject(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            JpaUtils.$$$reportNull$$$0(9);
        }
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.springframework.data.mongodb.repository.MongoRepository");
    }

    public static boolean isLombokAvailable(PsiElement psiElement) {
        Project project = psiElement.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        return HProjectUtils.isClassAvailableInLibraries(project, module, "lombok.Getter");
    }

    public static boolean isLombokSuperBuilderAvailable(PsiElement psiElement) {
        Project project = psiElement.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        return HProjectUtils.isClassAvailableInLibraries(project, module, "lombok.experimental.SuperBuilder");
    }

    public static boolean isSpringDataProject(Project project, Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "org.springframework.data.repository.Repository");
    }

    public static boolean isSpringDataProject(Project project) {
        return JpaUtils.isSpringDataProject(project, null);
    }

    public static boolean isSpringData3Project(Project project) {
        return HProjectUtils.isClassAvailableInLibraries(project, null, "org.springframework.data.jpa.support.PageableUtils");
    }

    public static boolean isBlazePersistenceProject(Project project, @Nullable Module module) {
        return HProjectUtils.isClassAvailableInLibraries(project, module, "com.blazebit.persistence.view.EntityView");
    }

    public static boolean hasVladMihalceaHibernateTypes(Project project) {
        return ContainerUtil.exists(HibernateCustomTypeService.Companion.getIMMUTABLE_TYPES_FQN(), it -> HProjectUtils.isClassAvailableInLibraries(project, null, it));
    }

    public static String getVladMihalceaHibernateTypesBasePackage(Project project) {
        List<String> basePackages = HibernateCustomTypeService.Companion.getBASE_PACKAGES();
        List<String> immutableTypesFqn = HibernateCustomTypeService.Companion.getIMMUTABLE_TYPES_FQN();
        Optional<String> availableClassFqn = immutableTypesFqn.stream().filter(it -> HProjectUtils.isClassAvailableInLibraries(project, null, it)).findFirst();
        return availableClassFqn.flatMap(s -> basePackages.stream().filter(s::startsWith).findFirst()).orElse(null);
    }

    @Nullable
    public static PsiClass getLibraryClassInAllScope(Project project, @NotNull String fqn) {
        if (fqn == null) {
            JpaUtils.$$$reportNull$$$0(10);
        }
        return (PsiClass)ReadAction.compute(() -> {
            Key key = CacheKeyStore.getInstance(project).getKey(fqn + "JpaUtils");
            return (PsiClass)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
                Library[] libraries = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
                if (libraries.length == 0) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                }
                return (CachedValueProvider.Result)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
                    PsiClass foundClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
                    return CachedValueProvider.Result.create((Object)foundClass, (Object[])new Object[]{LibraryModificationTracker.getInstance(project)});
                });
            }, false);
        });
    }

    public static boolean isKotlinSupport(Project project) {
        return ContainerUtil.or((Object[])LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries(), library -> library.getName() != null && library.getName().contains(KOTLIN_ARTIFACT_NAME));
    }

    public static boolean isJavaLanguageGreaterOrEqual(Project project, LanguageLevel level) {
        return LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel().isAtLeast(level);
    }

    public static String toUnderscore(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, str);
    }

    public static boolean isHibernateOrJakartaValidatorSupport(Project project) {
        return ContainerUtil.exists(AnnotationHelper.loadValidationLibraryInfo(project).values(), enabled -> enabled);
    }

    @NotNull
    public static String separateByCamelCase(@NotNull String value) {
        if (value == null) {
            JpaUtils.$$$reportNull$$$0(11);
        }
        String string = StreamEx.of((Object[])CAMEL_CASE_PATTERN.split(value)).nonNull().map(StringUtil::capitalize).joining((CharSequence)" ");
        if (string == null) {
            JpaUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static String getEnableAuditingFqn(Project project) {
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)project);
        Key key = CacheKeyStore.getInstance(project).getKey("getEnableAuditingFqn");
        return (String)cacheManager.getCachedValue((UserDataHolder)project, key, () -> {
            AtomicReference<Object> enableAuditingFqn = new AtomicReference<Object>(null);
            SpringConfigurationSearch.getInstance(project).walkConfigurationClasses(GlobalSearchScope.projectScope((Project)project), (Processor<PsiClass>)((Processor)psiClass -> {
                if (psiClass.getAnnotation("org.springframework.data.r2dbc.config.EnableR2dbcAuditing") != null) {
                    enableAuditingFqn.set("org.springframework.data.r2dbc.config.EnableR2dbcAuditing");
                    return false;
                }
                if (psiClass.getAnnotation("org.springframework.data.jpa.repository.config.EnableJpaAuditing") != null) {
                    enableAuditingFqn.set("org.springframework.data.jpa.repository.config.EnableJpaAuditing");
                    return false;
                }
                if (psiClass.getAnnotation("org.springframework.data.mongodb.config.EnableMongoAuditing") != null) {
                    enableAuditingFqn.set("org.springframework.data.mongodb.config.EnableMongoAuditing");
                    return false;
                }
                if (psiClass.getAnnotation("org.springframework.data.mongodb.config.EnableReactiveMongoAuditing") != null) {
                    enableAuditingFqn.set("org.springframework.data.mongodb.config.EnableReactiveMongoAuditing");
                    return false;
                }
                return true;
            }));
            return CachedValueProvider.Result.create((Object)enableAuditingFqn.get(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/JpaUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/JpaUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformPrefix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "separateByCamelCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runWriteCommandAction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isHibernate_6_1_Project";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isHibernate_6_2_Project";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHibernate_5_6_Plus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isHibernateVersionPlus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSpringDataMongoDbProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryClassInAllScope";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "separateByCamelCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

