/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters;

import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.platform.diagnostic.telemetry.AggregatedMetricExporter;
import com.intellij.platform.diagnostic.telemetry.MetricsExporterEntry;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import com.intellij.platform.diagnostic.telemetry.exporters.IdeaOtlpMeterProviderKt;
import com.intellij.platform.diagnostic.telemetry.exporters.RollingFileSupplier;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.CsvMetricsExporter;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.TelemetryMeterJsonExporter;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.UtilKt;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReaderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/IdeaOtlpMeterProvider;", "", "<init>", "()V", "get", "Lio/opentelemetry/sdk/metrics/SdkMeterProvider;", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "aggregatedExporter", "Lcom/intellij/platform/diagnostic/telemetry/AggregatedMetricExporter;", "createMetricsExporters", "", "Lcom/intellij/platform/diagnostic/telemetry/MetricsExporterEntry;", "aggregatedMetricExporter", "createCsvExporter", "createJsonExporter", "buildWithIdeLifecycle", "Lio/opentelemetry/sdk/metrics/SdkMeterProviderBuilder;", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
public final class IdeaOtlpMeterProvider {
    @NotNull
    public static final IdeaOtlpMeterProvider INSTANCE = new IdeaOtlpMeterProvider();

    private IdeaOtlpMeterProvider() {
    }

    @NotNull
    public final SdkMeterProvider get(@NotNull Resource resource, @NotNull AggregatedMetricExporter aggregatedExporter) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)aggregatedExporter, (String)"aggregatedExporter");
        SdkMeterProviderBuilder registeredMetricsReaders = SdkMeterProvider.builder();
        ScheduledExecutorService pool = Executors.newScheduledThreadPool(1, ConcurrencyUtil.newNamedThreadFactory((String)"PeriodicMetricReader"));
        List<MetricsExporterEntry> metricsExporters = this.createMetricsExporters(aggregatedExporter);
        for (MetricsExporterEntry entry : metricsExporters) {
            for (MetricExporter metricExporter : entry.getMetrics()) {
                PeriodicMetricReaderBuilder periodicMetricReaderBuilder = PeriodicMetricReader.builder((MetricExporter)metricExporter).setExecutor(pool);
                long l = entry.getDuration-UwyO8pc();
                int n = Duration.getNanosecondsComponent-impl((long)l);
                long l2 = Duration.getInWholeSeconds-impl((long)l);
                java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
                PeriodicMetricReader metricsReader = periodicMetricReaderBuilder.setInterval(duration).build();
                registeredMetricsReaders.registerMetricReader((MetricReader)metricsReader);
            }
        }
        SdkMeterProviderBuilder sdkMeterProviderBuilder = registeredMetricsReaders.setResource(resource);
        Intrinsics.checkNotNullExpressionValue((Object)sdkMeterProviderBuilder, (String)"setResource(...)");
        return this.buildWithIdeLifecycle(sdkMeterProviderBuilder);
    }

    private final List<MetricsExporterEntry> createMetricsExporters(AggregatedMetricExporter aggregatedMetricExporter) {
        List exporters = new ArrayList();
        UtilKt.addIfNotNull((List)exporters, (Object)this.createCsvExporter());
        UtilKt.addIfNotNull((List)exporters, (Object)this.createJsonExporter());
        if (!((Collection)exporters).isEmpty()) {
            exporters.add(new MetricsExporterEntry(CollectionsKt.listOf((Object)aggregatedMetricExporter), IdeaOtlpMeterProviderKt.access$getDEFAULT_METRICS_REPORTING_PERIOD$p(), null));
        }
        return exporters;
    }

    private final MetricsExporterEntry createCsvExporter() {
        Path path = OpenTelemetryUtils.INSTANCE.metricsCsvReportingPath();
        if (path == null) {
            return null;
        }
        Path metricsCsvPath = path;
        return new MetricsExporterEntry(CollectionsKt.listOf((Object)new CsvMetricsExporter(new RollingFileSupplier(metricsCsvPath, OpenTelemetryUtils.INSTANCE.csvHeadersLines(), 0, 4, null))), IdeaOtlpMeterProviderKt.access$getCSV_METRICS_REPORTING_PERIOD$p(), null);
    }

    private final MetricsExporterEntry createJsonExporter() {
        Path path = OpenTelemetryUtils.INSTANCE.metricsJsonReportingPath();
        if (path == null) {
            return null;
        }
        Path metricsJsonPath = path;
        return new MetricsExporterEntry(CollectionsKt.listOf((Object)new TelemetryMeterJsonExporter(new RollingFileSupplier(metricsJsonPath, null, 30, 2, null))), IdeaOtlpMeterProviderKt.access$getDEFAULT_METRICS_REPORTING_PERIOD$p(), null);
    }

    private final SdkMeterProvider buildWithIdeLifecycle(SdkMeterProviderBuilder $this$buildWithIdeLifecycle) {
        SdkMeterProvider provider = $this$buildWithIdeLifecycle.build();
        ShutDownTracker.getInstance().registerShutdownTask(() -> IdeaOtlpMeterProvider.buildWithIdeLifecycle$lambda$0(provider));
        Intrinsics.checkNotNull((Object)provider);
        return provider;
    }

    private static final void buildWithIdeLifecycle$lambda$0(SdkMeterProvider $provider) {
        $provider.shutdown();
    }
}

