/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super(() -> SmRunnerBundle.message("sm.test.runner.import.test.group.history", new Object[0]), () -> SmRunnerBundle.message("sm.test.runner.import.test.group.open.recent.session", new Object[0]), () -> AllIcons.Vcs.History);
        this.setPopup(true);
        this.getTemplatePresentation().putClientProperty(RunTab.PREFERRED_PLACE, (Object)PreferredPlace.TOOLBAR);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties) {
        this();
        this.myProperties = properties;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportTestsGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project).getFiles();
        File testHistoryRoot = TestStateStorage.getTestHistoryRoot((Project)project);
        List<File> fileNames = filePaths.stream().map(fileName -> new File(testHistoryRoot, (String)fileName)).filter(file -> file.exists()).sorted(Comparator.comparingLong(File::lastModified).reversed()).toList();
        int historySize = fileNames.size();
        AnAction[] actions = new AnAction[historySize];
        for (int i = 0; i < historySize; ++i) {
            actions[i] = new ImportTestsFromHistoryAction(project, fileNames.get(i).getName(), this.myProperties != null ? this.myProperties.getExecutor() : null);
        }
        if (actions == null) {
            ImportTestsGroup.$$$reportNull$$$0(3);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

