/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeViewProvider;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerTestStateWriter;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.history.LocalHistory;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.xml.sax.ContentHandler;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    public static final String HISTORY_DATE_FORMAT = "yyyy.MM.dd 'at' HH'h' mm'm' ss's'";
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    private static final Logger LOG = Logger.getInstance(SMTestRunnerResultsForm.class);
    private static final Color RED = new JBColor(new Color(250, 220, 220), new Color(104, 67, 67));
    private static final Color GREEN = new JBColor(new Color(220, 250, 220), new Color(44, 66, 60));
    private SMTRunnerTestTreeView myTreeView;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final List<TestResultsViewer.EventsListener> myEventListeners;
    private final Project myProject;
    private final ConsoleView myConsoleView;
    private int myTotalTestCount;
    private int myStartedTestCount;
    private int myFinishedTestCount;
    private int myFailedTestCount;
    private int myIgnoredTestCount;
    private long myStartTime;
    private long myEndTime;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories;
    private volatile boolean myTestsRunning;
    private volatile AbstractTestProxy myLastSelected;
    private volatile boolean myDisposed;
    private SMTestProxy myLastFailed;
    private final Set<Update> myRequests;
    private final Alarm myUpdateTreeRequests;
    private final String myHistoryFileName;

    @ApiStatus.Internal
    public SMTestRunnerResultsForm(@NotNull ConsoleView consoleView, @NotNull TestConsoleProperties consoleProperties, @Nullable String splitterPropertyName) {
        if (consoleView == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(1);
        }
        super(consoleView.getComponent(), consoleView.createConsoleActions(), consoleProperties, StringUtil.notNullize((String)splitterPropertyName, (String)DEFAULT_SM_RUNNER_SPLITTER_PROPERTY), 0.2f);
        this.myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myTestsRunning = true;
        this.myDisposed = false;
        this.myRequests = Collections.synchronizedSet(new HashSet());
        this.myUpdateTreeRequests = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProject = consoleProperties.getProject();
        this.myConsoleView = consoleView;
        this.myTestsRootNode = new SMTestProxy.SMRootTestProxy(consoleProperties.isPreservePresentableName(), consoleView.getComponent());
        this.myTestsRootNode.setTestConsoleProperties(consoleProperties);
        this.myHistoryFileName = PathUtil.suggestFileName((String)consoleProperties.getConfiguration().getName()) + " - " + new SimpleDateFormat(HISTORY_DATE_FORMAT).format(new Date());
    }

    @ApiStatus.Internal
    protected ToolbarPanel createToolbarPanel() {
        ToolbarPanel toolbarPanel = new ToolbarPanel(this.myProperties, (JComponent)((Object)this));
        toolbarPanel.setModel((TestFrameworkRunningModel)this);
        return toolbarPanel;
    }

    @ApiStatus.Internal
    protected JComponent createTestTreeView() {
        TestConsoleProperties testConsoleProperties = this.myProperties;
        if (testConsoleProperties instanceof SMTRunnerTestTreeViewProvider) {
            SMTRunnerTestTreeViewProvider provider = (SMTRunnerTestTreeViewProvider)testConsoleProperties;
            this.myTreeView = provider.createSMTRunnerTestTreeView();
        } else {
            this.myTreeView = new SMTRunnerTestTreeView();
        }
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        StructureTreeModel structureTreeModel = new StructureTreeModel((AbstractTreeStructure)structure, (Comparator)IndexComparator.getInstance(), (Disposable)this.myProject);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)structureTreeModel, true, (Disposable)this.myProject);
        this.myTreeView.setModel((TreeModel)asyncTreeModel);
        this.myTreeBuilder.setModel(structureTreeModel);
        this.myTreeBuilder.setTestsComparator(this);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        Disposer.register((Disposable)this, (Disposable)asyncTreeModel);
        TrackRunningTestUtil.installStopListeners((JTree)((Object)this.myTreeView), (Disposable)this.myProperties, testProxy -> {
            if (testProxy == null) {
                return;
            }
            this.setLastSelected((AbstractTestProxy)testProxy);
            if (ScrollToTestSourceAction.isScrollEnabled((TestFrameworkRunningModel)this)) {
                ReadAction.nonBlocking(() -> TestsUIUtil.getOpenFileDescriptor((AbstractTestProxy)testProxy, (TestFrameworkRunningModel)this)).finishOnUiThread(ModalityState.nonModal(), descriptor -> {
                    if (descriptor != null) {
                        OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{descriptor});
                    }
                }).expireWith((Disposable)this).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        });
        return this.myTreeView;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    @ApiStatus.Internal
    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(2);
        }
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myTestsRunning = true;
        this.myLastFailed = null;
        this.setLastSelected(null);
        this.myMentionedCategories.clear();
        if (this.myEndTime != 0L) {
            this.resetTreeAndConsoleOnSubsequentTestingStarted();
            this.myEndTime = 0L;
        }
        this.myTreeBuilder.updateFromRoot();
        this.myStatusLine.setStatus("passed");
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        boolean printTestingStartedTime = true;
        if (this.myProperties instanceof SMTRunnerConsoleProperties) {
            printTestingStartedTime = ((SMTRunnerConsoleProperties)this.myProperties).isPrintTestingStartedTime();
        }
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.myStatusLine.setIndeterminate(this.isUndefined());
        this.fireOnTestingStarted();
    }

    private void resetTreeAndConsoleOnSubsequentTestingStarted() {
        this.myTestsRootNode.testingRestarted();
        this.myConsoleView.clear();
        ProcessHandler handler = this.myTestsRootNode.getHandler();
        if (handler instanceof BaseOSProcessHandler) {
            handler.notifyTextAvailable(((BaseOSProcessHandler)handler).getCommandLineForLog() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    @Override
    @ApiStatus.Internal
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(3);
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress(true);
        this.myStatusLine.setIndeterminate(false);
        if (Registry.is((String)"test.view.hide.progress.bar.on.tests.finished", (boolean)false)) {
            this.myStatusLine.hideProgressBar();
        }
        this.myRequests.clear();
        this.myUpdateTreeRequests.cancelAllRequests();
        this.myTreeBuilder.updateFromRoot();
        SMTestRunnerResultsForm.addLabel(this);
        if (this.myLastSelected == null) {
            this.selectAndNotify(this.myTestsRootNode);
        }
        this.myTestsRunning = false;
        if (TestConsoleProperties.SORT_BY_DURATION.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.setTestsComparator(this);
        }
        this.fireOnTestingFinished();
        if (testsRoot.isEmptySuite() && testsRoot.isTestsReporterAttached() && this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).fixEmptySuite()) {
            return;
        }
        TestsUIUtil.TestResultPresentation presentation = new TestsUIUtil.TestResultPresentation((AbstractTestProxy)testsRoot, this.myStartTime > 0L, null).getPresentation(this.myFailedTestCount, Math.max(0, this.myFinishedTestCount - this.myFailedTestCount - this.myIgnoredTestCount), this.myTotalTestCount - this.myStartedTestCount, this.myIgnoredTestCount);
        UIUtil.invokeLaterIfNeeded(() -> WriteIntentReadAction.run(() -> {
            TestsUIUtil.notifyByBalloon((Project)this.myProperties.getProject(), (AbstractTestProxy)testsRoot, (TestConsoleProperties)this.myProperties, (TestsUIUtil.TestResultPresentation)presentation);
            this.addToHistory(testsRoot, this.myProperties, this);
        }));
    }

    private void addToHistory(SMTestProxy.SMRootTestProxy root, TestConsoleProperties consoleProperties, Disposable parentDisposable) {
        RunProfile configuration = consoleProperties.getConfiguration();
        if (configuration instanceof RunConfiguration && !(consoleProperties instanceof ImportedTestConsoleProperties) && !this.isDisposed()) {
            final MySaveHistoryTask backgroundable = new MySaveHistoryTask(consoleProperties, root, (RunConfiguration)configuration, this.myHistoryFileName);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    backgroundable.dispose();
                }
            });
            ProgressManager.getInstance().run((Task)backgroundable);
        }
    }

    @Override
    @ApiStatus.Internal
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    @ApiStatus.Internal
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(4);
        }
        if (!testProxy.isConfig() && !"Class Configuration".equals(testProxy.getName())) {
            this.updateOnTestStarted(false);
        }
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    @ApiStatus.Internal
    public void onSuiteTreeNodeAdded(SMTestProxy testProxy) {
        if (!testProxy.isSuite()) {
            ++this.myTotalTestCount;
        }
    }

    @Override
    @ApiStatus.Internal
    public void onSuiteTreeStarted(SMTestProxy suite) {
    }

    @Override
    @ApiStatus.Internal
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(5);
        }
        if (Comparing.equal((Object)((Object)test), (Object)((Object)this.myLastFailed))) {
            return;
        }
        this.myLastFailed = test;
        this.updateOnTestFailed(false);
        if (test.isConfig()) {
            ++this.myStartedTestCount;
            ++this.myFinishedTestCount;
        } else if (test.isSuite()) {
            ++this.myStartedTestCount;
            this.updateTotalCount();
        }
        this.updateIconProgress(false);
        if (this.myLastSelected != null && TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.expand(test);
        }
    }

    @Override
    @ApiStatus.Internal
    public void onTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(6);
        }
        this.updateOnTestIgnored(test);
    }

    @Override
    @ApiStatus.Internal
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        if (newSuite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(7);
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    @ApiStatus.Internal
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    @ApiStatus.Internal
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    @ApiStatus.Internal
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    @ApiStatus.Internal
    public void onCustomProgressTestFinished() {
        this.updateOnTestFinished(true);
    }

    @Override
    @ApiStatus.Internal
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(8);
        }
        if (!test.isConfig()) {
            this.updateOnTestFinished(false);
        }
        this.updateIconProgress(false);
    }

    @Override
    @ApiStatus.Internal
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
        if (suite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(9);
        }
    }

    @Override
    @NotNull
    public SMTestProxy.SMRootTestProxy getTestsRootNode() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(10);
        }
        return sMRootTestProxy;
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    public void setFilter(@NotNull Filter filter) {
        if (filter == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(11);
        }
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.updateFromRoot();
    }

    public boolean isRunning() {
        return this.myTestsRunning;
    }

    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    public SMTRunnerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public boolean hasTestSuites() {
        return !this.getRoot().getChildren().isEmpty();
    }

    @NotNull
    public AbstractTestProxy getRoot() {
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(12);
        }
        return sMRootTestProxy;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                @Nullable SMTestProxy selectedProxy = (SMTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    private boolean isDisposed() {
        return this.myDisposed || Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.myEventListeners.clear();
        this.myDisposed = true;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    public int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    public int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    public int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    @ApiStatus.Internal
    public String getTestsStatus() {
        return this.myStatusLine.getStatus();
    }

    @ApiStatus.Internal
    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public long getStartTime() {
        return this.myStartTime;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(13);
        }
        final SMTestProxy parentSuite = newTestOrSuite.getParent();
        Update update = new Update(ObjectUtils.notNull((Object)((Object)parentSuite), (Object)this.getRoot())){

            public void run() {
                if (parentSuite == null || parentSuite.getParent() == null) {
                    SMTestRunnerResultsForm.this.myUpdateTreeRequests.cancelAllRequests();
                    SMTestRunnerResultsForm.this.myRequests.clear();
                    SMTestRunnerResultsForm.this.myTreeBuilder.updateFromRoot();
                } else {
                    SMTestRunnerResultsForm.this.myRequests.remove((Object)this);
                    SMTestRunnerResultsForm.this.myTreeBuilder.updateTestsSubtree(parentSuite);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            update.run();
        } else if (!this.isDisposed() && this.myRequests.add(update)) {
            this.myUpdateTreeRequests.addRequest((Runnable)update, 50);
        }
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && (this.myLastSelected == null || this.myLastSelected == newTestOrSuite || this.isFiltered(this.myLastSelected))) {
            this.setLastSelected(null);
            this.selectAndNotify(newTestOrSuite);
        }
    }

    private boolean isFiltered(AbstractTestProxy proxy) {
        return proxy instanceof SMTestProxy && !this.getTreeBuilder().getTreeStructure().getFilter().shouldAccept((AbstractTestProxy)((SMTestProxy)proxy));
    }

    private void setLastSelected(AbstractTestProxy proxy) {
        this.myLastSelected = proxy;
    }

    private void fireOnTestNodeAdded(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(14);
        }
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        if (this.myTreeBuilder.isDisposed()) {
            return;
        }
        this.myTreeBuilder.select(testProxy, onDone);
    }

    @ApiStatus.Internal
    public void redrawStatusLabel() {
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            this.myStatusLine.formatTestMessage(this.isUndefined() ? -1 : this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myIgnoredTestCount, this.myTestsRootNode.getCustomizedDuration(this.myProperties), this.myEndTime);
        }
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        this.myStatusLine.showProgressBar();
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatus("failed");
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            this.myStatusLine.formatTestMessage(this.isUndefined() ? -1 : this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myIgnoredTestCount, this.myTestsRootNode.getCustomizedDuration(this.myProperties), this.myEndTime);
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myMentionedCategories, launchedAndFinished));
        }
        if (testingFinished) {
            boolean noTestsWereRun = this.myTotalTestCount == 0 && (this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached());
            this.myStatusLine.onTestsDone(noTestsWereRun ? null : () -> {
                TestStateInfo.Magnitude magnitude = this.myTestsRootNode.getMagnitudeInfo();
                if (magnitude == null) {
                    return null;
                }
                return TestIconMapper.getToolbarIcon((TestStateInfo.Magnitude)magnitude, (boolean)this.myTestsRootNode.hasErrors(), () -> this.myTestsRootNode.hasPassedTests());
            });
            Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            this.myConsole.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)6), (Border)new SideBorder(editorBackground, 1)));
            this.revalidate();
            this.repaint();
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myTreeView.setAccessibleStatus(this.myStatusLine.getStateText()));
    }

    private boolean isUndefined() {
        return this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).isUndefined();
    }

    @ApiStatus.Internal
    public void performUpdate() {
        this.myTreeBuilder.updateFromRoot();
    }

    private void updateIconProgress(boolean updateWithAttention) {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount;
        }
        UIUtil.invokeLaterIfNeeded(() -> TestsUIUtil.showIconProgress((Project)this.myProject, (int)doneTestCount, (int)totalTestCount, (int)this.myFailedTestCount, (boolean)updateWithAttention));
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        this.updateTotalCount();
        this.updateStatusLabel(false);
    }

    private void updateTotalCount() {
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount;
        if (this.isUndefined()) {
            this.myStatusLine.setFraction(1.0);
        } else if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestIgnored(@NotNull SMTestProxy test) {
        if (test == null) {
            SMTestRunnerResultsForm.$$$reportNull$$$0(15);
        }
        if (!test.isSuite()) {
            ++this.myIgnoredTestCount;
        }
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    @ApiStatus.Internal
    public void setIncompleteIndexUsed() {
        this.myStatusLine.setWarning(SmRunnerBundle.message("suffix.incomplete.index.was.used", new Object[0]));
    }

    @ApiStatus.Internal
    public String getHistoryFileName() {
        return this.myHistoryFileName;
    }

    @ApiStatus.Internal
    AnAction[] getToolbarActions() {
        return this.myToolbarPanel.getActionsToMerge();
    }

    @ApiStatus.Internal
    AnAction[] getAdditionalToolbarActions() {
        return this.myToolbarPanel.getAdditionalActionsToMerge();
    }

    protected void hideToolbar() {
        super.hideToolbar();
        this.myToolbarPanel.setVisible(false);
    }

    private static void addLabel(TestFrameworkRunningModel model) {
        String name;
        int color;
        AbstractTestProxy root = model.getRoot();
        if (root.isInterrupted()) {
            return;
        }
        TestConsoleProperties consoleProperties = model.getProperties();
        String configName = consoleProperties.getConfiguration().getName();
        if (root.isPassed() || root.isIgnored()) {
            color = GREEN.getRGB();
            name = ExecutionBundle.message((String)"junit.running.info.tests.passed.with.test.name.label", (Object[])new Object[]{configName});
        } else {
            color = RED.getRGB();
            name = ExecutionBundle.message((String)"junit.running.info.tests.failed.with.test.name.label", (Object[])new Object[]{configName});
        }
        Project project = consoleProperties.getProject();
        if (project.isDisposed()) {
            return;
        }
        LocalHistory.getInstance().putSystemLabel(project, name, color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSuite";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestOrSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsRootNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestingStarted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTestingFinished";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onTestStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTestIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteStarted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteFinished";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "_addTestOrSuite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireOnTestNodeAdded";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateOnTestIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12 -> new IllegalStateException(string);
        };
    }

    private static class MySaveHistoryTask
    extends Task.Backgroundable {
        private final TestConsoleProperties myConsoleProperties;
        private SMTestProxy.SMRootTestProxy myRoot;
        private RunConfiguration myConfiguration;
        private File myOutputFile;

        MySaveHistoryTask(TestConsoleProperties consoleProperties, SMTestProxy.SMRootTestProxy root, RunConfiguration configuration, String outputFile) {
            super(consoleProperties.getProject(), SmRunnerBundle.message("sm.test.runner.results.form.save.test.results.title", new Object[0]), true);
            this.myConsoleProperties = consoleProperties;
            this.myRoot = root;
            this.myConfiguration = configuration;
            this.myOutputFile = new File(TestStateStorage.getTestHistoryRoot((Project)this.myProject), outputFile + ".xml");
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MySaveHistoryTask.$$$reportNull$$$0(0);
            }
            this.writeState();
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart((Object)this);
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newDefaultInstance();
                TransformerHandler handler = transformerFactory.newTransformerHandler();
                handler.getTransformer().setOutputProperty("indent", "yes");
                handler.getTransformer().setOutputProperty("version", "1.1");
                handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                FileUtilRt.createParentDirs((File)this.myOutputFile);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.myOutputFile, StandardCharsets.UTF_8));){
                    handler.setResult(new StreamResult(writer));
                    SMTestProxy.SMRootTestProxy root = this.myRoot;
                    RunConfiguration configuration = this.myConfiguration;
                    if (root != null && configuration != null) {
                        TestResultsXmlFormatter.execute((AbstractTestProxy)root, (RunConfiguration)configuration, (TestConsoleProperties)this.myConsoleProperties, (ContentHandler)handler);
                    }
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info("Export to history failed", (Throwable)e);
            }
        }

        private void writeState() {
            if (this.myRoot == null) {
                return;
            }
            List<SMTestProxy> tests = this.myRoot.getAllTests();
            for (SMTestProxy proxy : tests) {
                String url = proxy.getLocationUrl();
                if (url == null || proxy.getLocator() == null) continue;
                SMTestRunnerTestStateWriter.writeState(this.getProject(), proxy, url, this.myConfiguration, this.myConsoleProperties);
            }
        }

        public void onSuccess() {
            if (this.myOutputFile != null && this.myOutputFile.exists()) {
                AbstractImportTestsAction.adjustHistory(this.myProject);
                TestHistoryConfiguration.getInstance(this.myProject).registerHistoryItem(this.myOutputFile.getName(), this.myConfiguration.getName(), this.myConfiguration.getType().getId());
            }
        }

        public void dispose() {
            this.myConfiguration = null;
            this.myRoot = null;
            this.myOutputFile = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/sm/runner/ui/SMTestRunnerResultsForm$MySaveHistoryTask", "run"));
        }
    }
}

